/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.syslogng.forward;

import com.clustercontrol.bean.OutputNotifyGroupInfo;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.calendar.ejb.session.CalendarController;
import com.clustercontrol.calendar.ejb.session.CalendarControllerHome;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import com.clustercontrol.repository.ejb.session.RepositoryControllerHome;
import com.clustercontrol.syslogng.bean.LogFilterInfo;
import com.clustercontrol.syslogng.ejb.session.SyslogNGController;
import com.clustercontrol.syslogng.ejb.session.SyslogNGControllerHome;
import com.clustercontrol.syslogng.forward.FileUtil;
import com.clustercontrol.syslogng.forward.LogFilterRepositoryInfo;
import com.clustercontrol.syslogng.forward.LogManager;
import com.clustercontrol.syslogng.forward.LoginManager;
import java.io.File;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jnp.interfaces.NamingContext;

public class EJBContoroller {
    private static final String QUEUE_CON_FACTORY = "ConnectionFactory";
    private static final String QUEUE_USER_NAME = "queue.user.name";
    private static final String QUEUE_USER_PASSWORD = "queue.user.password";
    private static final String MSG_RETRY_INTERVAL = "msg.retry.interval";
    private static final String FILTER_CHACHE_INTERVAL = "filter.cache.interval";
    private static final String MSG_FILE_PATH = "msg.file.msg.path";
    private static final String MSG_FILE_SUFFIX = "msg.file.msg.syffix";
    private static final String MAX_FILE_COUNT = "msg.max.file.count";
    private static final String QUEUE_NAME = "queue.name";
    private QueueConnection m_con;
    private Queue m_queue;
    private QueueSession m_session;
    private QueueConnectionFactory m_factory;
    private boolean m_errFlg = false;
    private long m_retryInterval = 10000L;
    private long m_cacheInterval = 600000L;
    private Properties m_props;
    private LogManager m_logManager;
    private FileUtil m_fileUtil;
    protected static Timer m_timer = new Timer(true);
    static Log log = LogFactory.getLog(EJBContoroller.class);
    private Object reconnectLock = new Object();

    public EJBContoroller(LogManager logManager, Properties props) {
        int maxFileCount;
        String casheInterval;
        this.m_logManager = logManager;
        this.m_props = props;
        String retryInterval = props.getProperty(MSG_RETRY_INTERVAL);
        if (retryInterval != null) {
            try {
                this.m_retryInterval = Long.parseLong(retryInterval);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((casheInterval = props.getProperty(FILTER_CHACHE_INTERVAL)) != null) {
            try {
                this.m_cacheInterval = Long.parseLong(casheInterval);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        String filePath = this.m_props.getProperty(MSG_FILE_PATH, ".");
        String msgSuffix = this.m_props.getProperty(MSG_FILE_SUFFIX, ".msg");
        try {
            maxFileCount = Integer.parseInt(props.getProperty(MAX_FILE_COUNT, ".txt"));
        }
        catch (Exception e) {
            maxFileCount = -1;
        }
        this.m_fileUtil = new FileUtil(filePath, msgSuffix, maxFileCount);
        if (this.initial()) {
            this.sendMsgRetry();
        }
        this.loadFilterInfo();
        m_timer.schedule((TimerTask)new ReflashFilterTask(), this.m_cacheInterval, this.m_cacheInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initial() {
        log.info((Object)"EJB\u63a5\u7d9a\u521d\u671f\u5316");
        InitialContext con = null;
        try {
            con = new InitialContext(this.m_props);
            this.m_factory = (QueueConnectionFactory)con.lookup(QUEUE_CON_FACTORY);
            this.m_con = this.m_props.getProperty(QUEUE_USER_NAME) != null ? this.m_factory.createQueueConnection(this.m_props.getProperty(QUEUE_USER_NAME), this.m_props.getProperty(QUEUE_USER_PASSWORD)) : this.m_factory.createQueueConnection();
            this.m_con.setExceptionListener((ExceptionListener)new JMSExceptionListener());
            this.m_session = this.m_con.createQueueSession(false, 1);
            String queueName = "queue/clustercontrolNotifyControl";
            if (this.m_props.getProperty(QUEUE_NAME) != null && !this.m_props.getProperty(QUEUE_NAME).equals("")) {
                log.info((Object)("queue name : " + this.m_props.getProperty(QUEUE_NAME)));
                queueName = this.m_props.getProperty(QUEUE_NAME);
            }
            this.m_queue = (Queue)con.lookup(queueName);
        }
        catch (Exception e) {
            log.error((Object)"Init", (Throwable)e);
            this.setErrFlg(true);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception e1) {}
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFilterInfo() {
        log.debug((Object)"loadFilterInfo() : start");
        Throwable lastException = null;
        boolean flg = false;
        for (int i = 0; i < 10; ++i) {
            log.debug((Object)("loadFilterInfo() : number of trials = " + i));
            ArrayList<LogFilterRepositoryInfo> filterRepList = null;
            RepositoryController repositoryController = null;
            SyslogNGController logFilter = null;
            try {
                log.debug((Object)"Login Hinemos Manager");
                NamingContext con = LoginManager.getContextManager(this.m_props).getNamingContext();
                RepositoryControllerHome m_repositoryHome = (RepositoryControllerHome)con.lookup("RepositoryController");
                SyslogNGControllerHome m_logFilterHome = (SyslogNGControllerHome)con.lookup("SyslogNGController");
                log.debug((Object)"Load syslog-ng Filter Info");
                logFilter = m_logFilterHome.create();
                repositoryController = m_repositoryHome.create();
                ArrayList filterList = logFilter.getFilterInfoList();
                filterRepList = new ArrayList<LogFilterRepositoryInfo>();
                for (LogFilterInfo filterInfo : filterList) {
                    if (!ValidConstant.typeToBoolean((int)filterInfo.getValid())) continue;
                    LogFilterRepositoryInfo filterRepInfo = new LogFilterRepositoryInfo(filterInfo);
                    String facilityID = filterInfo.getFacilityId();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("getList For:" + facilityID));
                    }
                    if (facilityID.equals("UNREGISTERED")) {
                        facilityID = "REGISTERED";
                    }
                    ArrayList facilityList = repositoryController.getExecTargetFacilityIdList(facilityID);
                    ArrayList<String> attributeList = new ArrayList<String>();
                    attributeList.add("ccNodeName");
                    attributeList.add("cn");
                    HashMap facilityAttrMap = repositoryController.getNodeDetail(facilityList, attributeList);
                    filterRepInfo.setMap(facilityAttrMap);
                    filterRepList.add(filterRepInfo);
                }
                log.debug((Object)"Set New syslog-ng Filter Info");
                this.m_logManager.add(filterRepList);
                flg = true;
            }
            catch (NamingException e) {
                log.debug((Object)"Login Hinemos Manager : fail", (Throwable)e);
                lastException = e;
            }
            catch (CreateException e) {
                log.debug((Object)"Load syslog-ng Filter Info : fail", (Throwable)e);
                lastException = e;
            }
            catch (FinderException e) {
                log.debug((Object)"Load syslog-ng Filter Info : fail", (Throwable)e);
                lastException = e;
            }
            catch (RemoteException e) {
                log.debug((Object)"Load syslog-ng Filter Info : fail", (Throwable)e);
                lastException = e;
            }
            finally {
                log.debug((Object)"Logout Hinemos Manager");
                try {
                    LoginManager.getContextManager(this.m_props).logout();
                }
                catch (NamingException e) {
                    log.error((Object)"Logout Hinemos Manager : fail", (Throwable)e);
                }
            }
            if (flg) {
                log.debug((Object)"loadFilterInfo() : success");
                return;
            }
            try {
                Thread.sleep(i * 100);
                continue;
            }
            catch (InterruptedException e) {
                log.debug((Object)"Catch InterruptedException for isRun()", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        if (lastException != null) {
            log.error((Object)"loadFilterInfo() : fail", lastException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRun(String id, OutputNotifyGroupInfo msg) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"isRun() : start");
        }
        Exception lastException = null;
        for (int i = 0; i < 10; ++i) {
            CalendarController calendarController = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)("isRun() : start id = " + id + ", msg = " + msg.getMessage() + ", number of trials = " + i));
            }
            try {
                block31: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Login Hinemos Manager");
                    }
                    NamingContext con = LoginManager.getContextManager(this.m_props).getNamingContext();
                    CalendarControllerHome calendarHome = (CalendarControllerHome)con.lookup("CalendarController");
                    calendarController = calendarHome.create();
                    try {
                        if (!calendarController.isRun(id, msg.getGenerationDate()).booleanValue()) break block31;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"isRun() : success");
                        }
                        boolean bl = true;
                        return bl;
                    }
                    catch (FinderException e) {
                        log.info((Object)("isRun() : calendarID = " + id + " is not exist! msg = " + msg.getMessage()));
                        boolean bl = true;
                        return bl;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("isRun() : calendarID = " + id + ", It is non-operating day"));
                }
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"iisRun() : fail", (Throwable)e);
                }
                lastException = e;
            }
            finally {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Logout Hinemos Manager");
                }
                try {
                    LoginManager.getContextManager(this.m_props).logout();
                }
                catch (NamingException e) {
                    log.error((Object)"Logout Hinemos Manager : fail", (Throwable)e);
                }
            }
            try {
                Thread.sleep(i * 100);
                continue;
            }
            catch (InterruptedException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Catch InterruptedException for isRun()", (Throwable)e);
                }
                Thread.currentThread().interrupt();
            }
        }
        log.info((Object)"Write Message To Files");
        this.m_logManager.addMsg(msg.getMessageOrg());
        this.setErrFlg(true);
        if (lastException != null) {
            log.error((Object)("isRun() : fail id = " + id + ", msg = " + msg.getMessage()), (Throwable)lastException);
        }
        return true;
    }

    public synchronized void sendMsg(OutputNotifyGroupInfo msg) {
        if (!this._sendMsg(msg)) {
            log.debug((Object)"\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u30e1\u30c3\u30bb\u30fc\u30b8\u30d5\u30a1\u30a4\u30eb\u66f8\u304d\u8fbc\u307f!");
            this.m_fileUtil.write(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _sendMsg(Object msg) {
        if (this.isErrFlg()) {
            return false;
        }
        QueueSender sender = null;
        try {
            sender = this.m_session.createSender(this.m_queue);
            ObjectMessage mess = this.m_session.createObjectMessage((Serializable)msg);
            log.debug((Object)"\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u30e1\u30c3\u30bb\u30fc\u30b8\u9001\u4fe1!");
            sender.send((Message)mess);
        }
        catch (JMSException e) {
            log.error((Object)e);
            this.setErrFlg(true);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (sender != null) {
                    sender.close();
                }
            }
            catch (Exception e1) {}
        }
        return true;
    }

    private synchronized void sendMsgRetry() {
        File file;
        Object msg;
        log.debug((Object)"\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u30e1\u30c3\u30bb\u30fc\u30b8\u518d\u9001\u4fe1\u51e6\u7406!");
        Collection col = this.m_fileUtil.getFileList();
        Iterator iter = col.iterator();
        while (iter.hasNext() && this._sendMsg(msg = this.m_fileUtil.readMsgFile(file = (File)iter.next()))) {
            file.delete();
        }
    }

    public void terminate() {
        m_timer.cancel();
        this._terminate();
    }

    public void _terminate() {
        try {
            if (this.m_session != null) {
                this.m_session.close();
            }
            log.debug((Object)"Session close was successful.");
        }
        catch (JMSException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            if (this.m_con != null) {
                this.m_con.close();
            }
            log.debug((Object)"Connection close was successful.");
        }
        catch (JMSException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private synchronized void setErrFlg(boolean errFlg) {
        if (!this.m_errFlg && errFlg) {
            m_timer.schedule((TimerTask)new ReSetupTask(), this.m_retryInterval, this.m_retryInterval);
        }
        this.m_errFlg = errFlg;
    }

    private synchronized boolean isErrFlg() {
        return this.m_errFlg;
    }

    private synchronized boolean reInitial() {
        boolean ret = false;
        log.info((Object)"\u518d\u63a5\u7d9a\u51e6\u7406!");
        this._terminate();
        if (this.initial()) {
            ret = true;
            log.info((Object)"\u518d\u63a5\u7d9a\u51e6\u7406:\u6210\u529f!");
            this.setErrFlg(false);
            this.loadFilterInfo();
            this.sendMsgRetry();
        } else {
            log.info((Object)"\u518d\u63a5\u7d9a\u51e6\u7406:\u5931\u6557!");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect() {
        Object object = this.reconnectLock;
        synchronized (object) {
            this.setErrFlg(true);
            this._terminate();
        }
    }

    protected class JMSExceptionListener
    implements ExceptionListener {
        protected JMSExceptionListener() {
        }

        public void onException(JMSException e) {
            log.info((Object)("onException : try reconnect : " + e.getMessage()), (Throwable)e);
            EJBContoroller.this.m_logManager.reConnection();
        }
    }

    protected class ReSetupTask
    extends TimerTask {
        protected ReSetupTask() {
        }

        public void run() {
            log.info((Object)"timer task");
            if (EJBContoroller.this.reInitial()) {
                this.cancel();
            }
        }
    }

    protected class ReflashFilterTask
    extends TimerTask {
        protected ReflashFilterTask() {
        }

        public void run() {
            EJBContoroller.this.loadFilterInfo();
        }
    }
}

