/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.factory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.commons.ejb.UsedFacilityException;
import com.clustercontrol.repository.ejb.entity.DeviceInfoLocal;
import com.clustercontrol.repository.ejb.entity.FacilityLocal;
import com.clustercontrol.repository.ejb.entity.FacilityTreeLocal;
import com.clustercontrol.repository.ejb.entity.FacilityTreeUtil;
import com.clustercontrol.repository.ejb.entity.FacilityUtil;
import com.clustercontrol.repository.ejb.entity.FileSystemInfoLocal;
import com.clustercontrol.repository.factory.CheckFacility;
import com.clustercontrol.repository.util.SendTopic;
import com.clustercontrol.util.apllog.AplLogger;
import java.util.Collection;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeleteFacility {
    protected static Log m_log = LogFactory.getLog(DeleteFacility.class);

    public void deleteNode(String facilityId) throws FinderException, RemoveException, NamingException, UsedFacilityException {
        this.deleteNode(facilityId, true);
    }

    public void deleteNode(String facilityId, boolean sendFlg) throws FinderException, RemoveException, NamingException, UsedFacilityException {
        AccessLock.lock((String)"REPOSITORY");
        new CheckFacility().isUseFacility(facilityId);
        try {
            FacilityLocal facility = FacilityUtil.getLocalHome().findByFacilityId(facilityId);
            Collection collection = facility.getFacilityTree();
            if (collection != null) {
                for (FacilityTreeLocal facilityTree : collection) {
                    this.removeFacilityTree(facilityTree);
                }
            }
            this.removeFacility(facility);
            if (sendFlg) {
                SendTopic.sendTopic("topic/clustercontrolRepositoryUpdate");
            }
        }
        catch (EJBException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            Object[] args = new String[]{facilityId};
            apllog.put("SYS", "010", args);
            m_log.debug((Object)("deleteNode() : " + e.getMessage()));
            throw e;
        }
        catch (RemoveException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            Object[] args = new String[]{facilityId};
            apllog.put("SYS", "010", args);
            m_log.debug((Object)("deleteNode() : " + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            Object[] args = new String[]{facilityId};
            apllog.put("SYS", "010", args);
            m_log.debug((Object)("deleteNode() : " + e.getMessage()));
            throw e;
        }
    }

    public void deleteScope(String facilityId) throws FinderException, NamingException, RemoveException, UsedFacilityException {
        this.deleteScope(facilityId, true);
    }

    public void deleteScope(String facilityId, boolean sendFlg) throws FinderException, NamingException, RemoveException, UsedFacilityException {
        AccessLock.lock((String)"REPOSITORY");
        new CheckFacility().isUseFacility(facilityId);
        try {
            FacilityLocal facility = FacilityUtil.getLocalHome().findByFacilityId(facilityId);
            Collection collection = facility.getFacilityTree();
            if (collection != null) {
                for (FacilityTreeLocal facilityTree : collection) {
                    this.removeFacilityTree(facilityTree);
                }
            }
            if (sendFlg) {
                SendTopic.sendTopic("topic/clustercontrolRepositoryUpdate");
            }
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            Object[] args = new String[]{facilityId};
            apllog.put("SYS", "013", args);
            m_log.debug((Object)("deleteScope() : " + e.getMessage()));
            throw e;
        }
        catch (EJBException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            Object[] args = new String[]{facilityId};
            apllog.put("SYS", "013", args);
            m_log.debug((Object)("deleteScope() : " + e.getMessage()));
            throw e;
        }
        catch (RemoveException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            Object[] args = new String[]{facilityId};
            apllog.put("SYS", "013", args);
            m_log.debug((Object)("deleteScope() : " + e.getMessage()));
            throw e;
        }
    }

    public void releaseNodeScope(String parentFacilityId, String[] facilityIds) throws FinderException, NamingException, RemoveException {
        this.releaseNodeScope(parentFacilityId, facilityIds, true);
    }

    public void releaseNodeScope(String parentFacilityId, String[] facilityIds, boolean sendFlg) throws FinderException, NamingException, RemoveException {
        AccessLock.lock((String)"REPOSITORY");
        String facilityId = null;
        try {
            Collection collection = FacilityTreeUtil.getLocalHome().findOneLevelNode(parentFacilityId);
            if (collection != null) {
                block3: for (FacilityTreeLocal facilityTree : collection) {
                    for (int i = 0; i < facilityIds.length; ++i) {
                        String nodeFacilityId = facilityTree.getFacilityId();
                        if (nodeFacilityId.compareTo(facilityIds[i]) != 0) continue;
                        facilityId = facilityIds[i];
                        this.removeFacilityTree(facilityTree);
                        continue block3;
                    }
                }
            }
            if (sendFlg) {
                SendTopic.sendTopic("topic/clustercontrolRepositoryUpdate");
            }
        }
        catch (EJBException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            Object[] args = new String[]{facilityId, parentFacilityId};
            apllog.put("SYS", "016", args);
            m_log.debug((Object)("releaseNodeScope() : " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            Object[] args = new String[]{facilityId, parentFacilityId};
            apllog.put("SYS", "016", args);
            m_log.debug((Object)("releaseNodeScope() : " + e.getMessage()));
            throw e;
        }
    }

    protected void removeFacility(FacilityLocal facility) throws RemoveException, NamingException {
        Collection collectionDevice = null;
        Collection collectionFileSystem = null;
        collectionDevice = facility.getDeviceInfo();
        collectionFileSystem = facility.getFileSystemInfo();
        try {
            if (collectionDevice != null && collectionDevice.size() > 0) {
                for (DeviceInfoLocal device : collectionDevice) {
                    device.remove();
                }
            }
            if (collectionFileSystem != null && collectionFileSystem.size() > 0) {
                for (FileSystemInfoLocal fileSystem : collectionFileSystem) {
                    fileSystem.remove();
                }
            }
            facility.remove();
        }
        catch (RemoveException e) {
            m_log.debug((Object)("removeFacility() : " + e.getMessage()));
            throw e;
        }
    }

    protected void removeFacilityTree(FacilityTreeLocal facilityTree) throws RemoveException, NamingException, FinderException {
        Collection collection = null;
        try {
            collection = facilityTree.getChildren();
        }
        catch (FinderException e) {
            m_log.debug((Object)("removeFacilityTree() : " + e.getMessage()));
        }
        if (collection != null && collection.size() > 0) {
            for (FacilityTreeLocal children : collection) {
                this.removeFacilityTree(children);
            }
        }
        try {
            FacilityLocal facility = facilityTree.getFacility();
            if (facility.getType() == 0) {
                this.removeFacility(facility);
            }
            FacilityTreeUtil.getLocalHome().remove(facilityTree.getPrimaryKey());
        }
        catch (RemoveException e) {
            m_log.debug((Object)("removeFacilityTree() : " + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            m_log.debug((Object)("removeFacilityTree() : " + e.getMessage()));
            throw e;
        }
    }
}

