/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.vm.factory;

import com.clustercontrol.repository.ejb.entity.FacilityData;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.vm.NodeOperationActionInterface;
import com.clustercontrol.vm.VmException;
import com.clustercontrol.vm.bean.NodeOperationCommandConstant;
import com.clustercontrol.vm.bean.NodeOperationEndStatusConstant;
import com.clustercontrol.vm.bean.VmMethodTypeConstant;
import com.clustercontrol.vm.ejb.entity.VmMethodMstLocal;
import com.clustercontrol.vm.ejb.entity.VmMethodMstPK;
import com.clustercontrol.vm.ejb.entity.VmMethodMstUtil;
import com.clustercontrol.vm.ejb.entity.VmOperationDetailData;
import java.lang.reflect.InvocationTargetException;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NodeOperationController {
    protected static Log m_log = LogFactory.getLog(NodeOperationController.class);

    public void action(VmOperationDetailData data) throws CreateException, NamingException, FinderException {
        VmMethodMstLocal local;
        if (data == null) {
            m_log.error((Object)"action(): VmOperationDetailData is null");
            return;
        }
        m_log.debug((Object)("action() : start sessionId = " + data.getSessionId() + ", facilityId = " + data.getFacilityId()));
        FacilityData target = null;
        FacilityData host = null;
        RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
        target = repository.getNodeFacilityData(data.getFacilityId());
        if (target == null) {
            data.setMessage(data.getFacilityId() + " is not found");
            data.setEndStatus(NodeOperationEndStatusConstant.FAIL);
            m_log.warn((Object)("action() : message = " + data.getMessage()));
            return;
        }
        if (!"guest".equals(target.getVirtNodeType())) {
            m_log.error((Object)"action () : this node is not guest");
            data.setMessage(Messages.getString((String)"message.vm.operation.20"));
            data.setEndStatus(NodeOperationEndStatusConstant.FAIL);
            return;
        }
        m_log.debug((Object)("action() : getVMManagementNode = " + target.getVMManagementNode()));
        if (target.getVMManagementNode() != null && !target.getVMManagementNode().equals("")) {
            host = repository.getNodeFacilityData(target.getVMManagementNode());
            m_log.debug((Object)("action() : host facilityId = " + host.getFacilityId()));
        } else {
            m_log.warn((Object)("action() : hostNode of " + data.getFacilityId() + " is not found"));
        }
        String className = null;
        m_log.debug((Object)("action() : getVirtSolution = " + target.getVirtSolution()));
        if (target.getVirtSolution() != null && !target.getVirtSolution().equals("")) {
            local = VmMethodMstUtil.getLocalHome().findByPrimaryKey(new VmMethodMstPK(target.getVirtSolution(), VmMethodTypeConstant.NODEOPERATION));
            if (local == null) {
                data.setMessage("Class of " + target.getVirtSolution() + "is not found at DB");
                data.setEndStatus(NodeOperationEndStatusConstant.FAIL);
                m_log.warn((Object)("action() : message = " + data.getMessage()));
                return;
            }
        } else {
            data.setMessage("VirtSolution is not registed, or VirtSolution of guest differs from host");
            data.setEndStatus(NodeOperationEndStatusConstant.FAIL);
            m_log.warn((Object)("action() : message = " + data.getMessage()));
            return;
        }
        className = local.getClassName();
        m_log.debug((Object)("action() : className = " + className));
        NodeOperationActionInterface action = null;
        try {
            action = (NodeOperationActionInterface)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
            if (action != null) {
                m_log.debug((Object)("action() : action class = " + action.getClass().getCanonicalName()));
                action.init(target, host);
            } else {
                m_log.warn((Object)"action() : action class is null");
            }
        }
        catch (VmException e) {
            data.setMessage(e.getMessage());
            data.setEndStatus(NodeOperationEndStatusConstant.FAIL);
            return;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            m_log.error((Object)("action() : message = " + e.getMessage()));
            data.setMessage(className + " could not loaded");
            data.setEndStatus(NodeOperationEndStatusConstant.FAIL);
            return;
        }
        try {
            Short endStatus;
            if (data.getCommandId().equals(NodeOperationCommandConstant.G_POWERON)) {
                endStatus = action.guestPowerOn();
                data.setEndStatus(endStatus);
            } else if (data.getCommandId().equals(NodeOperationCommandConstant.G_POWEROFF)) {
                endStatus = action.guestPowerOff();
                data.setEndStatus(endStatus);
            } else {
                m_log.error((Object)("command not found : " + data.getCommandId()));
            }
        }
        catch (VmException e) {
            data.setMessage(e.getMessage());
            data.setEndStatus(NodeOperationEndStatusConstant.FAIL);
            m_log.error((Object)("VmException : " + e.getMessage()));
            return;
        }
        m_log.debug((Object)("action() : end sessionId = " + data.getSessionId() + ", status = " + data.getStatus() + ", endStatus = " + data.getEndStatus() + ", facilityId = " + data.getFacilityId() + ", message = " + data.getMessage()));
    }
}

