/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.util;

import com.clustercontrol.bean.OutputNotifyGroupInfo;
import com.clustercontrol.commons.util.SendQueue;
import com.clustercontrol.jobmanagement.bean.JobTriggerInfo;
import com.clustercontrol.jobmanagement.ejb.session.JobControllerLocal;
import com.clustercontrol.jobmanagement.ejb.session.JobControllerUtil;
import com.clustercontrol.notify.ejb.entity.NotifyInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyInfoUtil;
import com.clustercontrol.notify.ejb.entity.NotifyJobInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyJobInfoPK;
import com.clustercontrol.notify.ejb.entity.NotifyJobInfoUtil;
import com.clustercontrol.notify.util.InhibitAction;
import com.clustercontrol.util.Messages;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RunJob
extends InhibitAction {
    protected static Log m_log = LogFactory.getLog(RunJob.class);
    private SendQueue m_queue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void runJob(OutputNotifyGroupInfo outputInfo) throws RemoteException, NamingException, CreateException, FinderException {
        NotifyInfoLocal notifyInfo = NotifyInfoUtil.getLocalHome().findByPrimaryKey(outputInfo.getNotifyId());
        NotifyJobInfoLocal jobInfo = NotifyJobInfoUtil.getLocalHome().findByPrimaryKey(new NotifyJobInfoPK(outputInfo.getNotifyId(), outputInfo.getPriority()));
        if (jobInfo == null) {
            m_log.debug((Object)"onMessage() : \u51fa\u529b\u3059\u308b\u91cd\u8981\u5ea6\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
            return;
        }
        if (jobInfo.getJobRun() == 1) {
            boolean isRun = false;
            if (jobInfo.getJobInhibitionFlg() == 1 && notifyInfo.getInhibitionFlg() != 0) {
                try {
                    boolean isInhibit = super.isInhibit(outputInfo, notifyInfo);
                    if (!isInhibit) {
                        isRun = true;
                    }
                }
                catch (NumberFormatException e) {
                    m_log.error((Object)("runJob() : " + e.getMessage()), (Throwable)e);
                }
                catch (RemoteException e) {
                    m_log.error((Object)("runJob() : " + e.getMessage()), (Throwable)e);
                }
                catch (CreateException e) {
                    m_log.error((Object)("runJob() : " + e.getMessage()), (Throwable)e);
                }
            } else {
                isRun = true;
            }
            if (isRun) {
                try {
                    if (jobInfo.getJobExecFacilityFlg() == 1) {
                        outputInfo.setFacilityId(jobInfo.getJobExecFacility());
                    }
                    JobTriggerInfo triggerInfo = new JobTriggerInfo();
                    triggerInfo.setTrigger_type(Integer.valueOf(3));
                    triggerInfo.setTrigger_info(outputInfo.getMonitorId() + "(" + outputInfo.getPluginId() + ")");
                    JobControllerLocal job = JobControllerUtil.getLocalHome().create();
                    job.runJob(jobInfo.getJobId(), outputInfo, triggerInfo);
                }
                catch (Exception e) {
                    outputInfo.setPriority(jobInfo.getJobFailurePriority().intValue());
                    outputInfo.setMessageId("200");
                    Object[] args1 = new String[]{jobInfo.getJobId()};
                    outputInfo.setMessage(Messages.getString((String)"message.monitor.41", (Object[])args1));
                    outputInfo.setMessageOrg("");
                    outputInfo.setOutputDate(new Timestamp(new Date().getTime()));
                    outputInfo.setNotifyGroupId(null);
                    try {
                        this.m_queue = new SendQueue("queue/clustercontrolNotifyEvent");
                        this.m_queue.put((Serializable)outputInfo);
                    }
                    catch (JMSException e1) {
                        m_log.error((Object)e1.getMessage(), (Throwable)e1);
                    }
                    finally {
                        try {
                            if (this.m_queue != null) {
                                this.m_queue.terminate();
                            }
                            this.m_queue = null;
                        }
                        catch (JMSException e1) {
                            m_log.error((Object)e1.getMessage(), (Throwable)e1);
                        }
                    }
                }
            }
        }
    }
}

