/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.monitor.dao;

import com.clustercontrol.commons.util.ConnectionManager;
import com.clustercontrol.notify.monitor.dao.StatusInfoDAO;
import com.clustercontrol.notify.monitor.ejb.entity.StatusInfoBean;
import com.clustercontrol.notify.monitor.ejb.entity.StatusInfoPK;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StatusInfoDAOImpl
implements StatusInfoDAO {
    protected static Log m_log = LogFactory.getLog(StatusInfoDAOImpl.class);

    public void init() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(StatusInfoPK pk, StatusInfoBean ejb) throws EJBException {
        m_log.debug((Object)("load() start : " + pk.toString()));
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_status_info WHERE monitor_id = ? AND plugin_id = ? AND facility_id = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.monitorId);
                stmt.setString(2, pk.pluginId);
                stmt.setString(3, pk.facilityId);
                res = stmt.executeQuery();
                if (!res.next()) {
                    String msg = "StatusInfo data is not found.";
                    m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + msg));
                    throw new EJBException(msg);
                }
                ejb.setMonitorId(res.getString("monitor_id"));
                ejb.setPluginId(res.getString("plugin_id"));
                ejb.setFacilityId(res.getString("facility_id"));
                ejb.setOutputDate(res.getTimestamp("output_date"));
                ejb.setGenerationDate(res.getTimestamp("generation_date"));
                ejb.setApplication(res.getString("application"));
                ejb.setMessageId(res.getString("message_id"));
                ejb.setMessage(res.getString("message"));
                ejb.setPriority(res.getInt("priority"));
                ejb.setExpirationFlg(res.getInt("expiration_flg"));
                ejb.setExpirationDate(res.getTimestamp("expiration_date"));
                Object var9_9 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("load() end : " + pk.toString()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void store(StatusInfoBean ejb) throws EJBException {
        m_log.debug((Object)("store() start : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate()));
        Connection conn = null;
        Statement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("UPDATE cc_status_info SET ");
                sql.append("generation_date = ?, ");
                sql.append("output_date = ?, ");
                sql.append("application = ?, ");
                sql.append("message_id = ?, ");
                sql.append("message = ?, ");
                sql.append("priority = ?, ");
                sql.append("expiration_flg = ?, ");
                sql.append("expiration_date = ? ");
                sql.append("WHERE plugin_id = ? AND ");
                sql.append("monitor_id = ? AND ");
                sql.append("facility_id = ?");
                stmt = conn.prepareStatement(sql.toString());
                stmt.setTimestamp(1, ejb.getGenerationDate());
                stmt.setTimestamp(2, ejb.getOutputDate());
                stmt.setString(3, ejb.getApplication());
                stmt.setString(4, ejb.getMessageId());
                stmt.setString(5, ejb.getMessage());
                stmt.setInt(6, ejb.getPriority());
                stmt.setInt(7, ejb.getExpirationFlg());
                stmt.setTimestamp(8, ejb.getExpirationDate());
                stmt.setString(9, ejb.getPluginId());
                stmt.setString(10, ejb.getMonitorId());
                stmt.setString(11, ejb.getFacilityId());
                int row = stmt.executeUpdate();
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("store() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + " SQLException" + msg));
                    throw new EJBException(msg);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("store() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + " SQLException"));
                e.printStackTrace();
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("store() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + " SQLException"));
                e1.printStackTrace();
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("store() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + " SQLException"));
            e1.printStackTrace();
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("store() end : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(StatusInfoPK pk) throws RemoveException, EJBException {
        m_log.debug((Object)("remove() start : " + pk.toString()));
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "DELETE FROM cc_status_info WHERE plugin_id = ? AND monitor_id = ? AND facility_id = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.pluginId);
                stmt.setString(2, pk.monitorId);
                stmt.setString(3, pk.facilityId);
                int row = stmt.executeUpdate();
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("remove() error : " + pk.toString() + " SQLException" + msg));
                    throw new EJBException(msg);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("remove() end : " + pk.toString()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StatusInfoPK create(StatusInfoBean ejb) throws CreateException, EJBException {
        StatusInfoPK pk;
        m_log.debug((Object)("create() start : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId()));
        Connection conn = null;
        Statement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("INSERT INTO cc_status_info (");
                sql.append("plugin_id, ");
                sql.append("monitor_id, ");
                sql.append("facility_id, ");
                sql.append("output_date, ");
                sql.append("generation_date, ");
                sql.append("application, ");
                sql.append("message_id, ");
                sql.append("message, ");
                sql.append("priority, ");
                sql.append("expiration_flg, ");
                sql.append("expiration_date) ");
                sql.append("values (?,?,?,?,?,?,?,?,?,?,?)");
                stmt = conn.prepareStatement(sql.toString());
                stmt.setString(1, ejb.getPluginId());
                stmt.setString(2, ejb.getMonitorId());
                stmt.setString(3, ejb.getFacilityId());
                stmt.setTimestamp(4, ejb.getOutputDate());
                stmt.setTimestamp(5, ejb.getGenerationDate());
                stmt.setString(6, ejb.getApplication());
                stmt.setString(7, ejb.getMessageId());
                stmt.setString(8, ejb.getMessage());
                stmt.setInt(9, ejb.getPriority());
                stmt.setInt(10, ejb.getExpirationFlg());
                stmt.setTimestamp(11, ejb.getExpirationDate());
                int row = stmt.executeUpdate();
                pk = new StatusInfoPK(ejb.getMonitorId(), ejb.getPluginId(), ejb.getFacilityId());
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("create() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + " SQLException"));
                    throw new EJBException(msg);
                }
                Object var9_9 = null;
            }
            catch (SQLException e) {
                if (!e.getSQLState().equals("23505")) throw new CreateException(e.getMessage());
                m_log.error((Object)("create() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("create() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("create() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("create() end : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId()));
        return pk;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection findAll() throws FinderException {
        m_log.debug((Object)"findAll() start : ");
        ArrayList<StatusInfoPK> ret = new ArrayList<StatusInfoPK>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT facility_id,monitor_id,plugin_id FROM cc_status_info";
                stmt = conn.prepareStatement(sql);
                res = stmt.executeQuery();
                while (res.next()) {
                    StatusInfoPK pk = new StatusInfoPK(res.getString("monitor_id"), res.getString("plugin_id"), res.getString("facility_id"));
                    ret.add(pk);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)"findAll() error :  SQLException");
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)"findAll() end : ");
        return ret;
    }

    public StatusInfoPK findByPrimaryKey(StatusInfoPK pk) throws FinderException {
        ResultSet res;
        PreparedStatement stmt;
        Connection conn;
        block14: {
            m_log.debug((Object)("findByPrimaryKey() start : " + pk.toString()));
            conn = null;
            stmt = null;
            res = null;
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT facility_id,monitor_id,plugin_id FROM cc_status_info WHERE plugin_id = ? AND monitor_id = ? AND facility_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.pluginId);
            stmt.setString(2, pk.monitorId);
            stmt.setString(3, pk.facilityId);
            res = stmt.executeQuery();
            if (!res.next()) break block14;
            StatusInfoPK statusInfoPK = pk;
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            return statusInfoPK;
        }
        try {
            try {
                String msg = "id " + pk.toString() + " not found.";
                throw new FinderException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection findHighPriorityStatus(String[] facilityId, Timestamp outputFromDate, Timestamp outputToDate, Timestamp generationFromDate, Timestamp generationToDate, String application, String message) throws FinderException {
        m_log.debug((Object)"findHighPriorityStatus() start : ");
        ArrayList<StatusInfoPK> ret = new ArrayList<StatusInfoPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT facility_id,monitor_id,plugin_id FROM cc_status_info ");
                sql.append("WHERE ");
                sql.append("facility_id IN (");
                for (int index = 0; index < facilityId.length; ++index) {
                    if (index != 0) {
                        sql.append(",");
                    }
                    sql.append("?");
                }
                sql.append(")");
                if (outputFromDate != null) {
                    sql.append(" and output_date >= ?");
                }
                if (outputToDate != null) {
                    sql.append("and output_date <= ?");
                }
                if (generationFromDate != null) {
                    sql.append(" and generation_date >= ?");
                }
                if (generationToDate != null) {
                    sql.append(" and generation_date <= ?");
                }
                if (application != null && !"".equals(application)) {
                    sql.append(" and application like ?");
                }
                if (message != null && !"".equals(message)) {
                    sql.append(" and message like ?");
                }
                sql.append(" ORDER BY priority, output_date DESC LIMIT 1");
                stmt = conn.prepareStatement(sql.toString());
                int count = 1;
                if (facilityId != null && facilityId.length > 0) {
                    for (int index = 0; index < facilityId.length; ++count, ++index) {
                        stmt.setString(count, facilityId[index]);
                    }
                }
                if (outputFromDate != null) {
                    stmt.setTimestamp(count, outputFromDate);
                    ++count;
                }
                if (outputToDate != null) {
                    stmt.setTimestamp(count, outputToDate);
                    ++count;
                }
                if (generationFromDate != null) {
                    stmt.setTimestamp(count, generationFromDate);
                    ++count;
                }
                if (generationToDate != null) {
                    stmt.setTimestamp(count, generationToDate);
                    ++count;
                }
                if (application != null && !"".equals(application)) {
                    stmt.setString(count, "%" + application + "%");
                    ++count;
                }
                if (message != null && !"".equals(message)) {
                    stmt.setString(count, "%" + message + "%");
                    ++count;
                }
                res = stmt.executeQuery();
                while (res.next()) {
                    StatusInfoPK pk = new StatusInfoPK(res.getString("monitor_id"), res.getString("plugin_id"), res.getString("facility_id"));
                    ret.add(pk);
                }
                Object var16_17 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)"findHighPriorityStatus() error :  SQLException");
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)"findHighPriorityStatus() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)"findHighPriorityStatus() error :  SQLException");
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)"findHighPriorityStatus() end : ");
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection findStatus(String[] facilityId, Integer priority, Timestamp outputFromDate, Timestamp outputToDate, Timestamp generationFromDate, Timestamp generationToDate, String application, String message) throws FinderException {
        m_log.debug((Object)"findStatus() start : ");
        ArrayList<StatusInfoPK> ret = new ArrayList<StatusInfoPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT facility_id,monitor_id,plugin_id FROM cc_status_info ");
                StringBuffer sqlWhere = new StringBuffer();
                if (facilityId.length > 0) {
                    sqlWhere.append("WHERE facility_id IN (");
                    for (int index = 0; index < facilityId.length; ++index) {
                        if (index != 0) {
                            sqlWhere.append(",");
                        }
                        sqlWhere.append("?");
                    }
                    sqlWhere.append(")");
                }
                if (priority != null) {
                    if (sqlWhere.length() > 0) {
                        sqlWhere.append(" AND priority = ?");
                    } else {
                        sqlWhere.append(" WHERE priority = ?");
                    }
                }
                if (outputFromDate != null) {
                    if (sqlWhere.length() > 0) {
                        sqlWhere.append(" AND output_date >= ?");
                    } else {
                        sqlWhere.append(" WHERE output_date >= ?");
                    }
                }
                if (outputToDate != null) {
                    if (sqlWhere.length() > 0) {
                        sqlWhere.append(" AND output_date <= ?");
                    } else {
                        sqlWhere.append(" WHERE output_date <= ?");
                    }
                }
                if (generationFromDate != null) {
                    if (sqlWhere.length() > 0) {
                        sqlWhere.append(" AND generation_date >= ?");
                    } else {
                        sqlWhere.append(" WHERE generation_date >= ?");
                    }
                }
                if (generationToDate != null) {
                    if (sqlWhere.length() > 0) {
                        sqlWhere.append(" AND generation_date <= ?");
                    } else {
                        sqlWhere.append(" WHERE generation_date <= ?");
                    }
                }
                if (application != null && !"".equals(application)) {
                    if (sqlWhere.length() > 0) {
                        sqlWhere.append(" AND application like ?");
                    } else {
                        sqlWhere.append(" WHERE application like ?");
                    }
                }
                if (message != null && !"".equals(message)) {
                    if (sqlWhere.length() > 0) {
                        sqlWhere.append(" AND message like ?");
                    } else {
                        sqlWhere.append(" WHERE message like ?");
                    }
                }
                sql.append(sqlWhere);
                stmt = conn.prepareStatement(sql.toString());
                int count = 1;
                if (facilityId != null && facilityId.length > 0) {
                    for (int index = 0; index < facilityId.length; ++count, ++index) {
                        stmt.setString(count, facilityId[index]);
                    }
                }
                if (priority != null) {
                    stmt.setInt(count, priority);
                    ++count;
                }
                if (outputFromDate != null) {
                    stmt.setTimestamp(count, outputFromDate);
                    ++count;
                }
                if (outputToDate != null) {
                    stmt.setTimestamp(count, outputToDate);
                    ++count;
                }
                if (generationFromDate != null) {
                    stmt.setTimestamp(count, generationFromDate);
                    ++count;
                }
                if (generationToDate != null) {
                    stmt.setTimestamp(count, generationToDate);
                    ++count;
                }
                if (application != null && !"".equals(application)) {
                    stmt.setString(count, "%" + application + "%");
                    ++count;
                }
                if (message != null && !"".equals(message)) {
                    stmt.setString(count, "%" + message + "%");
                    ++count;
                }
                res = stmt.executeQuery();
                while (res.next()) {
                    StatusInfoPK pk = new StatusInfoPK(res.getString("monitor_id"), res.getString("plugin_id"), res.getString("facility_id"));
                    ret.add(pk);
                }
                Object var18_19 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)"findStatus() error :  SQLException");
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var18_20 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)"findStatus() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)"findStatus() error :  SQLException");
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)"findStatus() end : ");
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection findExpirationStatus(Timestamp expirationDate) throws FinderException {
        m_log.debug((Object)"findExpirationStatus() start : ");
        ArrayList<StatusInfoPK> ret = new ArrayList<StatusInfoPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT facility_id,monitor_id,plugin_id FROM cc_status_info ");
                sql.append("WHERE expiration_date <= ?");
                stmt = conn.prepareStatement(sql.toString());
                stmt.setTimestamp(1, expirationDate);
                res = stmt.executeQuery();
                while (res.next()) {
                    StatusInfoPK pk = new StatusInfoPK(res.getString("monitor_id"), res.getString("plugin_id"), res.getString("facility_id"));
                    ret.add(pk);
                }
                Object var9_9 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)"findExpirationStatus() error :  SQLException");
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)"findExpirationStatus() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)"findExpirationStatus() error :  SQLException");
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)"findExpirationStatus() end : ");
        return ret;
    }
}

