/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.ejb.session;

import com.clustercontrol.performance.ejb.bmp.Collector;
import com.clustercontrol.performance.ejb.bmp.CollectorHome;
import com.clustercontrol.performance.ejb.bmp.CollectorPK;
import com.clustercontrol.performance.util.JNDIConnectionManager;
import com.clustercontrol.quartzmanager.ejb.session.QuartzManager;
import com.clustercontrol.quartzmanager.util.QuartzUtil;
import com.clustercontrol.util.apllog.AplLogger;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.TransactionRolledbackLocalException;
import javax.naming.NamingException;
import javax.transaction.TransactionRolledbackException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.jobs.ee.ejb.EJBInvokerJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectorRunControllerBean
implements SessionBean {
    private static final long serialVersionUID = 1L;
    protected static Log m_log = LogFactory.getLog(CollectorRunControllerBean.class);

    public void managePresavePeriod() throws FinderException, NamingException {
        m_log.debug((Object)"managePresavePeriod() :  start");
        ArrayList<CollectorPK> list = this.getPresaveCollectorList();
        for (CollectorPK pk : list) {
            m_log.debug((Object)("managePresavePeriod() :  do collectorId = " + pk.getCollectorID()));
            this._managePresavePeriod(pk);
        }
        m_log.debug((Object)"managePresavePeriod() :  end");
    }

    public ArrayList<CollectorPK> getPresaveCollectorList() throws FinderException, NamingException {
        m_log.debug((Object)"getPresaveCollectorList() :  start");
        ArrayList<CollectorPK> list = new ArrayList<CollectorPK>();
        CollectorHome home = JNDIConnectionManager.getCollectorHome();
        try {
            Collection myBeans = home.findByPresave();
            for (Collector bean : myBeans) {
                m_log.debug((Object)("getPresaveCollectorList() :  add collectorId = " + bean.getCollectorID()));
                CollectorPK pk = new CollectorPK(bean.getCollectorID());
                list.add(pk);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (FinderException e) {
            e.printStackTrace();
        }
        m_log.debug((Object)"getPresaveCollectorList() :  end");
        return list;
    }

    public void _managePresavePeriod(CollectorPK pk) throws FinderException, NamingException {
        block6: {
            m_log.debug((Object)("_managePresavePeriod() :  start collectorId = " + pk.getCollectorID()));
            CollectorHome home = JNDIConnectionManager.getCollectorHome();
            try {
                Collector bean = home.findByPrimaryKey(pk);
                if (bean.getPresavePeriod() < 0) break block6;
                Calendar cal = Calendar.getInstance();
                cal.add(5, -bean.getPresavePeriod());
                cal.set(14, 0);
                cal.set(13, 0);
                Date startDate = cal.getTime();
                m_log.debug((Object)("_managePresavePeriod() :  presaveDate  " + startDate.toString()));
                if (!startDate.after(bean.getStartDate())) break block6;
                bean.setStartDate(startDate);
                try {
                    m_log.debug((Object)("_managePresavePeriod() :  do managePresave collectorId = " + pk.getCollectorID()));
                    bean.managePresave(startDate);
                }
                catch (TransactionRolledbackException e) {
                    m_log.warn((Object)("Failed to delete : " + pk.getCollectorID()));
                    m_log.warn((Object)e.getMessage(), (Throwable)e);
                    AplLogger apllog = new AplLogger("PERF", "perf");
                    apllog.put("SYS", "012");
                    throw e;
                }
                catch (TransactionRolledbackLocalException e) {
                    m_log.warn((Object)("Failed to delete : " + pk.getCollectorID()));
                    m_log.warn((Object)e.getMessage(), (Throwable)e);
                    AplLogger apllog = new AplLogger("PERF", "perf");
                    apllog.put("SYS", "012");
                    throw e;
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            catch (FinderException e) {
                e.printStackTrace();
            }
        }
        m_log.debug((Object)("_managePresavePeriod() :  end collectorId = " + pk.getCollectorID()));
    }

    public void addQuartz(String cronString) throws NamingException, ParseException, SchedulerException {
        QuartzManager manager = QuartzUtil.getQuartzManager();
        try {
            manager.deleteSchedule("CollectorRunController", "PERF_COLLECT");
        }
        catch (SchedulerException e) {
            m_log.debug((Object)("addQuartz() : deleteJob error = " + e.getMessage()));
        }
        catch (RemoteException e) {
            // empty catch block
        }
        JobDetail job = new JobDetail("CollectorRunController", "PERF_COLLECT", EJBInvokerJob.class);
        String serverName = System.getProperty("jboss.server.name");
        if (serverName.equals("all")) {
            job.getJobDataMap().put("java.naming.provider.url", "jnp://localhost:1100");
        }
        job.setDurability(true);
        job.getJobDataMap().put("ejb", "CollectorRunController");
        job.getJobDataMap().put("method", "managePresavePeriod");
        CronTrigger cronTrigger = new CronTrigger("CollectorRunController", "PERF_COLLECT");
        cronTrigger.setMisfireInstruction(2);
        cronTrigger.setCronExpression(cronString);
        try {
            manager.addSchedule(job, (Trigger)cronTrigger);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void deleteQuartz() throws NamingException, ParseException, SchedulerException {
        QuartzManager manager = QuartzUtil.getQuartzManager();
        try {
            manager.deleteSchedule("CollectorRunController", "PERF_COLLECT");
        }
        catch (SchedulerException e) {
            m_log.debug((Object)("deleteQuartz() : deleteJob error = " + e.getMessage()));
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
    }

    public void ejbRemove() throws EJBException, RemoteException {
    }

    public void ejbActivate() throws EJBException, RemoteException {
    }

    public void ejbPassivate() throws EJBException, RemoteException {
    }
}

