/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.dao;

import com.clustercontrol.commons.util.ConnectionManager;
import com.clustercontrol.performance.ejb.bmp.CollectorBean;
import com.clustercontrol.performance.ejb.bmp.CollectorDAO;
import com.clustercontrol.performance.ejb.bmp.CollectorPK;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CollectorDAOImpl
implements CollectorDAO {
    protected static Log m_log = LogFactory.getLog(CollectorDAOImpl.class);

    public CollectorDAOImpl() {
        m_log.trace((Object)"\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf\u30fc in CollectorDAO");
    }

    public void init() {
        m_log.trace((Object)"init CollectorDAO");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(CollectorPK pk, CollectorBean ejb) throws EJBException {
        m_log.debug((Object)("load() start : " + pk.getCollectorID()));
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM CC_COLLECTOR_PROFILE WHERE COLLECTORID = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.collectorID);
                res = stmt.executeQuery();
                if (!res.next()) {
                    String msg = "Collector data is not found.";
                    m_log.error((Object)("load() error : " + pk.getCollectorID() + " SQLException " + msg));
                    throw new EJBException(msg);
                }
                ejb.setCollectorID(res.getString("COLLECTORID"));
                ejb.setCollectorType(res.getShort("COLLECTOR_TYPE"));
                ejb.setLabel(res.getString("LABEL"));
                Timestamp startTimestamp = res.getTimestamp("START_DATE");
                if (startTimestamp != null) {
                    ejb.setStartDate(new Date(startTimestamp.getTime()));
                } else {
                    ejb.setStartDate(null);
                }
                Timestamp stopTimestamp = res.getTimestamp("STOP_DATE");
                if (stopTimestamp != null) {
                    ejb.setStopDate(new Date(stopTimestamp.getTime()));
                } else {
                    ejb.setStopDate(null);
                }
                ejb.setFacilityID(res.getString("TARGET_FACILITYID"));
                ejb.setScopePath(res.getString("SCOPE_PATH"));
                ejb.setIntervalSec(res.getInt("INTERVAL_SEC"));
                ejb.setPeriodMin(res.getInt("PERIOD_MIN"));
                ejb.setPresavePeriod(res.getInt("PRESAVE_PERIOD"));
                Object var10_11 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("load() error : " + pk.getCollectorID() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            try {
                if (res != null) {
                    res.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("load() error : " + pk.getCollectorID() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("load() error : " + pk.getCollectorID() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (res != null) {
            res.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        ejb.updateScopeTree();
        ejb.setCollectorItems(pk.collectorID);
        m_log.debug((Object)("load() end   : " + pk.getCollectorID()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void store(CollectorBean ejb) throws EJBException {
        m_log.debug((Object)("store() start : " + ejb.getCollectorID()));
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "UPDATE CC_COLLECTOR_PROFILE SET COLLECTOR_TYPE = ?,LABEL = ?,START_DATE = ?,STOP_DATE = ?,TARGET_FACILITYID = ?,SCOPE_PATH = ?,INTERVAL_SEC = ?,PERIOD_MIN = ?,PRESAVE_PERIOD = ? WHERE COLLECTORID = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setShort(1, (short)ejb.getCollectorType());
                stmt.setString(2, ejb.getLabel());
                Date startDate = ejb.getStartDate();
                if (startDate != null) {
                    stmt.setTimestamp(3, new Timestamp(startDate.getTime()));
                } else {
                    stmt.setTimestamp(3, null);
                }
                Date stopDate = ejb.getStopDate();
                if (stopDate != null) {
                    stmt.setTimestamp(4, new Timestamp(stopDate.getTime()));
                } else {
                    stmt.setTimestamp(4, null);
                }
                stmt.setString(5, ejb.getFacilityID());
                stmt.setString(6, ejb.getScopePath());
                stmt.setInt(7, ejb.getIntervalSec());
                stmt.setInt(8, ejb.getPeriodMin());
                stmt.setInt(9, ejb.getPresavePeriod());
                stmt.setString(10, ejb.getCollectorID());
                int row = stmt.executeUpdate();
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("store() error : " + ejb.getCollectorID() + " SQLException" + msg));
                    throw new EJBException(msg);
                }
                Object var10_10 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("store() error : " + ejb.getCollectorID() + " SQLException"), (Throwable)e);
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("store() error : " + ejb.getCollectorID() + " SQLException"), (Throwable)e1);
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("store() error : " + ejb.getCollectorID() + " SQLException"), (Throwable)e1);
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("store() end   : " + ejb.getCollectorID()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(CollectorPK pk) throws EJBException {
        m_log.debug((Object)("remove()  start: " + pk.getCollectorID()));
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "DELETE  FROM  CC_COLLECTOR_PROFILE WHERE COLLECTORID = ? ";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.collectorID);
                int row = stmt.executeUpdate();
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("remove() error : " + pk.toString() + " SQLException" + msg));
                    throw new EJBException(msg);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("remove() end   : " + pk.getCollectorID()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CollectorPK create(CollectorBean ejb) throws CreateException, EJBException, DuplicateKeyException {
        CollectorPK pk;
        m_log.debug((Object)("create() start : " + ejb.getCollectorID()));
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "INSERT INTO CC_COLLECTOR_PROFILE (COLLECTORID, COLLECTOR_TYPE, LABEL,START_DATE,STOP_DATE,TARGET_FACILITYID,SCOPE_PATH,INTERVAL_SEC,PERIOD_MIN,PRESAVE_PERIOD)values (?,?,?,?,?,?,?,?,?,?);";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, ejb.getCollectorID());
                stmt.setShort(2, (short)ejb.getCollectorType());
                stmt.setString(3, ejb.getLabel());
                if (ejb.getStartDate() != null) {
                    stmt.setTimestamp(4, new Timestamp(ejb.getStartDate().getTime()));
                } else {
                    stmt.setTimestamp(4, null);
                }
                if (ejb.getStopDate() != null) {
                    stmt.setTimestamp(5, new Timestamp(ejb.getStopDate().getTime()));
                } else {
                    stmt.setTimestamp(5, null);
                }
                stmt.setString(6, ejb.getFacilityID());
                stmt.setString(7, ejb.getScopePath());
                stmt.setInt(8, ejb.getIntervalSec());
                stmt.setInt(9, ejb.getPeriodMin());
                stmt.setInt(10, ejb.getPresavePeriod());
                int row = stmt.executeUpdate();
                pk = new CollectorPK(ejb.getCollectorID());
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("create() error : " + ejb.getCollectorID() + " SQLException"));
                    throw new EJBException(msg);
                }
                Object var9_9 = null;
            }
            catch (SQLException e) {
                if (!e.getSQLState().equals("23505")) throw new CreateException(e.getMessage());
                m_log.error((Object)("create() error : " + ejb.getCollectorID() + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("create() error : " + ejb.getCollectorID() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("create() error : " + ejb.getCollectorID() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("create() end   : " + ejb.getCollectorID()));
        return pk;
    }

    public CollectorPK findByPrimaryKey(CollectorPK pk) throws FinderException {
        ResultSet res;
        PreparedStatement stmt;
        Connection conn;
        block14: {
            m_log.debug((Object)("findbyPK() start : " + pk.getCollectorID()));
            conn = null;
            stmt = null;
            res = null;
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT collectorid FROM CC_COLLECTOR_PROFILE WHERE COLLECTORID = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.collectorID);
            res = stmt.executeQuery();
            if (!res.next()) break block14;
            CollectorPK collectorPK = pk;
            Object var8_9 = null;
            try {
                if (res != null) {
                    res.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findbyPK() end : " + pk.getCollectorID()));
            return collectorPK;
        }
        try {
            try {
                String msg = "id " + pk.getCollectorID() + " not found.";
                throw new FinderException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (res != null) {
                    res.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findbyPK() end : " + pk.getCollectorID()));
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection findAll() throws EJBException {
        m_log.debug((Object)"findAll() start : ");
        ArrayList<CollectorPK> ret = new ArrayList<CollectorPK>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT COLLECTORID FROM CC_COLLECTOR_PROFILE ORDER BY START_DATE";
                stmt = conn.prepareStatement(sql);
                res = stmt.executeQuery();
                while (res.next()) {
                    CollectorPK pk = new CollectorPK(res.getString("COLLECTORID"));
                    ret.add(pk);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)"findAll() error :  SQLException");
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)"findAll() end : ");
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection findByCollectorType(int type) throws EJBException {
        m_log.debug((Object)"findCollectorType() start : ");
        ArrayList<CollectorPK> ret = new ArrayList<CollectorPK>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT COLLECTORID FROM CC_COLLECTOR_PROFILE WHERE COLLECTOR_TYPE = ? ORDER BY START_DATE";
                stmt = conn.prepareStatement(sql);
                stmt.setShort(1, (short)type);
                res = stmt.executeQuery();
                while (res.next()) {
                    CollectorPK pk = new CollectorPK(res.getString("COLLECTORID"));
                    ret.add(pk);
                }
                Object var9_9 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)"findByCollectorType() error :  SQLException");
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (res != null) {
                    res.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)"findByCollectorType() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)"findByCollectorType() error :  SQLException");
            throw new EJBException(e1.getMessage());
        }
        if (res != null) {
            res.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)"findbyCollectorType() end : ");
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection findByPresave() throws EJBException {
        m_log.debug((Object)"findByPresave() start : ");
        ArrayList<CollectorPK> ret = new ArrayList<CollectorPK>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT COLLECTORID FROM CC_COLLECTOR_PROFILE WHERE COLLECTOR_TYPE = 2 AND PERIOD_MIN=-1 AND STOP_DATE is null";
                stmt = conn.prepareStatement(sql);
                res = stmt.executeQuery();
                while (res.next()) {
                    CollectorPK pk = new CollectorPK(res.getString("COLLECTORID"));
                    m_log.debug((Object)("unlimit collector pk : " + pk.toString()));
                    ret.add(pk);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)"findByCollectorType() error :  SQLException");
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (res != null) {
                    res.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)"findByCollectorType() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)"findByCollectorType() error :  SQLException");
            throw new EJBException(e1.getMessage());
        }
        if (res != null) {
            res.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)"findbyCollectorType() end : ");
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection findByCollectorTypeAndFacilityId(int type, String facilityId) throws FinderException {
        m_log.debug((Object)"findByCollectorTypeAndFacilityId() start : ");
        ArrayList<CollectorPK> ret = new ArrayList<CollectorPK>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT COLLECTORID FROM CC_COLLECTOR_PROFILE WHERE COLLECTOR_TYPE = ? AND TARGET_FACILITYID = ? ORDER BY START_DATE";
                stmt = conn.prepareStatement(sql);
                stmt.setShort(1, (short)type);
                stmt.setString(2, facilityId);
                res = stmt.executeQuery();
                while (res.next()) {
                    CollectorPK pk = new CollectorPK(res.getString("COLLECTORID"));
                    ret.add(pk);
                }
                Object var10_10 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)"findByCollectorTypeAndFacilityId() error :  SQLException");
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            try {
                if (res != null) {
                    res.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)"findByCollectorTypeAndFacilityId() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)"findByCollectorTypeAndFacilityId() error :  SQLException");
            throw new EJBException(e1.getMessage());
        }
        if (res != null) {
            res.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)"findByCollectorTypeAndFacilityId() end : ");
        return ret;
    }
}

