/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.engines.javascript;

import java.rmi.RemoteException;
import org.apache.bsf.debug.jsdi.JsCallbacks;
import org.apache.bsf.debug.jsdi.JsContext;
import org.apache.bsf.debug.jsdi.JsEngine;
import org.apache.bsf.debug.jsdi.JsObject;
import org.apache.bsf.debug.util.DebugLog;
import org.apache.bsf.debug.util.Skeleton;
import org.apache.bsf.engines.javascript.RhinoEngineDebugger;
import org.mozilla.javascript.Context;

public class JsEngineStub
extends Skeleton
implements JsEngine {
    RhinoEngineDebugger m_rhinoDbg;
    boolean m_inCallback;
    boolean m_resumeExecution;
    Object m_lock;

    public JsEngineStub(RhinoEngineDebugger rhinoEngineDebugger) throws RemoteException {
        super(105);
        this.m_rhinoDbg = rhinoEngineDebugger;
        this.m_lock = new Object();
    }

    public boolean isSuspended() throws RemoteException {
        return this.m_inCallback;
    }

    public boolean poll() {
        return true;
    }

    public Object eval(String string, String string2, int n) throws RemoteException {
        Object object = null;
        Context.enter();
        try {
            object = this.m_rhinoDbg.eval(string, string2, n);
        }
        catch (Throwable throwable) {
            throw new RemoteException("Failed eval", throwable);
        }
        finally {
            Context.exit();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsContext getContext(int n) throws RemoteException {
        try {
            Context.enter();
            JsContext jsContext = this.m_rhinoDbg.getContext(n);
            return jsContext;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getContextCount() throws RemoteException {
        try {
            Context.enter();
            int n = this.m_rhinoDbg.getContextCount();
            DebugLog.stdoutPrintln("\tcount = " + n, 3);
            int n2 = n;
            return n2;
        }
        finally {
            Context.exit();
        }
    }

    public String getThread() throws RemoteException {
        return this.m_rhinoDbg.getThread();
    }

    public String getThreadGroup() throws RemoteException {
        return this.m_rhinoDbg.getThreadGroup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsCallbacks getDebugger() throws RemoteException {
        try {
            Context.enter();
            JsCallbacks jsCallbacks = this.m_rhinoDbg.getDebugger();
            return jsCallbacks;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsObject getGlobalObject() throws RemoteException {
        try {
            Context.enter();
            JsObject jsObject = this.m_rhinoDbg.getGlobalObject();
            return jsObject;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsObject getUndefinedValue() throws RemoteException {
        try {
            Context.enter();
            JsObject jsObject = this.m_rhinoDbg.getUndefinedValue();
            return jsObject;
        }
        finally {
            Context.exit();
        }
    }

    public void run() throws RemoteException {
        try {
            Context.enter();
            this.m_rhinoDbg.run(this);
        }
        catch (Exception exception) {
            throw new RemoteException("Internal JSDI error", exception);
        }
        finally {
            Context.exit();
        }
    }

    public void setDebugger(JsCallbacks jsCallbacks) throws RemoteException {
        try {
            Context.enter();
            this.m_rhinoDbg.setDebugger(jsCallbacks);
        }
        catch (Exception exception) {
            throw new RemoteException("Internal JSDI error", exception);
        }
        finally {
            Context.exit();
        }
    }

    public void stepIn() throws RemoteException {
        try {
            Context.enter();
            DebugLog.stdoutPrintln("Step In command on " + this, 3);
            this.m_rhinoDbg.stepIn(this);
        }
        catch (Exception exception) {
            throw new RemoteException("Internal JSDI error", exception);
        }
        finally {
            Context.exit();
        }
    }

    public void stepOut() throws RemoteException {
        try {
            Context.enter();
            this.m_rhinoDbg.stepOut(this);
        }
        catch (Exception exception) {
            throw new RemoteException("Internal JSDI error", exception);
        }
        finally {
            Context.exit();
        }
    }

    public void stepOver() throws RemoteException {
        try {
            Context.enter();
            this.m_rhinoDbg.stepOver(this);
        }
        catch (Exception exception) {
            throw new RemoteException("Internal JSDI error", exception);
        }
        finally {
            Context.exit();
        }
    }
}

