#!/bin/bash

#Copyright (C) since 2006 NTT DATA Corporation
#
#This program is free software; you can redistribute it and/or
#Modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation, version 2.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details

#設定情報読み込み 
export EXEC_PATH=${0%/*}

. ${EXEC_PATH}/install.cfg

VERSION=`cat ${EXEC_PATH}/hinemos_agent/_version`

echo ""
echo "##################################################################"
echo ""
echo "      運用管理ソフトウェア Hinemos エージェント"
echo "                                 インストーラ  Ver. ${VERSION}"
echo ""
echo "                  Copyright (C) since 2006 NTT DATA Corporation."
echo ""
echo "##################################################################"
echo ""

#プラットフォームをチェック
if [ ${PLATFORM} = "linux" ]; then
	EXEC_USER=`/usr/bin/whoami`
	PS="ps -ef"
elif [ ${PLATFORM} = "solaris" ]; then
	EXEC_USER=`/usr/ucb/whoami`
	PS="/usr/ucb/ps auxwww"
else
	echo ""
	echo "ERROR 環境変数PLATFORMの値が不正です。"
	echo "install.cfgを確認してください。"
	echo ""
	echo "----------------------------------------"
	echo "install.cfgの設定例"
	echo "Linuxの場合		： PLATFORM=linux"
	echo "Solarisの場合	： PLATFORM=solaris"
	echo "----------------------------------------"
	exit 1
fi


HOSTS_FILE=/etc/hosts
HOST=`hostname`

# Net-SNMPをインストールするかを確認するフラグ
# 0:SNMPがインストールされていない
# 1:SNMPがインストールされている
SNMP_INSTALL_FLG=0

# check for incorrect user

if [ $EXEC_USER != "root" ]; then
		echo ""
		echo "ERROR  Hinemos Agentのインストールはrootでおこなってください。 "
		echo ""
		exit 1
fi


##
## hostsファイルのチェック(syslog-ng.confで自身のIPアドレスを動的に取得するため)
##
hosts_check() {
	echo ""
	echo "${HOSTS_FILE} のチェックを行います。"

	#ホスト名にIPアドレスの重複がないかチェックを行う
	check_flg=`grep ${HOST} ${HOSTS_FILE} | grep -v "^\s*\#" | awk '{print $1}' | wc -l`

	if [ ${check_flg} != 1 ]; then
		echo "NG"
		echo "警告：${HOSTS_FILE} には、${HOST} に対する適切なIPアドレスの設定が行われていない、"
		echo "もしくは、2つ以上のIPアドレスが設定されています。"
		echo "${HOSTS_FILE} を確認し、${HOST} とIPアドレスが1対1となるように設定を変更してください。"
		echo ""

		while [ 1 ]; 
		do
			echo "インストールを続けますか？（Y：続ける / N：中止する ）"
			read ANS
			case ${ANS} in
				y|Y)
					break
					;;
				n|N)
					echo "インストールを中止します。"
					echo ""
					exit 1
					;;
				*)
					;;
			esac
		done
	else
		echo "OK"
		echo ""
	fi
}


##
## rpmのチェック
##
rpm_check(){

	# パッケージチェッカー
	package_checker() {
			rpm -qi $1 >/dev/null 2>&1
			check_flg=$?
	}

	echo ""
	echo "パッケージチェックを行います。"


	## インストールマニュアルに記述されているパッケージの有無をチェックする
	##
	for p_name in ${RPM_MANUAL[@]}
	do
		package_checker ${p_name}
		if [ ${check_flg} = 1 ]; then
			echo ${p_name} >> ${EXEC_PATH}/tmp.txt
		fi
	done

	# 結果を表示
	if [ -s ${EXEC_PATH}/tmp.txt ]; then
		echo ""
		echo "NG"
		echo "警告：Hinemosエージェントをインストールするには以下のパッケージが不足しています。"
		cat ${EXEC_PATH}/tmp.txt
		echo ""
		echo "詳細についてはインストールマニュアルを参照してください。"
		echo ""
		rm -f ${EXEC_PATH}/tmp.txt
		exit 1
	else
		rm -f ${EXEC_PATH}/tmp.txt
	fi


	## Net-SNMPパッケージがインストールされているかをチェックする
	##
	for p_name in "${RPM_SNMP[@]}"
	do
	   	rpm -q "${p_name}" >/dev/null 
	   	if [ "${?}" -eq "1" ] ; then
	   		echo ${p_name} >> ${EXEC_PATH}/tmp.txt
	   	fi
	done

	# 結果を表示
	if [ -s ${EXEC_PATH}/tmp.txt ]; then
		echo ""
		echo "NG"
		echo "警告：Hinemosの以下の機能を使用するにはNet-SNMPをインストールする必要があります。"
		echo ""
		echo "利用できないHinemosの機能"
		echo "	・リソース監視機能"
		echo "	・プロセス監視機能"
		echo "	・SNMP監視機能"
		echo "	・性能管理機能"
		echo ""
		echo "以下のパッケージをインストールしてください。"
		cat ${EXEC_PATH}/tmp.txt
		echo ""
		echo "バージョン等の詳細についてはインストールマニュアルを参照してください。"
		echo ""
		rm -rf ${EXEC_PATH}/tmp.txt
		
		while [ 1 ] ;
		do
			echo "インストールを続けますか?(Y/N)"
			read ANS
			case ${ANS} in
				y|Y)
					SNMP_INSTALL_FLG=0
					break
					;;
				n|N)
					echo "インストールを中止します。"
					exit 1
					;;
				*)
					;;
			esac
		done
	else
		CURRENT_SNMP_VERSION=`rpm -q net-snmp`
		CURRENT_SNMP_LIBS_VERSION=`rpm -q net-snmp-libs | uniq`
		SNMP_CHECK_FLG=0

		#net-snmpのバージョンチェック
		echo ""
		if [ "${CURRENT_SNMP_VERSION}" != "${SNMP_VERSION}" ] ; then
        	echo "インストールされているnet-snmpパッケージが、推奨バージョンと異なっている可能性があります。"
        	echo "現バージョン ： ${CURRENT_SNMP_VERSION}"
        	echo "推奨バージョン ： ${SNMP_VERSION} 以降"
        	echo ""
        	SNMP_CHECK_FLG=1
		fi
		
		#net-snmp-libsのバージョンチェック
		if [ "${CURRENT_SNMP_LIBS_VERSION}" != "${SNMP_LIBS_VERSION}" ] ; then
        	echo "インストールされているnet-snmp-libsパッケージが、推奨バージョンと異なっている可能性があります。"
        	echo "現バージョン ： ${CURRENT_SNMP_LIBS_VERSION}"
        	echo "推奨バージョン ： ${SNMP_LIBS_VERSION} 以降"
        	echo ""
        	SNMP_CHECK_FLG=1
		fi
	
		if [ "${SNMP_CHECK_FLG}" = "0" ] ; then 
			echo "OK"
		else
			echo "推奨バージョン以降がインストールされている場合は問題ありません。"
        	echo "詳細はインストールマニュアルを参照ください。"
        	echo ""
        	echo "推奨バージョンをインストールする場合は、エージェントのインストールを中止し、実施してください。"
        	echo "その後、エージェントインストールを再実行して下さい。"
        	while [ 1 ] ;
			do
				echo ""
				echo "インストールを続けますか?(Y/N)"
				read ANS
				case ${ANS} in
					y|Y)
						break
						;;
					n|N)
						echo "インストールを中止します。"
						exit 1
						;;
					*)
						;;
				esac
			done
		fi
		
		echo ""
		rm -rf ${EXEC_PATH}/tmp.txt
		SNMP_INSTALL_FLG=1
	fi

	## 一括制御機能で使用しているコマンドのパッケージの有無をチェックする
	##
	for p_name in ${RPM_CRUN[@]}
	do
		package_checker ${p_name}
		if [ ${check_flg} = 1 ]; then
			echo ${p_name} >> ${EXEC_PATH}/tmp.txt
		fi
	done

	# 結果を表示
	if [ -s ${EXEC_PATH}/tmp.txt ]; then
		echo ""
		echo "警告：一括制御機能を全て使用するには以下のパッケージを別途インストールする必要があります。"
		cat ${EXEC_PATH}/tmp.txt
		echo ""
		echo "詳細についてはインストールマニュアルを参照してください。"
		echo ""
		sleep 2
		rm -rf ${EXEC_PATH}/tmp.txt
	fi

	rm -rf ${EXEC_PATH}/tmp.txt
}


##
## インストールディレクトリの確認
##
installdir_check() {
	echo "インストールディレクトリ ${HINEMOS_AGENT_HOME} の確認を行います。"
	if [ -d ${HINEMOS_AGENT_HOME} ]; then
		echo "警告：インストールディレクトリ ${HINEMOS_AGENT_HOME}は既に存在します。"
	  	echo "ディレクトリ名を変更するか、削除してください。"
		echo ""
	   	echo "インストールを中止します。"
		exit 1
	else
	 	echo "インストールディレクトリ ${HINEMOS_AGENT_HOME}は存在しません。作成します。"
		echo "mkdir -p ${HINEMOS_AGENT_HOME}"
	 	echo ""
  	fi
}


##
## Net-SNMPの設定
##
snmp_setting() {
	if [ "${SNMP_INSTALL_FLG}" -eq "1" ] ; then
		echo "Net-SNMPのセットアップを行います。"
		# snmpd.confのバックアップを取得
		mkdir -p ${HINEMOS_AGENT_HOME}/var/backup
		cp -p /etc/snmp/snmpd.conf ${HINEMOS_AGENT_HOME}/var/backup/snmpd.conf_bk
		# 設定を追加
	  	echo "view	systemview	included	.1.3.6.1 " >> /etc/snmp/snmpd.conf
		echo "/etc/init.d/snmpd restart"
		/etc/init.d/snmpd restart
	else
		echo "警告：Net-SNMPがインストールされていないため、セットアップは行いません。"
		echo "インストールマニュアルを参照し、セットアップを行ってください。"
		sleep 3
	fi
}

### syslog-ngのインストール(Linux)
syslogng_install_linux() {
			
		#インストールチェック
		rpm -q syslog-ng > /dev/null
		
		if [ "${?}" -eq "1" ] ; then		
			# rpmインストール
			rpm -ivh --force ${SYSLOG_NG_RPM}
			
			# syslog-ng.conf の編集
			LOCAL_ADDR=`grep ${HOST} ${HOSTS_FILE} | grep -v "^\s*\#" | gawk '{print $1}'`
			echo "#add for Hinemos Agent ${HINEMOS_VERSION}" >> /etc/syslog-ng/syslog-ng.conf
			echo "filter f_hinemos_log { facility(user);  };" >> /etc/syslog-ng/syslog-ng.conf
			echo "source s_netudp { udp(ip(${LOCAL_ADDR}) port(514)); };" >>/etc/syslog-ng/syslog-ng.conf
			echo "log { source(s_netudp); filter(f_hinemos_log); destination(d_hinemos);};" >>/etc/syslog-ng/syslog-ng.conf
			echo "destination d_hinemos { tcp(\"${IPADDR}\" port(514));};" >> /etc/syslog-ng/syslog-ng.conf
			echo "log { source(s_local);filter(f_mesg);destination(d_hinemos);};" >> /etc/syslog-ng/syslog-ng.conf
			
			# syslogの停止、syslog-ng の起動
			/etc/init.d/syslog stop
			/etc/init.d/syslog-ng start
			/sbin/chkconfig --level 2345 syslog off
			/sbin/chkconfig --level 2345 syslog-ng on
		else
			echo "警告：syslog-ngは既にインストールされています。"
			echo "インストールマニュアルを参照し、設定を変更してください。"
			sleep 2
		fi
}

### syslog-ngのインストール(Solaris)
syslogng_install_solaris() {

	TMP_M=0
	TMP_A=0
	grep "add for Hinemos Manager" ${HINEMOS_AGENT_HOME}/${SYSLOG_NG_VERSION}/etc/syslog-ng.conf > /dev/null 2>&1 && TMP_M=1
	grep "add for Hinemos Agent" ${HINEMOS_AGENT_HOME}/${SYSLOG_NG_VERSION}/etc/syslog-ng.conf > /dev/null 2>&1 && TMP_A=1

	if [ "${TMP_M}" -eq 0 ] ; then
		if [ "${TMP_A}" -eq 0 ] ; then
			LOCAL_ADDR=`cat /etc/hosts | grep $HOSTNAME | awk '{print $1;}'`
			echo "#add for Hinemos Agent ${HINEMOS_VERSION}" >>${HINEMOS_AGENT_HOME}/${SYSLOG_NG_VERSION}/etc/syslog-ng.conf
			echo "filter f_hinemos_log { facility(user) and program(\"hinemos_log_agent\"); };" >> ${HINEMOS_AGENT_HOME}/${SYSLOG_NG_VERSION}/etc/syslog-ng.conf
			echo "destination d_hinemos { tcp(\"${IPADDR}\" port(514));};" >> ${HINEMOS_AGENT_HOME}/${SYSLOG_NG_VERSION}/etc/syslog-ng.conf
			echo "log { source(s_sys);filter(f_no_hinemos);filter(f_mesg);destination(d_hinemos);};" >> ${HINEMOS_AGENT_HOME}/${SYSLOG_NG_VERSION}/etc/syslog-ng.conf
			echo "log { source(s_sys);filter(f_hinemos_log);destination(d_hinemos);};" >> ${HINEMOS_AGENT_HOME}/${SYSLOG_NG_VERSION}/etc/syslog-ng.conf
	
			svcadm disable system/system-log && svccfg -v delete -f system/system-log && svccfg -v import ${EXEC_PATH}/service/syslog-ng.xml && svcadm enable system/syslog-ng
	
			#ログローテーションの設定
			sed  s/syslog.pid/syslog-ng.pid/g /etc/logadm.conf > /tmp/logadm.conf
			cp /tmp/logadm.conf /etc/logadm.conf
		fi
	fi
}


##
## syslog-ngのインストール
##
syslogng_install() {
	HINEMOS_VERSION=`cat ${HINEMOS_AGENT_HOME}/_version`
	echo "syslog-ngをセットアップします。"
	
	if [ ${PLATFORM} = "linux" ]; then
		syslogng_install_linux
		
	elif [ ${PLATFORM} = "solaris" ]; then
		syslogng_install_solaris

	fi

}


### syslog-ngのアンインストール(Linux)
syslogng_uninstall_linux() {

	rpm -q syslog-ng > /dev/null
	if [ "${?}" = "0" ] ; then

		#syslog-ngアンインストール
		#/etc/init.d/syslog-ng stop
		#/etc/init.d/syslog start
		/sbin/chkconfig --level 2345 syslog-ng off
		/sbin/chkconfig --level 2345 syslog on
		rpm -e syslog-ng libevtlog0
		echo "syslog-ngをアンインストールしました。"
		echo ""
		echo "syslog-ng.confのバックアップファイルが作成されました。"
		echo "	/etc/syslog-ng/syslog-ng.conf.rpmsave"	
		echo "アンインストール完了後、確認してください。"
		
	fi

}

### syslog-ngのアンインストール(Solaris)
syslogng_uninstall_solaris() {

	echo ""
	svcadm disable system/syslog-ng	&& svccfg -v delete -f system/syslog-ng && svccfg -v import  /var/svc/manifest/system/system-log.xml && svcadm enable system/system-log
	
	#ログローテーションの設定
	sed  s/syslog-ng.pid/syslog.pid/g /etc/logadm.conf > /tmp/logadm.conf
	cp /tmp/logadm.conf /etc/logadm.conf

}

##
## syslog-ngのアンインストール
##
syslogng_uninstall() {

	while [ 1 ] ;
	do
		echo ""
		echo "syslog-ngをアンインストールします。よろしいですか?(Y/N)"
		read ANS_SYS
		case ${ANS_SYS} in
			y|Y)
				if [ ${PLATFORM} = "linux" ]; then
					syslogng_uninstall_linux
				elif [ ${PLATFORM} = "solaris" ]; then
					syslogng_uninstall_solaris
				fi
				break
				;;
			n|N)
				echo "syslog-ngをアンインストールしませんでした。"
				break
				;;
			*)
				;;
		esac
	done
	
}

##
## Net-SNMPの設定を戻す
##
snmp_setting_remove() {
	# バックアップファイルが存在する場合のみ実行
	if [ -f ${HINEMOS_AGENT_HOME}/var/backup/snmpd.conf_bk ] ; then
		echo "net-snmpの設定を変更します。"
		echo "Hinemosエージェントインストール直前の状態にnet-snmpの設定を戻しますか？(Y/N)"
		while [ 1 ];
		do
			read ANS
			case ${ANS} in
				y|Y)
					/etc/init.d/snmpd stop
					cp /etc/snmp/snmpd.conf /etc/snmp/snmpd.conf_bk
					cp ${HINEMOS_AGENT_HOME}/var/backup/snmpd.conf_bk /etc/snmp/snmpd.conf
					/etc/init.d/snmpd start
					echo "設定を戻しました。"
					break
					;;
				n|N)
					echo "net-snmpの設定を変更しませんでした。"
					break
					;;
				*)
					;;
			esac
		done
	fi
}




##
## インストーラ本編(始)
##
while [ 1 ];
do
	echo "Hinemos エージェント の"
	echo "	 1) インストール"
	echo "	 2) アンインストール"
	echo "	 9) インストーラの終了"
	echo ""
	echo -n "===> "

	read CHOSEN_NUMBER

	case ${CHOSEN_NUMBER} in
		##
		## インストール
		##
		1)
			echo ""
			echo "エージェントセットアップを行います。"
			echo ""
			echo ""

			while [ 1 ];
			do
				echo "インストールを開始します。よろしいですか?(Y/N)"
				read ANS
				case ${ANS} in
					y|Y)
						# インストール準備部分		  
						# hostsファイルのチェック
						hosts_check

						# パッケージのチェック
						if [ ${PLATFORM} = "linux" ]; then
							rpm_check
						fi

						# インストールディレクトリの確認
						installdir_check

						while [ 1 ] ;
						do
							echo -n "マネージャのIPアドレスを入力してください："
							read IPADDR
							echo "${IPADDR} でよろしいですか? (Y/N default:Y)"
							read IP_ANS
							IP_ANS=${IP_ANS:-Y}
							echo ""
							case ${IP_ANS} in
								y|Y)
									break
									;;
								n|N)
									;;
								*)
									echo "YかNを入力してください。"
									;;
							esac
						done

						# コピー開始
						echo "必要なファイルのコピーを開始します。"
						cp -pr $EXEC_PATH/hinemos_agent /opt
						mkdir /${HINEMOS_AGENT_HOME}/sbin
						cp -pr $EXEC_PATH/install.cfg ${HINEMOS_AGENT_HOME}/sbin
						cp -pr $EXEC_PATH/agent_installer_EN.sh ${HINEMOS_AGENT_HOME}/sbin
						cp -pr $EXEC_PATH/agent_installer_JP.sh ${HINEMOS_AGENT_HOME}/sbin
						cp -pr $EXEC_PATH/service ${HINEMOS_AGENT_HOME}/sbin
						cp -pr $EXEC_PATH/sbin/* ${HINEMOS_AGENT_HOME}/sbin
						
						#install.cfgの内容を反映してhinemos_agent.cfgをコピー
						REPLACE_PATH=`echo ${JRE_NAME} | sed 's/\//\\\\\//g'`
						sed "s/%%jre_name%%/${REPLACE_PATH}/" ${EXEC_PATH}/hinemos_agent.cfg > ${HINEMOS_AGENT_HOME}/bin/hinemos_agent.cfg						

						echo "必要なファイルのコピーが終了しました。"
						echo ""

						# JREのインストール
						echo "JREのインストールをおこないます。"
						sleep 2
						echo ""
						cp ${EXEC_PATH}/${JRE_FILE_NAME} ${HINEMOS_AGENT_HOME}
						CURRENT_DIR=`pwd`
						cd ${HINEMOS_AGENT_HOME}
						${HINEMOS_AGENT_HOME}/${JRE_FILE_NAME}
						rm ${HINEMOS_AGENT_HOME}/${JRE_FILE_NAME}
						cd ${CURRENT_DIR}
						echo ""

						# ジョブエージェントへのマネージャIPアドレスの反映
						echo "" >> ${HINEMOS_AGENT_HOME}/lib/agent/Agent.properties
						echo "### Hinemos Manager ###" >> ${HINEMOS_AGENT_HOME}/lib/agent/Agent.properties
						echo java.naming.provider.url=jnp://$IPADDR:1099 >> ${HINEMOS_AGENT_HOME}/lib/agent/Agent.properties
						echo "" >> ${HINEMOS_AGENT_HOME}/lib/agent/Agent.properties

						# ジョブエージェントのログ出力先設定
						echo "" >> ${HINEMOS_AGENT_HOME}/lib/agent/log4j.properties
						echo "### log directory setting ###" >> ${HINEMOS_AGENT_HOME}/lib/agent/log4j.properties
						echo log4j.appender.file.File=${HINEMOS_AGENT_HOME}/var/log/agents.log >> ${HINEMOS_AGENT_HOME}/lib/agent/log4j.properties
						echo "" >> ${HINEMOS_AGENT_HOME}/lib/agent/log4j.properties		

						# ログ転送エージェントへのマネージャIPアドレスの反映
						echo "" >> ${HINEMOS_AGENT_HOME}/lib/log_agent/Agent.properties
						echo "### Hinemos Manager ###" >> ${HINEMOS_AGENT_HOME}/lib/log_agent/Agent.properties
						echo java.naming.provider.url=jnp://$IPADDR:1099 >> ${HINEMOS_AGENT_HOME}/lib/log_agent/Agent.properties
						echo "" >> ${HINEMOS_AGENT_HOME}/lib/log_agent/Agent.properties
						
						# ログへのホスト名の反映のための設定
						echo "" >> ${HINEMOS_AGENT_HOME}/lib/log_agent/log4j.properties
						echo "### syslog host setting ###" >> ${HINEMOS_AGENT_HOME}/lib/log_agent/log4j.properties
						echo log4j.appender.syslog.SyslogHost=$HOST >> ${HINEMOS_AGENT_HOME}/lib/log_agent/log4j.properties
						echo "" >> ${HINEMOS_AGENT_HOME}/lib/log_agent/log4j.properties
						
						# ログ転送エージェントのログ出力先設定
						echo "" >> ${HINEMOS_AGENT_HOME}/lib/log_agent/log4j.properties
						echo "### log directory setting ###" >> ${HINEMOS_AGENT_HOME}/lib/log_agent/log4j.properties
						echo log4j.appender.file.File=${HINEMOS_AGENT_HOME}/var/log/logagent.log >> ${HINEMOS_AGENT_HOME}/lib/log_agent/log4j.properties
						echo "" >> ${HINEMOS_AGENT_HOME}/lib/log_agent/log4j.properties
			  
						#Net-SNMPのセットアップ
						if [ ${PLATFORM} = "linux" ]; then
							snmp_setting
						fi
						echo ""

						#syslog-ngのセットアップ
						syslogng_install
						echo ""

						echo "Hinemosエージェントをインストールしました。"
						echo ""
						break
						;;
					n|N)
						echo "インストールを中止してメニューに戻ります。"
						echo ""
						sleep 1
						break
						;;
					*)
						;;
				esac
			done
			;;
		##
		## アンインストール
		##
		2)	  
			echo "Hinemosエージェントをアンインストールします。よろしいですか?(Y/N)"
			read ANS
			case ${ANS} in
				y|Y)
					#プロセス終了の確認
					${PS} | grep /agent/ | grep -v grep | grep hinemos > /dev/null
	  				RET1=$?  

	  				${PS} | grep /log_agent/ | grep -v grep | grep hinemos > /dev/null 
	  				RET2=$?  
				
					if [ ${RET1} -eq 0 -o ${RET2} -eq 0 ]; then
						echo "Hinemosエージェントが起動中です。"
						echo "Hinemosエージェントを停止してからアンインストールを実行してください。"
						echo "Hinemosエージェントのアンインストールを中止します。"
						exit 1
			  		fi
				
				
					#syslog-ngのアンインストール
					syslogng_uninstall					
					echo ""

					#net-snmpの設定変更
					if [ ${PLATFORM} = "linux" ]; then
						snmp_setting_remove
					fi
					echo ""

					#Hinemosエージェントファイルの削除
					echo "${HINEMOS_AGENT_HOME}を削除します。"
					if [ -d ${HINEMOS_AGENT_HOME} ] ; then
						rm -fr ${HINEMOS_AGENT_HOME}
						echo "${HINEMOS_AGENT_HOME}を削除しました。"
					else
						echo "${HINEMOS_AGENT_HOME}は存在しません。"
					fi
					;;
				*)
					;;
			esac
			echo ""
			;;
		##
		## 終了
		##
		9)  
			echo "Hinemosエージェント インストーラを終了します。"
			exit 0
			;;
		*)
			echo ""
			;;
  	esac
done
##
## インストーラ本編(終)
##
