/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.commons.util;

import java.io.Serializable;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SendQueue {
    protected static Log m_log = LogFactory.getLog(SendQueue.class);
    private int RETRY_MAX = 3;
    protected String m_queueName;
    protected QueueConnectionFactory m_connectionFactory;
    protected QueueConnection m_connection;
    protected Queue m_queue;
    protected QueueSession m_session;

    public SendQueue(String queueName) throws NamingException, JMSException {
        this.m_queueName = queueName;
        this.initial();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Serializable orgMessage) throws JMSException {
        for (int i = 0; i < this.RETRY_MAX; ++i) {
            QueueSender sender = null;
            try {
                sender = this.m_session.createSender(this.m_queue);
                ObjectMessage message = this.m_session.createObjectMessage(orgMessage);
                sender.send((Message)message);
                break;
            }
            catch (JMSException e) {
                m_log.warn((Object)("retry send message. cause :" + e.getMessage()), (Throwable)e);
                if (sender != null) {
                    try {
                        sender.close();
                    }
                    catch (Exception e2) {
                        m_log.warn((Object)("put: sender close error." + e.getMessage()), (Throwable)e2);
                    }
                    sender = null;
                }
                try {
                    this.terminate();
                }
                catch (Exception e2) {
                    m_log.warn((Object)("put: terminate error." + e.getMessage()), (Throwable)e2);
                }
                if (i == this.RETRY_MAX - 1) {
                    m_log.error((Object)("put:" + e.getMessage()), (Throwable)e);
                    throw e;
                }
                try {
                    this.initial();
                }
                catch (NamingException e1) {
                    m_log.error((Object)("put: initial error." + e.getMessage()), (Throwable)e);
                    throw e;
                }
            }
            finally {
                try {
                    if (sender != null) {
                        sender.close();
                    }
                }
                catch (JMSException e) {}
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    public void initial() throws NamingException, JMSException {
        for (int i = 0; i < this.RETRY_MAX; ++i) {
            block13: {
                try {
                    InitialContext context = null;
                    String serverName = System.getProperty("jboss.server.name");
                    if (serverName.equals("all")) {
                        Properties properties = new Properties();
                        properties.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
                        properties.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
                        properties.put("java.naming.provider.url", "jnp://localhost:1100");
                        context = new InitialContext(properties);
                    } else {
                        context = new InitialContext();
                    }
                    this.m_connectionFactory = (QueueConnectionFactory)context.lookup("java:/ConnectionFactory");
                    this.m_connection = this.m_connectionFactory.createQueueConnection();
                    this.m_session = this.m_connection.createQueueSession(false, 1);
                    this.m_connection.start();
                    this.m_queue = (Queue)context.lookup(this.m_queueName);
                    context.close();
                    break;
                }
                catch (NamingException e) {
                    m_log.warn((Object)("retry create queue session. cause :" + e.getMessage()), (Throwable)e);
                    try {
                        this.terminate();
                    }
                    catch (Exception e2) {
                        m_log.warn((Object)("terminate error. cause :" + e.getMessage()), (Throwable)e);
                    }
                    if (i == this.RETRY_MAX - 1) {
                        m_log.error((Object)("initial:" + e.getMessage()), (Throwable)e);
                        throw e;
                    }
                }
                catch (JMSException e) {
                    m_log.warn((Object)("retry create queue session. cause :" + e.getMessage()), (Throwable)e);
                    try {
                        this.terminate();
                    }
                    catch (Exception e2) {
                        m_log.error((Object)("terminate error. cause :" + e.getMessage()), (Throwable)e);
                    }
                    if (i != this.RETRY_MAX - 1) break block13;
                    m_log.error((Object)("initial:" + e.getMessage()), (Throwable)e);
                    throw e;
                }
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void terminate() throws JMSException {
        try {
            if (this.m_connection != null) {
                this.m_connection.stop();
            }
        }
        catch (JMSException e) {
            m_log.error((Object)("terminate : " + e.getMessage()), (Throwable)e);
        }
        try {
            if (this.m_session != null) {
                this.m_session.close();
                this.m_session = null;
            }
        }
        catch (JMSException e) {
            m_log.error((Object)("terminate : " + e.getMessage()), (Throwable)e);
        }
        try {
            if (this.m_connection != null) {
                this.m_connection.close();
                this.m_connection = null;
            }
        }
        catch (JMSException e) {
            m_log.error((Object)("terminate : " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }
}

