/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */
package com.clustercontrol.performance.composite.tree;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

import com.clustercontrol.performance.util.CollectorItemCodeFactory;
import com.clustercontrol.performance.util.code.CollectorItemTreeItem;

/**
 * 収集項目ツリー用のラベルプロバイダクラス
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
class CollectorTreeLabelProvider extends LabelProvider {

	/**
	 * 要素の画面表示文字列を取得します。
	 */
	public String getText(Object element) {
		CollectorItemTreeItem item = (CollectorItemTreeItem) element;
		
		// 保持している場合 収集項目名に加えデバイス名を出力
		return item.getFullName();
//		
//		// デバイス情報を保持しているか否かを判定
//		if(((CollectorItemTreeItem) element).getDeviceData() == null){
//			// 保持していない場合 収集項目名だけを出力
//			return ((CollectorItemTreeItem) element).getName();
//		} else {
//			// 保持している場合 収集項目名に加えデバイス名を出力
//			return item.getFullName();
//		}
	}

	/**
	 * 要素の画像イメージを取得します。（現在は必ずnullとなります）
	 */
    public Image getImage(Object element) {
    	return null;
    }
}
