/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.util;

import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.ConfirmConstant;
import com.clustercontrol.bean.EventConfirmConstant;
import com.clustercontrol.bean.ExclusionConstant;
import com.clustercontrol.bean.NotifyTypeConstant;
import com.clustercontrol.bean.OutputNotifyGroupInfo;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.commons.util.SendQueue;
import com.clustercontrol.notify.bean.QueueConstant;
import com.clustercontrol.notify.ejb.entity.NotifyActionInhibitionInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyActionInhibitionInfoPK;
import com.clustercontrol.notify.ejb.entity.NotifyActionInhibitionInfoUtil;
import com.clustercontrol.notify.ejb.entity.NotifyEventInfoData;
import com.clustercontrol.notify.ejb.entity.NotifyEventInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyEventInfoPK;
import com.clustercontrol.notify.ejb.entity.NotifyEventInfoUtil;
import com.clustercontrol.notify.ejb.entity.NotifyInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyInfoUtil;
import com.clustercontrol.notify.monitor.ejb.entity.EventLogLocal;
import com.clustercontrol.notify.monitor.ejb.entity.EventLogUtil;
import com.clustercontrol.notify.monitor.ejb.entity.EventMultiInfoLocal;
import com.clustercontrol.notify.monitor.ejb.entity.EventMultiInfoUtil;


/**
 * イベント情報を更新するクラス<BR>
 *
 * @version 3.0.0
 * @since 3.0.0
 */
public class OutputEvent extends InhibitAction{
	
	/** ログ出力のインスタンス */
	protected static Log m_log = LogFactory.getLog( OutputEvent.class );
	
    /** イベントログ多重化情報生成フラグ。 */
    private boolean m_insertMultiFlg;
	
    /** イベントログ多重化情報更新フラグ。 */
    private boolean m_updateMultiFlg;
    
	/** 抑制する重要度を含むイベント通知かどうかフラグ。 */
    private boolean m_isControlEvent;
    
	/** 抑制する重要度かどうかフラグ。 */
    private boolean m_isControlPriority;
    
    /** 抑制したかどうかフラグ */
    private boolean m_isInhibit;
    
    /** 再投入用Queue */
    private SendQueue m_queue;
	
    
    /**
     * イベントの出力を行います。
     * 
     * @param outputInfo 出力・通知情報
     * @throws RemoteException
     * @throws NamingException
     * @throws CreateException
     * @throws FinderException
     */
    public synchronized void outputEvent(OutputNotifyGroupInfo outputInfo) throws RemoteException, NamingException, CreateException, FinderException{
		
    	// 通知グループIDが存在する場合（通知グループIDが存在しないAplLogなどがイベントキューに直接投げ込むことがあるので、判定する）
    	if(outputInfo.getNotifyGroupId() != null && !outputInfo.getNotifyGroupId().equals("")) {    	
    	
	    	NotifyInfoLocal notifyInfo = NotifyInfoUtil.getLocalHome().findByPrimaryKey(outputInfo.getNotifyId());
	    				
			NotifyEventInfoLocal notifyEventInfo = NotifyEventInfoUtil.getLocalHome().findByPrimaryKey(
					new NotifyEventInfoPK(outputInfo.getNotifyId(), outputInfo.getPriority()));
			
			// 通知する重要度の情報が存在しない場合
			if (notifyEventInfo == null) {
				m_log.debug("insertEventLog() : 出力する重要度が存在しません。");
				return;
			}			
			
			// 対象の重要度に通知フラグたっていた場合
			if(notifyEventInfo.getEventNormalFlg() == ValidConstant.TYPE_VALID) {
				
				// 以下の変数は、HA対応の時に使用するかも
				// 多重化ID
//				String multiId = outputInfo.getMultiId();
				// イベントログ多重化情報用出力日時
//				Timestamp outputDateMulti = null;
								
				
				/**
				 * 多重化の処理
				 * TODO : HA対応の際に以下を記述
				 */
				// 多重化IDの指定がない場合
				if (outputInfo.getMultiId() == null) {
					
				}
				// 多重化IDの指定がある場合
				else{
					
				}
				
				/**
				 * 実行するかどうかの判定
				 */
				m_isControlEvent = false;
				m_isControlPriority = false;
				m_isInhibit = false;
				// 抑制する場合（抑制方法が「なし」以外の場合）
				if (notifyInfo.getInhibitionFlg().intValue() != ExclusionConstant.TYPE_NO){
					m_isControlEvent = true;
					// 監視結果として送られてきた重要度に抑制フラグが存在する場合
					if (notifyEventInfo.getEventInhibitionFlg().intValue() == ValidConstant.TYPE_VALID){
						m_isControlPriority = true;
						try {
							m_isInhibit = this.isInhibit(outputInfo, notifyInfo);
							
						} catch (NumberFormatException e) {
							m_log.error("outputEvent() : " + e.getMessage(),e);
						} catch (RemoteException e) {
							m_log.error("outputEvent() : " + e.getMessage(),e);
						} catch (CreateException e) {
							m_log.error("outputEvent() : " + e.getMessage(),e);
						}
					}					
				}
			
				/**
				 * 実行
				 */
				// イベントログ情報の生成（抑制対象）
				if(m_isInhibit){
					// 抑制後の通知状態が破棄以外の場合
					if(notifyEventInfo.getEventInhibitionState() != EventConfirmConstant.TYPE_DESTRUCTION){
						// 抑制されたイベント情報の作成
						this.insertEventLog(outputInfo, notifyEventInfo, ConfirmConstant.TYPE_CONFIRMED);
					}
					// 破棄の場合でも、抑制情報は更新する
					else {
						if(m_isControlEvent) {
							// 抑制すべき重要度かどうか
							if (m_isControlPriority){
								// 抑制情報の更新
								this.inhibitUpdate(m_isInhibit, outputInfo);
							}
							else {
								this.updateLastUpdateDate(outputInfo, notifyInfo.getNotifyId());
							}
						}
					}
				}
				// イベントログ情報の生成（非抑制対象）
				else {
					this.insertEventLog(outputInfo, notifyEventInfo, ConfirmConstant.TYPE_UNCONFIRMED);
				}
				
			}
    	}
    	
    	// 通知グループIDが存在する場合しない場合
    	// （抑制などが存在しないもの場合（内部イベント通知など））
    	else {
    		this.insertEventLog(outputInfo);
    	}
    }
    
	/**
	 * イベント情報を作成します。
	 * 
	 * @param output 出力情報
	 * @param eventInfoData 通知情報
	 * @param inhibitedFlg 抑制フラグ
	 * @throws NamingException
	 * @throws CreateException
	 * @throws RemoteException 
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	@SuppressWarnings("unchecked")
	private void insertEventLog(OutputNotifyGroupInfo output , NotifyEventInfoLocal eventInfo, int inhibitedFlg) throws NamingException, CreateException, RemoteException{

		try {
			int eventState = -1; // 通知状態（未確認・確認・破棄）
			if(inhibitedFlg == YesNoConstant.TYPE_YES && eventInfo.getEventInhibitionFlg() == YesNoConstant.TYPE_YES){
				// 抑制されたデータの場合
				eventState = eventInfo.getEventInhibitionState();
			}
			else{
				eventState = eventInfo.getEventNormalState();
			}			

			EventLogUtil.getLocalHome().create(
					output.getMonitorId(),
					output.getPluginId(),
					output.getFacilityId(),
					output.getScopeText(),
					output.getApplication(),
					output.getMessageId(),
					output.getMessage(),
					output.getMessageOrg(),
					new Integer(output.getPriority()),
					new Integer(eventState),
					null,
					"",
					new Integer(0),
					new Timestamp(output.getGenerationDate().getTime()),
					new Timestamp(new Date().getTime()),	// FIXME: HA対応の際に問題になる可能性あり（同じログは出力しないように設定しようとした場合）
//					output.getOutputDate(),
					new Integer(inhibitedFlg)
			);
			
			// 抑制する重要度を含むイベントかどうか
			if(m_isControlEvent) {
				// 抑制する重要度かどうか
				if (m_isControlPriority){
					this.inhibitUpdate(m_isInhibit, output);
				}
				else {
					this.updateLastUpdateDate(output, eventInfo.getNotifyId());
				}
			}
		}
		catch(NamingException e)
		{
			throw e;
		}
		catch(CreateException e)
		{
			// 同じキーを持つオブジェクトがすでに存在する場合、出力日時を再度取得しイベントキューに再度なげる
			if(e instanceof javax.ejb.DuplicateKeyException){
				Date now = new Date();
				output.setOutputDate(new Timestamp(now.getTime()));

				try {
					
					m_queue = new SendQueue(QueueConstant.QUEUE_NAME_EVENT);
					m_queue.put(output);
					
				} catch (JMSException e1) {
					m_log.error(e1.getMessage(),e1);
				} finally {
					try {
						if(m_queue != null){
							m_queue.terminate();
						}
						m_queue = null;
					} catch (JMSException e1) {
						m_log.error(e1.getMessage(),e1);
					}
				}
			}
			else{
				throw e;
			}
		}
	}
	
	/**
	 * イベント情報を作成します。（抑制情報が存在しない場合、内部イベントやジョブ失敗など）
	 * 
	 * @param output 出力内容
	 * @throws NamingException
	 * @throws CreateException
	 */
	private void insertEventLog(OutputNotifyGroupInfo output) throws NamingException, CreateException{

		try {
			Timestamp outputDate = null;
			
			// 既にoutputDateが存在している場合
			if(output.getOutputDate() != null && !output.getOutputDate().equals("")){
				outputDate = output.getOutputDate();
			}
			// outputDateが存在しない場合
			else{
				outputDate = new Timestamp(new Date().getTime());
			}
			
			EventLogUtil.getLocalHome().create(
					output.getMonitorId(),
					output.getPluginId(),
					output.getFacilityId(),
					output.getScopeText(),
					output.getApplication(),
					output.getMessageId(),
					output.getMessage(),
					output.getMessageOrg(),
					new Integer(output.getPriority()),
					new Integer(ConfirmConstant.TYPE_UNCONFIRMED),
					null,
					"",
					new Integer(0),
					new Timestamp(output.getGenerationDate().getTime()),
					outputDate,
					new Integer(YesNoConstant.TYPE_NO)
			);
		}
		catch(NamingException e)
		{
			throw e;
		}
		catch(CreateException e)
		{
			// 同じキーを持つオブジェクトがすでに存在する場合、出力日時を再度取得しイベントキューに再度なげる
			if(e instanceof javax.ejb.DuplicateKeyException){
				Date now = new Date();
				output.setOutputDate(new Timestamp(now.getTime()));

				try {
					
					m_queue = new SendQueue(QueueConstant.QUEUE_NAME_EVENT);
					m_queue.put(output);
					
				} catch (JMSException e1) {
					m_log.error(e1.getMessage(),e1);
				} finally {
					try {
						if(m_queue != null){
							m_queue.terminate();
						}
						m_queue = null;
					} catch (JMSException e1) {
						m_log.error(e1.getMessage(),e1);
					}
				}
			}
			else{
				throw e;
			}
		}
	}
	
	
	/**
	 * イベント多重化情報を作成します。
	 * 
	 * @param logOutput ログ出力情報
	 * @param outputDate 受信日時
	 * @throws NamingException
	 * @throws CreateException
	 */
	public void insertEventMultiInfo(OutputNotifyGroupInfo outputInfo) throws NamingException, CreateException{
		
		try {
			EventMultiInfoUtil.getLocalHome().create(
					outputInfo.getMonitorId(),
					outputInfo.getPluginId(),
					outputInfo.getFacilityId(),
					outputInfo.getOutputDate(),
					outputInfo.getMultiId(),
					Integer.valueOf(0)
					);
			
		} catch (NamingException e) {
			throw e;
		} catch (CreateException e) {
			throw e;
		}
	}
	
	/**
	 * イベント情報を更新します。<BR>
	 * 引数で指定されたイベント情報の重複カウンタをカウントアップします。
	 * 
	 * @param eventLog イベント情報のローカルコンポーネントインターフェース
	 * @throws EJBException
	 */
	public void updateEventLog(EventLogLocal eventLog) throws EJBException{
	
		if(eventLog != null)
		{
			try
			{
				eventLog.setDuplicationCount(new Integer((eventLog.getDuplicationCount().intValue()+1)));
			}
			catch(EJBException e)
			{
				// NOT NULL のカラムにnullを送信した場合など
				throw e;
			}
		}
	}
	
	/**
	 * イベント多重化情報を更新します。<BR>
	 * 引数で指定されたイベント多重化情報の重複カウンタをカウントアップします。
	 * 
	 * @param EventMultiInfo イベント多重化情報のローカルコンポーネントインターフェース
	 * @throws EJBException
	 */
	public void updateEventMultiInfo(EventMultiInfoLocal EventMultiInfo) throws EJBException{
	
		if(EventMultiInfo != null)
		{
			try
			{
				EventMultiInfo.setDuplicationCount(new Integer((EventMultiInfo.getDuplicationCount().intValue()+1)));
			}
			catch(EJBException e)
			{
				throw e;
			}
		}
	}
	

//	/**
//     * イベント情報を作成した場合は、 <code>true</code> を返します。
//     * 
//     * @return イベント情報を作成した場合は、 <code>true</code>
//     */
//    public boolean isInsertFlg() {
//        return m_isInsert;
//    }
    
    
    /**
     * 抑制しない場合でも、同一通知内に抑制する重要度が存在する場合は、最終更新日時を更新する
     * 
     * @param outputInfo
     * @param notifyInfo
     * @throws NamingException
     */
    private void updateLastUpdateDate(OutputNotifyGroupInfo outputInfo, String notifyId) throws NamingException{
    	
    	// 抑制情報を取得する
    	try{
    		NotifyActionInhibitionInfoLocal inhibition = NotifyActionInhibitionInfoUtil.getLocalHome().findByPrimaryKey(
    				new NotifyActionInhibitionInfoPK(outputInfo.getNotifyGroupId(), notifyId, outputInfo.getFacilityId()));
   
    		// 最終更新日時を更新する
    		inhibition.setLastUpdateDate(new Timestamp(outputInfo.getGenerationDate().getTime()));
    		
    		// 重要度を更新する
    		inhibition.setPriority(outputInfo.getPriority());
    	}
    	catch(FinderException e){
    		// 見つからない場合は何もしない
    		return;
    	}
    	    	
    }
    
    /**
     * 抑制対象かどうかを判定する
     * 
     * @param outputInfo 監視結果
     * @param notifyInfo 通知情報
     * @return 抑制するかどうか
     */
    protected boolean isInhibit(OutputNotifyGroupInfo outputInfo, NotifyInfoLocal notifyInfo) throws RemoteException, NamingException, NumberFormatException, CreateException{
    	
    	// 戻り値は抑制するか否か
    	boolean isInhibit = false;
    	
    	m_notifyInfo = notifyInfo;
    	String notifyGroupId = outputInfo.getNotifyGroupId();
    	String notifyId = notifyInfo.getNotifyId();
    	String facilityId = outputInfo.getFacilityId();
    	int priority = outputInfo.getPriority();
    	Date generationDate = outputInfo.getGenerationDate();
    	
    	// 抑制情報が取得できるかチェックし、できない場合は新規作成
    	NotifyActionInhibitionInfoPK inhibitionPk = new NotifyActionInhibitionInfoPK(notifyGroupId, notifyId, facilityId);
    	
    	try{
    		m_inhibitInfo = NotifyActionInhibitionInfoUtil.getLocalHome().findByPrimaryKey(inhibitionPk);
    	}
    	// 存在しない場合は、新規作成
    	catch(FinderException e){
    		m_inhibitInfo = null;
    		return false;
    	}
    	
    	// 抑制方法によって分岐する
    	// 期間で抑制
    	if(notifyInfo.getInhibitionFlg() == ExclusionConstant.TYPE_PERIOD){
    		isInhibit = isInhibitPeriod(generationDate);
    	}
    	// 回数で抑制
    	else if(notifyInfo.getInhibitionFlg() == ExclusionConstant.TYPE_FREQUENCY){
    		isInhibit = isInhibitFrequency();
    	}
    	// 重要度で抑制
    	else if(notifyInfo.getInhibitionFlg() == ExclusionConstant.TYPE_PRIORITY){
    		isInhibit = isInhibitPriority(priority);
    	}
    	else{
			m_log.debug("inhibit() : どの抑制タイプにも当てはまりません。");
			return false;
		}
		
		return isInhibit;

    }
    
    
    /**
     * 抑制関連テーブルのアップデート
     * 
     * @param isInhibit 抑制されたかどうか 
     * @throws NamingException 
     * @throws CreateException 
     */
    protected void inhibitUpdate(boolean isInhibit, OutputNotifyGroupInfo output) throws CreateException, NamingException {
    	
    	if(m_inhibitInfo != null) {
	    	// 抑制対象を格納するDTOが存在する場合
	    	m_inhibitInfo.setPriority(output.getPriority());
	    	m_inhibitInfo.setTotalCount(m_inhibitInfo.getTotalCount() + 1);
	    	m_inhibitInfo.setLastUpdateDate(new Timestamp(output.getGenerationDate().getTime()));
	    	
	    	// 抑制する場合
	    	if(isInhibit) {
	    		// 抑制回数に1を足す
	    		m_inhibitInfo.setDupuricationCount(m_inhibitInfo.getDupuricationCount() + 1);
	    	} 
	    	// 通知する場合
	    	else {
	    		// 最終通知時刻を出力時刻にし、抑制回数を0にする
		    	m_inhibitInfo.setLastNotifyDate(new Timestamp(output.getGenerationDate().getTime()));
		    	m_inhibitInfo.setDupuricationCount(new Long(0));
	    	}
    	}
    	else {
    		// 抑制情報の新規作成
    		NotifyActionInhibitionInfoUtil.getLocalHome().create(
    				output.getNotifyGroupId(), 
    				output.getNotifyId(), 
    				output.getFacilityId(), 
    				(Integer)output.getPriority(),
    				new Timestamp(output.getGenerationDate().getTime()), 
    				new Timestamp(output.getGenerationDate().getTime()), 
    				new Long(0), 
    				new Long(1));
    	}
    }
    
}
