/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.bean.MonitorTruthValueInfo;
import com.clustercontrol.monitor.run.ejb.entity.MonitorTruthValueInfoLocal;

/**
 * 真偽値監視の判定情報を検索する抽象クラス<BR>
 * <p>
 * 真偽値監視を行う各監視管理クラスで継承してください。
 *
 * @version 3.0.0
 * @since 2.0.0
 */
abstract public class SelectMonitorTruthValueType extends SelectMonitor{
	
	/** ログ出力のインスタンス。 */
	protected static Log m_log = LogFactory.getLog( SelectMonitorTruthValueType.class );

	/**
	 * 監視情報より真偽値監視の判定情報を返します。
	 * <p>
	 * <ol>
	 * <li>監視情報より、真偽値監視判定情報を取得します。</li>
	 * <li>１判定情報をビーン（{@link com.clustercontrol.monitor.run.bean.MonitorTruthValueInfo}）にセットします。</li>
	 * <li>このビーンを、判定情報を保持するリスト（{@link ArrayList}）にセットし返します。<BR>
	 * </ol>
	 * 
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorInfoBean
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorTruthValueInfoBean
	 * @see com.clustercontrol.monitor.run.bean.MonitorTruthValueInfo
	 */
	@Override
	public ArrayList getJudgementInfo() throws FinderException, NamingException {
		
		// 真偽値監視判定情報を取得
		Collection ct = m_monitor.getMonitorTruthValueInfo();
        Iterator itr = ct.iterator();
		
		ArrayList<MonitorTruthValueInfo> valueList = new ArrayList<MonitorTruthValueInfo>();
		
        MonitorTruthValueInfoLocal local = null;
        while(itr.hasNext()){
            local = (MonitorTruthValueInfoLocal)itr.next();
            MonitorTruthValueInfo value = new MonitorTruthValueInfo(
            		local.getMessage(),
            		local.getMessageId(),
            		local.getMonitorId(),
            		local.getMonitorTypeId(),
            		local.getPriority(),
            		local.getTruthValue());
            valueList.add(value);
        }
		return valueList;
	}
}
