/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.factory;

import java.util.Collection;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.ejb.entity.MonitorStringValueInfoLocal;
import com.clustercontrol.notify.ejb.session.NotifyControllerLocal;
import com.clustercontrol.notify.ejb.session.NotifyControllerUtil;

/**
 * 文字列監視の判定情報を削除する抽象クラス<BR>
 * <p>
 * 文字列監視を行う各監視管理クラスで継承してください。
 *
 * @version 3.0.0
 * @since 2.1.0
 */
abstract public class DeleteMonitorStringValueType extends DeleteMonitor{
	
	/** ログ出力のインスタンス。 */
	protected static Log m_log = LogFactory.getLog( DeleteMonitorStringValueType.class );
	
	/**
	 * 監視情報より文字列監視の判定情報を取得し、削除します。
	 * @throws FinderException 
	 * @throws CreateException 
	 * 
	 * @see #deleteStringValueInfo(Collection)
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorInfoBean
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorStringValueInfoBean
	 */
	@Override
	public boolean deleteJudgementInfo() throws RemoveException, NamingException, CreateException, FinderException {
		
		// 文字列監視判定情報を削除
        Collection ct = m_monitor.getMonitorStringValueInfo();
        this.deleteStringValueInfo(ct);
        
		return true;
	}

	/**
	 * 引数で指定された文字列監視判定情報を削除します。
	 * 
	 * @param ct 文字列監視判定情報のコレクション
	 * @throws RemoveException
	 * @throws CreateException 
	 * @throws NamingException 
	 * @throws FinderException 
	 * 
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorStringValueInfoBean
	 */
	public void deleteStringValueInfo(Collection ct) throws RemoveException, CreateException, NamingException, FinderException {
		
		
		NotifyControllerLocal nc;
		try {
			nc = NotifyControllerUtil.getLocalHome().create();
		
		
		
		// 文字列監視判定情報を削除
	    if(ct != null && ct.size() > 0){
	        Object[] infoArray = ct.toArray();
	        for(int j = 0; j < infoArray.length; j++){
	        	MonitorStringValueInfoLocal info = (MonitorStringValueInfoLocal)infoArray[j];
	            if(info != null){
	            	
	            	//通知設定の削除
					nc.deleteNotifyRelation(info.getNotifyGroupId());
				
					//抑制情報の削除
					nc.deleteNotifyInhibition(info.getNotifyGroupId());
					
	            	info.remove();
	            }
	        }
	    }
	    
		} catch (CreateException e) {
			e.printStackTrace();
			throw e;
		} catch (NamingException e) {
			e.printStackTrace();
			throw e;
		} catch (FinderException e) {
			e.printStackTrace();
			throw e;
		}
	}
}
