/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.monitor.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.Locale;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.ejb.session.MonitorController;
import com.clustercontrol.monitor.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * イベント情報帳票出力用プロパティを取得するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、イベント情報帳票出力用プロパティを取得します。
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class GetEventReportProperty {
	
	/**
	 * マネージャにSessionBean経由でアクセスし、イベント情報帳票出力用プロパティを取得します。
	 * 
	 * @return イベント情報帳票出力用プロパティ
	 * 
	 * @see com.clustercontrol.monitor.util.EjbConnectionManager
     * @see com.clustercontrol.monitor.ejb.session.MonitorController
	 * @see com.clustercontrol.monitor.ejb.session.MonitorControllerBean#getEventFilterProperty(Locale)
	 */
	public Property getProperty() {
		MonitorController monitor = EjbConnectionManager.getConnectionManager()
		.getMonitorController();
		
		Property property = null;
		try {
			
			property = monitor.getEventFilterProperty(Locale.getDefault());
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
				MessageDialog.openInformation(null, Messages.getString("message"),
						Messages.getString("message.accesscontrol.16"));
			}
		}
		return property;
	}
}