/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.ejb.entity;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.jobmanagement.dao.JobNoticeInfoDAOImpl;
import com.clustercontrol.notify.bean.NotifyRelationInfo;
import com.clustercontrol.notify.ejb.entity.NotifyRelationInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyRelationInfoUtil;

/**
 * ジョブ通知情報のBMP Entity Bean クラス<BR>
 * 
 * @ejb.bean name="JobNoticeInfo"
 *           jndi-name="JobNoticeInfo"
 *           type="BMP"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.dao class="com.clustercontrol.jobmanagement.dao.JobNoticeInfoDAO"
 * impl-class="com.clustercontrol.jobmanagement.dao.JobNoticeInfoDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 * @see com.clustercontrol.jobmanagement.dao.JobNoticeInfoDAO
 * @see com.clustercontrol.jobmanagement.dao.JobNoticeInfoDAOImpl
 */
public abstract class JobNoticeInfoBean implements javax.ejb.EntityBean {
	/** セッションID */
    protected String session_id;
    /** ジョブID */
    protected String job_id;
    /** 終了状態 */
    protected Integer notice_type;
    /** 重要度 */
    protected Integer priority;
    /** 通知ID */
    protected String notifyGroupId;
    
    /**
     * ジョブ通知情報を生成します。
     * 
     * @ejb.create-method 
     * 
     * @param session_id セッションID
     * @param job_id ジョブID
     * @param notice_type 終了状態
     * @param priority 重要度
     * @param notify_id 通知ID
     * @return プライマリーキー
     * @throws javax.ejb.CreateException
     * 
     * @see com.clustercontrol.bean.EndStatusConstant
     * @see com.clustercontrol.bean.PriorityConstant
     */
    public JobNoticeInfoPK ejbCreate(
            String session_id, 
            String job_id, 
            Integer notice_type, 
            Integer priority, 
            String notifyGroupId
            ) throws javax.ejb.CreateException {
        this.session_id = session_id;
        this.job_id = job_id;
        this.notice_type = notice_type;
        this.priority = priority;
        this.notifyGroupId = notifyGroupId;
        return null;
    }

	/**
	 * 全てのジョブ通知情報を検索します。
	 * 
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobNoticeInfoDAOImpl#findAll()
	 */
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	/**
	 * プライマリキーに一致するジョブ通知情報を検索します。
	 * 
	 * @param pk プライマリキー
	 * @return プライマリキー
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobNoticeInfoDAOImpl#findByPrimaryKey(JobNoticeInfoPK)
	 */
	public JobNoticeInfoPK ejbFindByPrimaryKey(JobNoticeInfoPK pk) throws FinderException {
		return null;
	}
	
	/**
	 * セッションIDとジョブIDに一致するジョブ通知情報を検索します。
	 * 
	 * @param session_id セッションID
	 * @param job_id ジョブID
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobNoticeInfoDAOImpl#findBySessionIdAndJobId(String, String)
	 */
	public Collection ejbFindBySessionIdAndJobId(String session_id, String job_id) throws FinderException {
		return null;
	}

	/**
	 * セッションIDを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return セッションID
	 */
    public  java.lang.String getSession_id() {
    	return session_id;
    }

	/**
	 * セッションIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param session_id セッションID
	 */
    public void setSession_id(java.lang.String session_id) {
    	this.session_id = session_id;
    }

	/**
	 * ジョブIDを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return ジョブID
	 */
    public java.lang.String getJob_id() {
    	return job_id;
    }

	/**
	 * ジョブIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param job_id ジョブID
	 */
    public void setJob_id(java.lang.String job_id) {
    	this.job_id = job_id;
    }

	/**
	 * 終了状態を返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return 終了状態
	 * 
	 * @see com.clustercontrol.bean.EndStatusConstant
	 */
    public java.lang.Integer getNotice_type() {
    	return notice_type;
    }

	/**
	 * 終了状態を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param notice_type 終了状態
	 * 
	 * @see com.clustercontrol.bean.EndStatusConstant
	 */
    public void setNotice_type(java.lang.Integer notice_type) {
    	this.notice_type = notice_type;
    }

	/**
	 * 重要度を返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return 重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
    public java.lang.Integer getPriority() {
    	return priority;
    }

	/**
	 * 重要度を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param priority 重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
    public void setPriority(java.lang.Integer priority) {
    	this.priority = priority;
    }

	/**
	 * 通知IDを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return 通知グループID
	 */
    public java.lang.String getNotifyGroupId() {
    	return notifyGroupId;
    }

	/**
	 * 通知IDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param notify_id 通知グループID
	 */
    public void setNotifyGroupId(java.lang.String notifyGroupId) {
    	this.notifyGroupId = notifyGroupId;
    }

	/**
	 * ジョブ情報を取得する。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return ジョブ情報
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobInfoUtil
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobInfoPK
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobInfoBean#ejbFindByPrimaryKey(JobInfoPK)
	 */
    public JobInfoLocal getJobInfo() {
    	JobInfoLocal jobInfo = null;
		try {
			jobInfo = JobInfoUtil.getLocalHome().findByPrimaryKey(new JobInfoPK(getSession_id(), getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobInfo;
	}
    
	/**
	 * 履歴情報を作成する。<BR>
	 * ジョブ通知情報をジョブ通知マスタから作成します。
	 * 
	 * @ejb.home-method view-type="both"
	 * 
	 * @param sessionId セッションID
	 * @param jobs ジョブIDのコレクション
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobNoticeInfoDAOImpl#makeSession(String, Collection)
	 */
    @SuppressWarnings("unchecked")
	public void ejbHomeMakeSession(String sessionId,Collection jobs) throws javax.ejb.CreateException{
    	JobNoticeInfoDAOImpl jniDAO = new JobNoticeInfoDAOImpl(); 
    	
    	jniDAO.makeSession(sessionId,jobs);
    	
    	// 以下、JobNoticeInfo用に通知グループIDを置き換えたもので、通知関連テーブルにコピーを作成する
    	String jobId = null;
    	String infoNotifyGroupId = null;
    	JobNoticeMasterLocal noticeMst = null;
    	NotifyRelationInfoLocal relation = null;
    	Collection<NotifyRelationInfoLocal> ct = null;
    	
    	Iterator<Hashtable<String,String>> itr = jobs.iterator();
		while(itr.hasNext()){
			//ジョブID取得
			Hashtable<String,String> ht = (Hashtable)itr.next();
			jobId = (String)ht.get("jobId");
			
			// JobNoticeInfo用の通知グループIDの作成
			infoNotifyGroupId = NotifyRelationInfo.createNotifyGroupIdJobInfo(sessionId, jobId, 0);
			
			try {
				// ジョブ通知マスタから各処理（開始・通知など）のマスタ情報を取得
				// TODO 各処理で通知方法を分ける場合は、ここを書き換える （現状は、全て同じものが入っているため、通知タイプを0で呼出）
				noticeMst = JobNoticeMasterUtil.getLocalHome().findByPrimaryKey(new JobNoticeMasterPK(jobId,0));
				
				// 取得したマスタ情報の通知グループIDで、通知関連情報を取得する
				ct = NotifyRelationInfoUtil.getLocalHome().findByNotifyGroupId(noticeMst.getNotifyGroupId());
				
				// JobNoticeInfo用の通知グループIDで、通知関連テーブルのコピーを作成する
				Iterator<NotifyRelationInfoLocal> itr2 = ct.iterator();
				while(itr2.hasNext()){
					relation = itr2.next();
					
					//JobNoticeInfo用に通知関連テーブルにグループを新規作成
					//TODO : NotifyControllerBeanからAddNtorifyRelationを呼ぶべき？
					NotifyRelationInfoUtil.getLocalHome().create(
							infoNotifyGroupId, 
							relation.getNotifyId(), 
							relation.getNotifyType(), 
							relation.getNotifyFlg());
				}
			}
			catch (FinderException e) {
				e.printStackTrace();
			} 
			catch (NamingException e) {
				e.printStackTrace();
			}
		}
    }
    
}
