/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.jobmanagement.view.JobListView;

/**
 * ジョブ[一覧]ビューの「ジョブ階層ペインの表示」のクライアント側アクションクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class JobTreeShowAction implements IViewActionDelegate {
	/** ビュー */
    private IViewPart viewPart;

    /**
     * ビューを保持します。ワークベンチにロードされた際に呼ばれます。
     * 
     * @param view ビューのインスタンス
     * 
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart view) {
        viewPart = view;
    }

    /**
     * ジョブ[一覧]ビューの「ジョブ階層ペインの表示」が押された場合に、<BR>
     * ジョブ[一覧]ビューのジョブツリーの表示・非表示を切り替えます。
     * 
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     * @see com.clustercontrol.jobmanagement.view.RunScheduleListView
     * @see com.clustercontrol.jobmanagement.view.RunScheduleDetailListView
     */
    public void run(IAction action) {
        JobListView view = (JobListView) viewPart.getAdapter(JobListView.class);
        if (action.isChecked()) {
            view.show();
        } else {
            view.hide();
        }
        view.setFocus();
    }

    /* (non-Javadoc)
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {

    }

}