/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.action;

import java.util.ArrayList;

import org.eclipse.swt.SWT;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.jobmanagement.bean.WaitRuleTableDefine;
import com.clustercontrol.util.Messages;

/**
 * 待ち条件タブのテーブル定義を取得するクライアント側アクションクラス<BR>
 *
 * @version 2.1.0
 * @since 1.0.0
 */
public class GetWaitRuleTableDefine {
	
	/**
	 * 待ち条件タブのテーブル定義を作成する
	 * 
	 * @return テーブル定義情報（{@link com.clustercontrol.bean.TableColumnInfo}のリスト）
	 */
	@SuppressWarnings("unchecked")
	public static ArrayList get() {
		//テーブル定義配列
		ArrayList tableDefine = new ArrayList();
		
		tableDefine.add(WaitRuleTableDefine.JUDGMENT_OBJECT, 
				new TableColumnInfo(Messages.getString("name"), TableColumnInfo.JUDGMENT_OBJECT, 100, SWT.LEFT));
		tableDefine.add(WaitRuleTableDefine.JOB_ID, 
				new TableColumnInfo(Messages.getString("job.id"), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(WaitRuleTableDefine.START_VALUE, 
				new TableColumnInfo(Messages.getString("value"), TableColumnInfo.WAIT_RULE_VALUE, 70, SWT.LEFT));
		
		return tableDefine;
	}
}
