/*
 
Copyright (C) 2007, 2008 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

#include <windows.h>
#include <stdio.h>
#include <pdh.h>
#include <winbase.h>
#include <snmp.h>

#include <string>

using namespace std;

double GetPagingFileUsage(void);


//擾p
MEMORYSTATUSEX memstatex;

//Byte->KByteϊp萔
int DIV_MEMORY = 1024;

//100imbPʂŎ擾CPUgp̃JE^lA10~bPʂɕϊ萔
int DIV_CPU = 100000;

//y[WTCY擾p
SYSTEM_INFO system_info;

//Py[W̃TCYiKBytej
int page_size = -1;



//e֐intŕԂ悤Ɏ

AsnCounter GetCpuRawUser(){
	long ret = 0;

	HQUERY hQuery;
	HCOUNTER hCounter;
	PDH_RAW_COUNTER rawValue;

	/* VKNG[쐬 */
	PdhOpenQuery(NULL, 0, &hQuery);

	/* JE^NG[ɒǉ */
	PdhAddCounter(hQuery, "\\Processor(_Total)\\% User Time", 0, &hCounter);
//	PdhAddCounter(hQuery, "\\Process(_Total)\\% User Time", 0, &hCounter);

	/* lW */
	PdhCollectQueryData(hQuery);
	PdhGetRawCounterValue(hCounter, NULL, &rawValue);
	ret = (long)(rawValue.FirstValue / DIV_CPU);

	/* I */
	PdhCloseQuery(hQuery);

	/* vZbT̐vZ
	SYSTEM_INFO siSysInfo;
	GetSystemInfo(&siSysInfo);
	
	return ret/siSysInfo.dwNumberOfProcessors;
	*/

	return ret;
}


//Windowsł͎擾łȂ̂ŁA0Ԃ
AsnCounter GetCpuRawNice(){
	return 0;
}


AsnCounter GetCpuRawSystem(){
	long ret = 0;

	HQUERY hQuery;
	HCOUNTER hCounter;
	PDH_RAW_COUNTER rawValue;

	// VKNG[쐬 
	PdhOpenQuery(NULL, 0, &hQuery);

	// JE^NG[ɒǉ
	PdhAddCounter(hQuery, "\\Processor(_Total)\\% Privileged Time", 0, &hCounter);
//	PdhAddCounter(hQuery, "\\Process(_Total)\\% Privileged Time", 0, &hCounter);
	
	// lW
	PdhCollectQueryData(hQuery);
	PdhGetRawCounterValue(hCounter, NULL, &rawValue);
	ret = (long)(rawValue.FirstValue / DIV_CPU);

	// I 
	PdhCloseQuery(hQuery);
	
	/* vZbT̐vZ
	SYSTEM_INFO siSysInfo;
	GetSystemInfo(&siSysInfo);
	
	return ret/siSysInfo.dwNumberOfProcessors;
	*/

	return ret;
}


AsnCounter GetCpuRawIdle(){
	long ret = 0;

	HQUERY hQuery;
	HCOUNTER hCounter;
	PDH_RAW_COUNTER rawValue;

	/* VKNG[쐬 */
	PdhOpenQuery(NULL, 0, &hQuery);

	/* JE^NG[ɒǉ */
//	PdhAddCounter(hQuery, "\\Processor(_Total)\\% Idle Time", 0, &hCounter);
	PdhAddCounter(hQuery, "\\Process(Idle)\\% Processor Time", 0, &hCounter);
	
	/* lW */
	PdhCollectQueryData(hQuery);
	PdhGetRawCounterValue(hCounter, NULL, &rawValue);
	ret = (long)(rawValue.FirstValue / DIV_CPU);

	/* I */
	PdhCloseQuery(hQuery);
	
	/* vZbT̐vZ */
	SYSTEM_INFO siSysInfo;
	GetSystemInfo(&siSysInfo);
	
	return ret/siSysInfo.dwNumberOfProcessors;
}


AsnCounter GetCpuRawWait(){
	long ret = 0;
	return ret;
}

AsnCounter GetCpuRawKernel(){
	long ret = 0;
	return ret;
}

AsnCounter GetCpuRawInterrupt(){
	long ret = 0;

	HQUERY hQuery;
	HCOUNTER hCounter;
	PDH_RAW_COUNTER rawValue;

	/* VKNG[쐬 */
	PdhOpenQuery(NULL, 0, &hQuery);

	/* JE^NG[ɒǉ */
	PdhAddCounter(hQuery, "\\Processor(_Total)\\% Interrupt Time", 0, &hCounter);
	
	/* lW */
	PdhCollectQueryData(hQuery);
	PdhGetRawCounterValue(hCounter, NULL, &rawValue);
	ret = (long)(rawValue.FirstValue / DIV_CPU);

	/* I */
	PdhCloseQuery(hQuery);
	
	return ret;
}

AsnCounter GetRawInterrupts(){
	long ret = 0;

	HQUERY hQuery;
	HCOUNTER hCounter;
	PDH_RAW_COUNTER rawValue;

	/* VKNG[쐬 */
	PdhOpenQuery(NULL, 0, &hQuery);

	/* JE^NG[ɒǉ */
	PdhAddCounter(hQuery, "\\Processor(_Total)\\Interrupts/sec", 0, &hCounter);
	
	/* lW */
	PdhCollectQueryData(hQuery);
	PdhGetRawCounterValue(hCounter, NULL, &rawValue);
	ret = (long)(rawValue.FirstValue / DIV_CPU);

	/* I */
	PdhCloseQuery(hQuery);
	
	return ret;
}

AsnCounter GetRawContexts(){
	long ret = 0;

	HQUERY hQuery;
	HCOUNTER hCounter;
	PDH_RAW_COUNTER rawValue;

	/* VKNG[쐬 */
	PdhOpenQuery(NULL, 0, &hQuery);

	/* JE^NG[ɒǉ */
	PdhAddCounter(hQuery, "\\System\\Context Switches/sec", 0, &hCounter);
	
	/* lW */
	PdhCollectQueryData(hQuery);
	PdhGetRawCounterValue(hCounter, NULL, &rawValue);
	ret = (long)(rawValue.FirstValue / DIV_CPU);

	/* I */
	PdhCloseQuery(hQuery);
	
	return ret;
}


// z̍vԂ
AsnInteger GetMemTotalReal(){
	memstatex.dwLength = sizeof(memstatex);
	GlobalMemoryStatusEx(&memstatex);
	return memstatex.ullTotalPhys / DIV_MEMORY;
}

// Xbv̍viy[Wt@C̃TCYjԂ
// Xbvv = R~bg`[W̐l - v
AsnInteger GetMemTotalSwap(){
	memstatex.dwLength = sizeof(memstatex);
	GlobalMemoryStatusEx(&memstatex);
	return (memstatex.ullTotalPageFile  - memstatex.ullTotalPhys) / DIV_MEMORY;
}

// ̋󂫗eʂԂ
// ^XN}l[W̗p\̒l
AsnInteger GetMemAvailReal(){
	memstatex.dwLength = sizeof(memstatex);
	GlobalMemoryStatusEx(&memstatex);
	return memstatex.ullAvailPhys / DIV_MEMORY;
}

// Xbv̋󂫗eʂԂ
// y[Wt@C̃TCYƎgpZo
// y[Wt@C̃TCY = R~bg`[W̐l - v
AsnInteger GetMemAvailSwap(){
	return  (100 - GetPagingFileUsage()) * 	GetMemTotalSwap() / 100;
}

// 󂫗eʂƃXbv󂫗eʂ̘a
AsnInteger GetMemTotalFree(){
	return GetMemAvailReal() + GetMemAvailSwap();
}

AsnInteger GetMemBuffer(){
	int ret = 0;
	return ret;
}


// LbV
// ptH[}Xj^ŁAMemory-System Cache Resident BytesŎ擾łl
// y[WO\ȒlԂƂƂŁALp[^I
AsnInteger GetMemCached(){
	int ret = 0;

	HQUERY hQuery;
	HCOUNTER hCounter;
	PDH_FMT_COUNTERVALUE fmtValue;

	// VKNG[쐬
	PdhOpenQuery(NULL, 0, &hQuery);

	/* JE^NG[ɒǉ */
	PdhAddCounter(hQuery, "\\Memory\\System Cache Resident Bytes", 0, &hCounter);
	
	// lW
	PdhCollectQueryData(hQuery);
	PdhGetFormattedCounterValue(hCounter, PDH_FMT_LONG, NULL, &fmtValue);
	ret = fmtValue.longValue;

	// I
	PdhCloseQuery(hQuery);
	
	return ret / DIV_MEMORY;
}

//1y[W̃TCY~y[WC񐔂Zo
AsnInteger GetSsSwapIn(){

	int ret = 0;

	//y[WTCY擾ĂȂꍇ
	if (page_size == -1) {
		GetSystemInfo(&system_info);
		page_size = system_info.dwPageSize;
	}

	HQUERY hQuery;
	HCOUNTER hCounter;
	PDH_FMT_COUNTERVALUE fmtValue;

	// VKNG[쐬
	PdhOpenQuery(NULL, 0, &hQuery);

	/* JE^NG[ɒǉ */
	PdhAddCounter(hQuery, "\\Memory\\Page Reads/sec", 0, &hCounter);
	
	// lW
	PdhCollectQueryData(hQuery);
	PdhGetFormattedCounterValue(hCounter, PDH_FMT_LONG, NULL, &fmtValue);
	ret = fmtValue.longValue * page_size / DIV_MEMORY;

	// I
	PdhCloseQuery(hQuery);
	

	return ret;
}

//1y[W̃TCY~y[WAEg񐔂Zo
AsnInteger GetSsSwapOut(){

	int ret = 0;

	//y[WTCY擾ĂȂꍇ
	if (page_size == -1) {
		GetSystemInfo(&system_info);
		page_size = system_info.dwPageSize;
	}

	HQUERY hQuery;
	HCOUNTER hCounter;
	PDH_FMT_COUNTERVALUE fmtValue;

	// VKNG[쐬
	PdhOpenQuery(NULL, 0, &hQuery);

	/* JE^NG[ɒǉ */
	PdhAddCounter(hQuery, "\\Memory\\Page Writes/sec", 0, &hCounter);
	
	// lW
	PdhCollectQueryData(hQuery);
	PdhGetFormattedCounterValue(hCounter, PDH_FMT_LONG, NULL, &fmtValue);
	ret = fmtValue.longValue * page_size / DIV_MEMORY;

	// I
	PdhCloseQuery(hQuery);

	return ret;
}


AsnInteger GetLaLoadInt1(){
	int ret = 0;
	return ret;
}

AsnInteger GetLaLoadInt2(){
	int ret = 0;
	return ret;
}

AsnInteger GetLaLoadInt3(){
	int ret = 0;
	return ret;
}


AsnCounter GetDiskIORead(char *driveChar){
	long ret = 0;

	HQUERY hQuery;
	HCOUNTER hCounter;
	PDH_RAW_COUNTER rawValue;

	// VKNG[쐬
	PdhOpenQuery(NULL, 0, &hQuery);

	string strQuery = "\\LogicalDisk(";
	strQuery.append(driveChar, 1);
	string tmp = ":)\\Disk Read Bytes/sec";
	strQuery.append(tmp);

	PdhAddCounter(hQuery, strQuery.c_str(), 0, &hCounter);
	
	// lW
	PdhCollectQueryData(hQuery);
	PdhGetRawCounterValue(hCounter, NULL, &rawValue);
	ret = (long)rawValue.FirstValue;

	// I
	PdhCloseQuery(hQuery);
	
	return ret;
}


AsnCounter GetDiskIOWrite(char *driveChar){
	long ret = 0;

	HQUERY hQuery;
	HCOUNTER hCounter;
	PDH_RAW_COUNTER rawValue;

	// VKNG[쐬
	PdhOpenQuery(NULL, 0, &hQuery);

	string strQuery = "\\LogicalDisk(";
	strQuery.append(driveChar, 1);
	string tmp = ":)\\Disk Write Bytes/sec";
	strQuery.append(tmp);

	PdhAddCounter(hQuery, strQuery.c_str(), 0, &hCounter);
	
	// lW
	PdhCollectQueryData(hQuery);
	PdhGetRawCounterValue(hCounter, NULL, &rawValue);
	ret = (long)rawValue.FirstValue;

	// I
	PdhCloseQuery(hQuery);
	
	return ret;
}


AsnCounter GetDiskIOReads(char *driveChar){
	long ret = 0;

	HQUERY hQuery;
	HCOUNTER hCounter;
	PDH_RAW_COUNTER rawValue;

	// VKNG[쐬
	PdhOpenQuery(NULL, 0, &hQuery);

	string strQuery = "\\LogicalDisk(";
	strQuery.append(driveChar, 1);
	string tmp = ":)\\Disk Reads/sec";
	strQuery.append(tmp);


	PdhAddCounter(hQuery, strQuery.c_str(), 0, &hCounter);
	
	// lW
	PdhCollectQueryData(hQuery);
	PdhGetRawCounterValue(hCounter, NULL, &rawValue);
	ret = (long)rawValue.FirstValue;

	// I
	PdhCloseQuery(hQuery);
	
	return ret;
}


AsnCounter GetDiskIOWrites(char *driveChar){
	long ret = 0;

	HQUERY hQuery;
	HCOUNTER hCounter;
	PDH_RAW_COUNTER rawValue;

	// VKNG[쐬
	PdhOpenQuery(NULL, 0, &hQuery);

	string strQuery = "\\LogicalDisk(";
	strQuery.append(driveChar, 1);
	string tmp = ":)\\Disk Writes/sec";
	strQuery.append(tmp);

	PdhAddCounter(hQuery, strQuery.c_str(), 0, &hCounter);
	
	// lW
	PdhCollectQueryData(hQuery);
	PdhGetRawCounterValue(hCounter, NULL, &rawValue);
	ret = (long)rawValue.FirstValue;

	// I
	PdhCloseQuery(hQuery);
	
	return ret;
}


// PagingFile̎gpŕԂ
double GetPagingFileUsage(void) {
	int ret = 0;

	HQUERY hQuery;
	HCOUNTER hCounter;
	PDH_FMT_COUNTERVALUE fmtValue;

	int totalSwap = GetMemTotalSwap();

	// VKNG[쐬
	PdhOpenQuery(NULL, 0, &hQuery);

	/* JE^NG[ɒǉ */
	PdhAddCounter(hQuery, "\\Paging File(_Total)\\% Usage", 0, &hCounter);
	
	// lW
	PdhCollectQueryData(hQuery);
	PdhGetFormattedCounterValue(hCounter, PDH_FMT_DOUBLE, NULL, &fmtValue);
	ret = fmtValue.doubleValue;

	// I
	PdhCloseQuery(hQuery);
	
	return ret;

}