/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.logtransfer.action;

import com.clustercontrol.bean.DataRangeConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.util.Messages;

/**
 * 転送対象ログファイル用プロパティを作成するアクションクラス<BR>
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class LogTransferFileProperty {
	
	/** ファイルパス */
	public static final String FILE_PATH = "filePath";
	/** 動作間隔（秒） */
	public static final String RUN_INTERVAL = "runInterval";
	/** 最初にファイルをチェック */
	public static final String EXISTENCE_FLG = "existenceFlg";
	/** 有効／無効 */
	public static final String VALID = "valid";
	
	
	/**
	 * 転送対象ログファイル用プロパティを返します。
	 * 
	 * @param locale
	 * @return 転送対象ログファイル用プロパティ
	 */
	public Property getProperty() {
		
		//ファイルパス
		Property m_filePath =
			new Property(FILE_PATH, Messages.getString("file.path"), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_4096);
		//動作間隔（秒）
		Property m_runInterval =
			new Property(RUN_INTERVAL, Messages.getString("semantics.interval.sec"), PropertyConstant.EDITOR_NUM, 
					DataRangeConstant.SMALLINT_HIGH, 1);
		//最初にファイルをチェック
		Property m_existenceFlg =
			new Property(EXISTENCE_FLG, Messages.getString("file.first.existence.check"), PropertyConstant.EDITOR_BOOL);
		//有効
		Property m_vaild =
			new Property(VALID, Messages.getString("valid") + "/" + Messages.getString("invalid"), PropertyConstant.EDITOR_SELECT);
		
		//値を初期化
		m_filePath.setValue("");
		m_runInterval.setValue("");
		m_existenceFlg.setValue(new Boolean(true));
		
		Object validValues[][] = { 
				{ ValidConstant.STRING_VALID, ValidConstant.STRING_INVALID}, 
				{ ValidConstant.STRING_VALID, ValidConstant.STRING_INVALID}};
				
		m_vaild.setSelectValues(validValues);
		m_vaild.setValue(ValidConstant.STRING_VALID);
		
		//変更の可/不可を設定
		m_filePath.setModify(PropertyConstant.MODIFY_OK);
		m_runInterval.setModify(PropertyConstant.MODIFY_OK);
		m_existenceFlg.setModify(PropertyConstant.MODIFY_OK);
		m_vaild.setModify(PropertyConstant.MODIFY_OK);
		
		Property property = new Property(null, null, "");
		
		// 初期表示ツリーを構成。
		property.removeChildren();
		property.addChildren(m_filePath);
		property.addChildren(m_runInterval);
		property.addChildren(m_existenceFlg);
		property.addChildren(m_vaild);
		
		return property;
	}
}
