/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.logtransfer.ejb.mdb;

import com.clustercontrol.commons.util.SendQueue;
import com.clustercontrol.repository.message.UpdateRepositoryInfo;
import java.io.Serializable;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReceiveUpdateRepositoryBean
implements MessageDrivenBean,
MessageListener {
    protected static Log m_log = LogFactory.getLog(ReceiveUpdateRepositoryBean.class);
    private MessageDrivenContext messageContext = null;

    public void setMessageDrivenContext(MessageDrivenContext messageContext) throws EJBException {
        this.messageContext = messageContext;
    }

    public void ejbCreate() {
    }

    public void ejbRemove() {
        this.messageContext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        m_log.debug((Object)("Message Driven Bean got message " + message));
        if (message instanceof ObjectMessage) {
            ObjectMessage objectMessage = (ObjectMessage)message;
            SendQueue queue = null;
            try {
                Serializable obj = objectMessage.getObject();
                if (obj instanceof UpdateRepositoryInfo) {
                    queue = new SendQueue("queue/clustercontrolLogtransferLogTransferFileManage");
                    queue.put((Serializable)((UpdateRepositoryInfo)obj));
                } else {
                    m_log.debug((Object)("onMessage(): ObjectMessage is not an expected instance. " + obj.toString()));
                }
            }
            catch (JMSException e) {
                m_log.error((Object)("onMessage():" + e.getMessage()));
            }
            catch (EJBException e) {
                m_log.error((Object)("onMessage():" + e.getMessage()));
            }
            catch (Exception e) {
                m_log.error((Object)("onMessage():" + e.getMessage()));
            }
            finally {
                if (queue != null) {
                    try {
                        queue.terminate();
                    }
                    catch (JMSException e) {
                        m_log.error((Object)("Terminate SendQueue Failed : " + e.getMessage()));
                    }
                }
            }
        }
    }
}

