/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.mail.factory;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.notify.mail.ejb.entity.MailTemplateInfoData;
import com.clustercontrol.notify.mail.ejb.entity.MailTemplateInfoLocal;
import com.clustercontrol.notify.mail.ejb.entity.MailTemplateInfoUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.apllog.AplLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectMailTemplate {
    protected static Log m_log = LogFactory.getLog(SelectMailTemplate.class);

    public MailTemplateInfoData getMailTemplateInfo(String mailTemplateId) throws FinderException, NamingException {
        MailTemplateInfoData data = null;
        try {
            MailTemplateInfoLocal infoLocal = MailTemplateInfoUtil.getLocalHome().findByPrimaryKey(mailTemplateId);
            data = new MailTemplateInfoData();
            data.setMailTemplateId(infoLocal.getMailTemplateId());
            data.setDescription(infoLocal.getDescription());
            data.setSubject(infoLocal.getSubject());
            data.setBody(infoLocal.getBody());
            data.setRegDate(infoLocal.getRegDate());
            data.setUpdateDate(infoLocal.getUpdateDate());
            data.setRegUser(infoLocal.getRegUser());
            data.setUpdateUser(infoLocal.getUpdateUser());
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("MAILTEMP", "mailTemplate");
            Object[] args = new String[]{mailTemplateId};
            apllog.put("SYS", "004", args);
            m_log.warn((Object)("getMailTemplate():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("MAILTEMP", "mailTemplate");
            Object[] args = new String[]{mailTemplateId};
            apllog.put("SYS", "004", args);
            m_log.warn((Object)("getMailTemplate():" + e.getMessage()));
            throw e;
        }
        return data;
    }

    public ArrayList<String> getMailTemplateIdList() throws FinderException, NamingException {
        ArrayList<String> list = null;
        try {
            Collection ct = MailTemplateInfoUtil.getLocalHome().findAllOrderByMailTemplateId();
            Iterator itr = ct.iterator();
            while (itr.hasNext()) {
                if (list == null) {
                    list = new ArrayList<String>();
                }
                MailTemplateInfoLocal mailTemplate = (MailTemplateInfoLocal)itr.next();
                list.add(mailTemplate.getMailTemplateId());
            }
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("MAILTEMP", "mailTemplate");
            apllog.put("SYS", "005");
            m_log.warn((Object)("getMailTemplateIdList():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("MAILTEMP", "mailTemplate");
            apllog.put("SYS", "005");
            m_log.warn((Object)("getMailTemplateIdList():" + e.getMessage()));
            throw e;
        }
        return list;
    }

    public ArrayList getMailTemplateList() throws CreateException, FinderException, NamingException {
        ArrayList<ArrayList> list = null;
        try {
            Collection ct = MailTemplateInfoUtil.getLocalHome().findAllOrderByMailTemplateId();
            list = this.collectionToArray(ct);
        }
        catch (CreateException e) {
            AplLogger apllog = new AplLogger("MAILTEMP", "mailTemplate");
            apllog.put("SYS", "006");
            m_log.warn((Object)("getMailTemplateList():" + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("MAILTEMP", "mailTemplate");
            apllog.put("SYS", "006");
            m_log.warn((Object)("getMailTemplateList():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("MAILTEMP", "mailTemplate");
            apllog.put("SYS", "006");
            m_log.warn((Object)("getMailTemplateList():" + e.getMessage()));
            throw e;
        }
        return list;
    }

    public HashMap<String, MailTemplateInfoData> getMailTemplateMap() throws FinderException, NamingException {
        HashMap<String, MailTemplateInfoData> map = new HashMap<String, MailTemplateInfoData>();
        try {
            Collection ct = MailTemplateInfoUtil.getLocalHome().findAll();
            Iterator itr = ct.iterator();
            MailTemplateInfoLocal mailTemplate = null;
            while (itr.hasNext()) {
                mailTemplate = (MailTemplateInfoLocal)itr.next();
                MailTemplateInfoData data = new MailTemplateInfoData();
                data.setMailTemplateId(mailTemplate.getMailTemplateId());
                data.setDescription(mailTemplate.getDescription());
                data.setSubject(mailTemplate.getSubject());
                data.setBody(mailTemplate.getBody());
                data.setRegDate(mailTemplate.getRegDate());
                data.setUpdateDate(mailTemplate.getUpdateDate());
                data.setRegUser(mailTemplate.getRegUser());
                data.setUpdateUser(mailTemplate.getUpdateUser());
                map.put(mailTemplate.getMailTemplateId(), data);
            }
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            apllog.put("SYS", "006");
            m_log.debug((Object)("getNotifyMap():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            apllog.put("SYS", "006");
            m_log.debug((Object)("getNotifyMap():" + e.getMessage()));
            throw e;
        }
        return map;
    }

    public ArrayList<TableColumnInfo> getMailTemplateListTableDefine(Locale locale) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo(Messages.getString((String)"mail.template.id", (Locale)locale), -1, 130, 16384));
        tableDefine.add(1, new TableColumnInfo(Messages.getString((String)"description", (Locale)locale), -1, 200, 16384));
        tableDefine.add(2, new TableColumnInfo(Messages.getString((String)"creator.name", (Locale)locale), -1, 80, 16384));
        tableDefine.add(3, new TableColumnInfo(Messages.getString((String)"create.time", (Locale)locale), -1, 130, 16384));
        tableDefine.add(4, new TableColumnInfo(Messages.getString((String)"modifier.name", (Locale)locale), -1, 80, 16384));
        tableDefine.add(5, new TableColumnInfo(Messages.getString((String)"update.time", (Locale)locale), -1, 130, 16384));
        return tableDefine;
    }

    private ArrayList<ArrayList> collectionToArray(Collection ct) throws CreateException, FinderException, NamingException {
        ArrayList<ArrayList> list = new ArrayList<ArrayList>();
        for (MailTemplateInfoLocal mailTemplate : ct) {
            ArrayList<Object> info = new ArrayList<Object>();
            info.add(mailTemplate.getMailTemplateId());
            info.add(mailTemplate.getDescription());
            info.add(mailTemplate.getRegUser());
            info.add(new Date(mailTemplate.getRegDate().getTime()));
            info.add(mailTemplate.getUpdateUser());
            info.add(new Date(mailTemplate.getUpdateDate().getTime()));
            list.add(info);
        }
        return list;
    }
}

