/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.util.code;

import com.clustercontrol.performance.monitor.ejb.entity.CollectorCategoryCollectMstLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorCategoryCollectMstUtil;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorCategoryMstData;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorCategoryMstLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorCategoryMstUtil;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorDeviceInfoData;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorDeviceInfoLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorDeviceInfoUtil;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCalcMethodMstLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCalcMethodMstUtil;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCodeMstData;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCodeMstLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCodeMstUtil;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorScopeSnapLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorScopeSnapUtil;
import com.clustercontrol.performance.util.Repository;
import com.clustercontrol.performance.util.code.CollectorItemTreeItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectorItemCodeTable {
    private static Log m_log = LogFactory.getLog(CollectorItemCodeTable.class);
    private static final HashMap<String, CollectorItemTreeItem> m_codeTable = new HashMap();

    public static CollectorItemTreeItem[] createTree(Set<CollectorItemCodeMstData> codeSet, Set<CollectorItemCodeMstData> disableCodeSet, String collectMethod, Set<CollectorDeviceInfoData> deviceSet) {
        ArrayList<CollectorItemTreeItem> itemTree = new ArrayList<CollectorItemTreeItem>();
        HashMap<String, CollectorItemTreeItem> categoryMap = new HashMap<String, CollectorItemTreeItem>();
        Collection cate = null;
        try {
            cate = CollectorCategoryMstUtil.getLocalHome().findAll();
        }
        catch (FinderException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NamingException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        for (CollectorCategoryMstLocal bean : cate) {
            CollectorCategoryMstData category = new CollectorCategoryMstData(bean.getCategoryCode(), bean.getCategoryName());
            CollectorItemTreeItem categoryItem = new CollectorItemTreeItem(null, category, null, null);
            categoryMap.put(bean.getCategoryCode(), categoryItem);
            itemTree.add(categoryItem);
        }
        CollectorItemTreeItem[] list = itemTree.toArray(new CollectorItemTreeItem[0]);
        Arrays.sort(list, new Comparator<CollectorItemTreeItem>(){

            @Override
            public int compare(CollectorItemTreeItem o1, CollectorItemTreeItem o2) {
                return o1.getCategory().getCategoryCode().compareTo(o2.getCategory().getCategoryCode());
            }
        });
        HashMap<ItemCodeAndDisplayName, CollectorItemTreeItem> createdCodeItemMap = new HashMap<ItemCodeAndDisplayName, CollectorItemTreeItem>();
        Iterator<CollectorItemCodeMstData> itr = codeSet.iterator();
        HashSet<String> createdCodeSet = new HashSet<String>();
        while (itr.hasNext()) {
            CollectorItemCodeMstData itemCodeData = itr.next();
            CollectorItemCodeTable.createItemTreeItem(createdCodeSet, itemCodeData, codeSet, collectMethod, deviceSet, categoryMap, createdCodeItemMap);
        }
        return list;
    }

    private static void createItemTreeItem(HashSet<String> createdCodeSet, CollectorItemCodeMstData itemCodeData, Set<CollectorItemCodeMstData> codeSet, String collectMethod, Set<CollectorDeviceInfoData> deviceSet, HashMap<String, CollectorItemTreeItem> categoryMap, HashMap<ItemCodeAndDisplayName, CollectorItemTreeItem> createdCodeMap) {
        if (createdCodeSet.contains(itemCodeData.getItemCode())) {
            return;
        }
        String parentItemCode = itemCodeData.getParentItemCode();
        if (parentItemCode == null) {
            CollectorItemTreeItem parentItem = categoryMap.get(itemCodeData.getCategoryCode());
            if (parentItem == null) {
                return;
            }
            if (itemCodeData.getDeviceSupport() == 0) {
                CollectorItemTreeItem item = new CollectorItemTreeItem(parentItem, itemCodeData, collectMethod, null);
                createdCodeMap.put(new ItemCodeAndDisplayName(itemCodeData.getItemCode(), null), item);
            } else {
                for (CollectorDeviceInfoData dData : deviceSet) {
                    if (!itemCodeData.getDeviceType().equals(dData.getDeviceType())) continue;
                    CollectorItemTreeItem item = new CollectorItemTreeItem(parentItem, itemCodeData, collectMethod, dData);
                    createdCodeMap.put(new ItemCodeAndDisplayName(itemCodeData.getItemCode(), dData.getDisplayName()), item);
                }
            }
        } else if (itemCodeData.getDeviceSupport() == 0) {
            CollectorItemTreeItem parentItem = createdCodeMap.get(new ItemCodeAndDisplayName(itemCodeData.getParentItemCode(), null));
            if (parentItem == null) {
                for (CollectorItemCodeMstData data : codeSet) {
                    if (!parentItemCode.equals(data.getItemCode())) continue;
                    CollectorItemCodeTable.createItemTreeItem(createdCodeSet, data, codeSet, collectMethod, deviceSet, categoryMap, createdCodeMap);
                }
                parentItem = createdCodeMap.get(new ItemCodeAndDisplayName(itemCodeData.getParentItemCode(), null));
                if (parentItem == null) {
                    parentItem = categoryMap.get(itemCodeData.getCategoryCode());
                }
            }
            CollectorItemTreeItem item = new CollectorItemTreeItem(parentItem, itemCodeData, collectMethod, null);
            createdCodeMap.put(new ItemCodeAndDisplayName(itemCodeData.getItemCode(), null), item);
        } else {
            for (CollectorDeviceInfoData dData : deviceSet) {
                if (!itemCodeData.getDeviceType().equals(dData.getDeviceType())) continue;
                CollectorItemTreeItem parentItem = createdCodeMap.get(new ItemCodeAndDisplayName(itemCodeData.getParentItemCode(), dData.getDisplayName()));
                if (parentItem == null) {
                    for (CollectorItemCodeMstData data : codeSet) {
                        if (!parentItemCode.equals(data.getItemCode())) continue;
                        CollectorItemCodeTable.createItemTreeItem(createdCodeSet, data, codeSet, collectMethod, deviceSet, categoryMap, createdCodeMap);
                    }
                    parentItem = createdCodeMap.get(new ItemCodeAndDisplayName(itemCodeData.getParentItemCode(), dData.getDisplayName()));
                    if (parentItem == null) {
                        parentItem = categoryMap.get(itemCodeData.getCategoryCode());
                    }
                }
                CollectorItemTreeItem item = new CollectorItemTreeItem(parentItem, itemCodeData, collectMethod, dData);
                createdCodeMap.put(new ItemCodeAndDisplayName(itemCodeData.getItemCode(), dData.getDisplayName()), item);
            }
        }
        createdCodeSet.add(itemCodeData.getItemCode());
    }

    public static CollectorItemTreeItem[] getCollectorTree(String facilityId, String collectorId) {
        return CollectorItemCodeTable.getCollectorTree(facilityId, collectorId, null);
    }

    private static CollectorItemTreeItem[] getCollectorTree(String facilityId, String collectorId, String collectMethod) {
        String subPlatformId;
        String platformId;
        HashSet<CollectorDeviceInfoData> deviceSet = new HashSet<CollectorDeviceInfoData>();
        HashSet<PlatformIdAndSubPlatformId> platformCombSet = new HashSet<PlatformIdAndSubPlatformId>();
        HashSet deviceSetAdd = new HashSet();
        HashSet deviceSetRetain = null;
        HashMap<DeviceTypeAndDisplayName, String> deviceNameMap = new HashMap<DeviceTypeAndDisplayName, String>();
        if (collectorId == null) {
            if (facilityId != null) {
                Repository repository = new Repository();
                if (repository.isNode(facilityId)) {
                    String platformId2 = Repository.getPlatformId(facilityId);
                    String subPlatformId2 = Repository.getSubPlatformId(facilityId);
                    PlatformIdAndSubPlatformId platformIdComb = new PlatformIdAndSubPlatformId(platformId2, subPlatformId2);
                    platformCombSet.add(platformIdComb);
                    List<CollectorDeviceInfoData> deviceList = repository.getDeviceList(facilityId);
                    Iterator<CollectorDeviceInfoData> itr = deviceList.iterator();
                    HashSet<DeviceTypeAndDisplayName> tmp = new HashSet<DeviceTypeAndDisplayName>();
                    while (itr.hasNext()) {
                        CollectorDeviceInfoData data = itr.next();
                        DeviceTypeAndDisplayName tan = new DeviceTypeAndDisplayName(data.getDeviceType(), data.getDisplayName());
                        tmp.add(tan);
                        deviceNameMap.put(tan, data.getDeviceName());
                    }
                    deviceSetAdd.addAll(tmp);
                    deviceSetRetain = new HashSet(tmp);
                } else {
                    ArrayList<ArrayList<String>> nodeList = repository.getNodeList(facilityId);
                    Iterator nodeItr = nodeList.iterator();
                    while (nodeItr.hasNext()) {
                        String nodeFacilityId = ((String)((ArrayList)nodeItr.next()).get(0)).toString();
                        platformId = Repository.getPlatformId(nodeFacilityId);
                        subPlatformId = Repository.getSubPlatformId(nodeFacilityId);
                        PlatformIdAndSubPlatformId platformIdComb = new PlatformIdAndSubPlatformId(platformId, subPlatformId);
                        platformCombSet.add(platformIdComb);
                        List<CollectorDeviceInfoData> deviceList = repository.getDeviceList(nodeFacilityId);
                        Iterator<CollectorDeviceInfoData> itr = deviceList.iterator();
                        HashSet<DeviceTypeAndDisplayName> tmp = new HashSet<DeviceTypeAndDisplayName>();
                        while (itr.hasNext()) {
                            CollectorDeviceInfoData data = itr.next();
                            DeviceTypeAndDisplayName tan = new DeviceTypeAndDisplayName(data.getDeviceType(), data.getDisplayName());
                            tmp.add(tan);
                            deviceNameMap.put(tan, data.getDeviceName());
                        }
                        deviceSetAdd.addAll(tmp);
                        if (deviceSetRetain == null) {
                            deviceSetRetain = new HashSet(tmp);
                            continue;
                        }
                        deviceSetRetain.retainAll(tmp);
                    }
                }
            }
        } else {
            Collection col;
            Collection facilitys;
            try {
                facilitys = CollectorScopeSnapUtil.getLocalHome().findByCollectorId(collectorId);
            }
            catch (FinderException e) {
                m_log.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
            catch (NamingException e) {
                m_log.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
            try {
                col = CollectorDeviceInfoUtil.getLocalHome().findByCollectorId(collectorId);
            }
            catch (FinderException e) {
                m_log.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
            catch (NamingException e) {
                m_log.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
            for (CollectorScopeSnapLocal bean : facilitys) {
                if (!"node".equals(bean.getFacilityType())) continue;
                platformId = bean.getPlatformId();
                subPlatformId = bean.getSubPlatformId();
                platformCombSet.add(new PlatformIdAndSubPlatformId(platformId, subPlatformId));
                String targetFacilityId = bean.getFacilityId();
                Iterator nodeItr = col.iterator();
                HashSet<DeviceTypeAndDisplayName> tmp = new HashSet<DeviceTypeAndDisplayName>();
                while (nodeItr.hasNext()) {
                    CollectorDeviceInfoLocal deviceInfo = (CollectorDeviceInfoLocal)nodeItr.next();
                    if (!targetFacilityId.equals(deviceInfo.getFacilityId())) continue;
                    DeviceTypeAndDisplayName tan = new DeviceTypeAndDisplayName(deviceInfo.getDeviceType(), deviceInfo.getDisplayName());
                    tmp.add(tan);
                    deviceNameMap.put(tan, deviceInfo.getDeviceName());
                }
                deviceSetAdd.addAll(tmp);
                if (deviceSetRetain == null) {
                    deviceSetRetain = new HashSet(tmp);
                    continue;
                }
                deviceSetRetain.retainAll(tmp);
            }
        }
        HashSet<CollectorItemCodeMstData> codeSet = null;
        HashSet<CollectorItemCodeMstData> disableCodeSet = new HashSet<CollectorItemCodeMstData>();
        for (PlatformIdAndSubPlatformId platformComb : platformCombSet) {
            Collection calsMethods;
            Collection collects;
            m_log.debug((Object)("getCollectorTree() platformId : " + platformComb.getPlatformId() + ", subPlatformId : " + platformComb.getSubPlatformId() + ", collectMethod : " + collectMethod));
            try {
                collects = CollectorCategoryCollectMstUtil.getLocalHome().findByPlatformIdAndSubPlatformId(platformComb.getPlatformId(), platformComb.getSubPlatformId());
                calsMethods = CollectorItemCalcMethodMstUtil.getLocalHome().findByPlatformIdAndSubPlatformId(platformComb.getPlatformId(), platformComb.getSubPlatformId());
            }
            catch (FinderException e) {
                m_log.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
            catch (NamingException e) {
                m_log.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
            HashMap<String, String> categoryMap = new HashMap<String, String>();
            for (CollectorCategoryCollectMstLocal collect : collects) {
                categoryMap.put(collect.getCategoryCode(), collect.getCollectMethod());
            }
            HashSet<CollectorItemCodeMstData> tmpByPlatform = new HashSet<CollectorItemCodeMstData>();
            for (CollectorItemCalcMethodMstLocal bean : calsMethods) {
                CollectorItemCodeMstData codeData;
                CollectorItemCodeMstLocal codeBean;
                if (collectMethod == null || collectMethod.equals("")) {
                    try {
                        codeBean = CollectorItemCodeMstUtil.getLocalHome().findByPrimaryKey(bean.getItemCode());
                    }
                    catch (FinderException e) {
                        m_log.error((Object)e.getMessage(), (Throwable)e);
                        return null;
                    }
                    catch (NamingException e) {
                        m_log.error((Object)e.getMessage(), (Throwable)e);
                        return null;
                    }
                    if (categoryMap.get(codeBean.getCategoryCode()) == null || !((String)categoryMap.get(codeBean.getCategoryCode())).equals(bean.getCollectMethod())) continue;
                    codeData = new CollectorItemCodeMstData(codeBean.getItemCode(), codeBean.getCategoryCode(), codeBean.getParentItemCode(), codeBean.getItemName(), codeBean.getMeasure(), codeBean.getDeviceSupport(), codeBean.getDeviceType(), codeBean.getGraphRange());
                    tmpByPlatform.add(codeData);
                    continue;
                }
                if (!collectMethod.equals(bean.getCollectMethod())) continue;
                try {
                    codeBean = CollectorItemCodeMstUtil.getLocalHome().findByPrimaryKey(bean.getItemCode());
                }
                catch (FinderException e) {
                    m_log.error((Object)e.getMessage(), (Throwable)e);
                    return null;
                }
                catch (NamingException e) {
                    m_log.error((Object)e.getMessage(), (Throwable)e);
                    return null;
                }
                if (categoryMap.get(codeBean.getCategoryCode()) == null || !((String)categoryMap.get(codeBean.getCategoryCode())).equals(bean.getCollectMethod())) continue;
                codeData = new CollectorItemCodeMstData(codeBean.getItemCode(), codeBean.getCategoryCode(), codeBean.getParentItemCode(), codeBean.getItemName(), codeBean.getMeasure(), codeBean.getDeviceSupport(), codeBean.getDeviceType(), codeBean.getGraphRange());
                tmpByPlatform.add(codeData);
            }
            if (codeSet == null) {
                codeSet = new HashSet(tmpByPlatform);
            } else {
                codeSet.retainAll(tmpByPlatform);
            }
            disableCodeSet.addAll(tmpByPlatform);
        }
        if (deviceSetRetain == null) {
            deviceSetRetain = new HashSet();
        }
        for (DeviceTypeAndDisplayName info : deviceSetRetain) {
            CollectorDeviceInfoData deviceData = new CollectorDeviceInfoData(null, null, (String)deviceNameMap.get(info), info.getDisplayName(), null, null, info.getDeviceType());
            deviceSet.add(deviceData);
        }
        if (codeSet == null) {
            codeSet = new HashSet<CollectorItemCodeMstData>();
        }
        disableCodeSet.removeAll(codeSet);
        return CollectorItemCodeTable.createTree(codeSet, disableCodeSet, collectMethod, deviceSet);
    }

    public static String getFullItemName(String itemCode, String displayName) {
        try {
            CollectorItemCodeMstLocal bean = CollectorItemCodeMstUtil.getLocalHome().findByPrimaryKey(itemCode);
            String itemName = bean.getItemName();
            if (bean.getDeviceSupport() == 1) {
                itemName = itemName + "[" + displayName + "]";
            }
            return itemName;
        }
        catch (FinderException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NamingException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        return itemCode + " is not found.";
    }

    public static HashMap<String, CollectorItemTreeItem> getItemCodeMap() {
        return m_codeTable;
    }

    static {
        HashMap<String, CollectorItemTreeItem> categoryTable = new HashMap<String, CollectorItemTreeItem>();
        Collection cate = null;
        try {
            cate = CollectorCategoryMstUtil.getLocalHome().findAll();
        }
        catch (FinderException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NamingException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        for (CollectorCategoryMstLocal bean : cate) {
            CollectorCategoryMstData category = new CollectorCategoryMstData(bean.getCategoryCode(), bean.getCategoryName());
            CollectorItemTreeItem categoryItem = new CollectorItemTreeItem(null, category, null, null);
            categoryTable.put(bean.getCategoryCode(), categoryItem);
        }
        try {
            Collection ctItemCodeMst = CollectorItemCodeMstUtil.getLocalHome().findAll();
            for (CollectorItemCodeMstLocal codeBean : ctItemCodeMst) {
                String itemCode = codeBean.getItemCode();
                if (itemCode == null || itemCode == null || codeBean.getCategoryCode() == null || codeBean.getDeviceSupport() == null || codeBean.getGraphRange() == null) continue;
                CollectorItemCodeMstData codeData = new CollectorItemCodeMstData(codeBean.getItemCode(), codeBean.getCategoryCode(), codeBean.getParentItemCode(), codeBean.getItemName(), codeBean.getMeasure(), codeBean.getDeviceSupport(), codeBean.getDeviceType(), codeBean.getGraphRange());
                CollectorItemTreeItem categoryTreeItem = (CollectorItemTreeItem)categoryTable.get(codeBean.getCategoryCode());
                CollectorItemTreeItem parentItem = m_codeTable.get(codeBean.getParentItemCode());
                if (parentItem == null) {
                    parentItem = categoryTreeItem;
                }
                CollectorItemTreeItem ctItem = new CollectorItemTreeItem(parentItem, codeData, null, null);
                m_codeTable.put(itemCode, ctItem);
            }
        }
        catch (Exception e) {
            m_codeTable.clear();
            e.printStackTrace();
        }
    }

    private static class PlatformIdAndSubPlatformId {
        private String m_platformId;
        private String m_subPlatformId;

        public PlatformIdAndSubPlatformId(String platformId, String subPlatformId) {
            this.m_platformId = platformId;
            this.m_subPlatformId = subPlatformId;
        }

        public String getPlatformId() {
            return this.m_platformId;
        }

        public String getSubPlatformId() {
            return this.m_subPlatformId;
        }

        public boolean equals(Object other) {
            if (other instanceof PlatformIdAndSubPlatformId) {
                PlatformIdAndSubPlatformId info = (PlatformIdAndSubPlatformId)other;
                if (this.m_platformId == null && this.m_subPlatformId == null) {
                    if (info.m_platformId == null && info.m_subPlatformId == null) {
                        return true;
                    }
                } else if (this.m_platformId == null && this.m_subPlatformId != null) {
                    if (info.m_platformId == null && this.m_subPlatformId.equals(info.m_subPlatformId)) {
                        return true;
                    }
                } else if (this.m_platformId != null && this.m_subPlatformId == null) {
                    if (this.m_platformId.equals(info.m_platformId) && info.m_subPlatformId == null) {
                        return true;
                    }
                } else if (this.m_platformId.equals(info.m_platformId)) {
                    return this.m_subPlatformId.equals(info.m_subPlatformId);
                }
                return false;
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + (this.m_platformId != null ? this.m_platformId.hashCode() : 0);
            result = 37 * result + (this.m_subPlatformId != null ? this.m_subPlatformId.hashCode() : 0);
            return result;
        }
    }

    public static class DeviceTypeAndDisplayName {
        private String deviceType;
        private String displayName;

        public DeviceTypeAndDisplayName(String deviceType, String displayName) {
            this.deviceType = deviceType;
            this.displayName = displayName != null ? displayName : "";
        }

        public boolean equals(Object other) {
            if (other instanceof DeviceTypeAndDisplayName) {
                DeviceTypeAndDisplayName info = (DeviceTypeAndDisplayName)other;
                if (this.deviceType == null && this.displayName == null) {
                    if (info.deviceType == null && info.displayName == null) {
                        return true;
                    }
                } else if (this.deviceType == null && this.displayName != null) {
                    if (info.deviceType == null && this.displayName.equals(info.displayName)) {
                        return true;
                    }
                } else if (this.deviceType != null && this.displayName == null) {
                    if (this.deviceType.equals(info.deviceType) && info.displayName == null) {
                        return true;
                    }
                } else if (this.deviceType.equals(info.deviceType)) {
                    return this.displayName.equals(info.displayName);
                }
                return false;
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + (this.deviceType != null ? this.deviceType.hashCode() : 0);
            result = 37 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
            return result;
        }

        public String getDeviceType() {
            return this.deviceType;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }

    private static class ItemCodeAndDisplayName {
        private String itemCode;
        private String displayName;

        public ItemCodeAndDisplayName(String itemCode, String displayName) {
            this.itemCode = itemCode;
            this.displayName = displayName;
        }

        public boolean equals(Object other) {
            if (other instanceof ItemCodeAndDisplayName) {
                ItemCodeAndDisplayName info = (ItemCodeAndDisplayName)other;
                if (this.itemCode == null && this.displayName == null) {
                    if (info.itemCode == null && info.displayName == null) {
                        return true;
                    }
                } else if (this.itemCode == null && this.displayName != null) {
                    if (info.itemCode == null && this.displayName.equals(info.displayName)) {
                        return true;
                    }
                } else if (this.itemCode != null && this.displayName == null) {
                    if (this.itemCode.equals(info.itemCode) && info.displayName == null) {
                        return true;
                    }
                } else if (this.itemCode.equals(info.itemCode)) {
                    return this.displayName.equals(info.displayName);
                }
                return false;
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + (this.itemCode != null ? this.itemCode.hashCode() : 0);
            result = 37 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
            return result;
        }
    }
}

