#!/bin/bash

echo ""
echo ""
echo "#################################################"
echo "### HinemosDB stats collect script (20091113) ###"
echo "###    Script start at `date '+%Y-%m-%d %T'`    ###"
echo "#################################################"
echo ""

function usage {
        echo "usage: "
        echo "$0 -v   : Get information about HINEMOS DB SUMMARY"
        echo "$0 -vv  : Get information about HINEMOS DB SUMMARY + OS INFORMATION"
        echo "$0 -vvv : Get information about DETAIL"
        return 0
}

function init {
## Hinemos env
. /opt/hinemos/hinemos.cfg
}

function hinemos {
## Version
VER=`cat ${HINEMOS_HOME}/_version`
VER_MJ=`echo ${VER} | cut -c1-3`

echo "Installed Hinemos ver : ${VER}"
echo ""

## init valiable
HOST="localhost"
PGPORT=24001
LDAPPORT=24000
PSQLBIN="${PG}/bin/psql"
case ${VER_MJ} in
    '2.4')
    TABLE_COLLECTOR_PROFILE="collector_profile"
    TABLE_CALCULATED_DATA="calculated_data"
    COLUMN_COLLECTOR_PROFILE_INTERVAL="interval"
    VALUE_TRIGGER_NAME_PROCESS="PROCESS"
    ;;
    '3.0' | '3.1' | *)
    TABLE_COLLECTOR_PROFILE="cc_collector_profile"
    TABLE_CALCULATED_DATA="cc_calculated_data"
    COLUMN_COLLECTOR_PROFILE_INTERVAL="interval_sec"
    VALUE_TRIGGER_NAME_PROCESS="MON_PRC"
    ;;
    '2.0' | '2.1' | '2.2' | '2.3')
    echo "This script does not support Hinemos ${VER}" 1>&2
    echo "VER=${VER}, VER_MJ=${VER_MJ}"
    exit 1
    ;;
esac
LDAPBIN="${LDAP}/bin/ldapsearch"
DBNAME=hinemos
USER=hinemos
FILENAME="${HINEMOS_HOME}/var/log/db-summary.`date '+%Y-%m-%d_%T'`"
TMPFILE="${HINEMOS_HOME}/var/log/db-summary.tmp"

PSQLCMD="${PSQLBIN} -h ${HOST} -p ${PGPORT} -U ${USER} -d ${DBNAME} "
PSQLCMD_NA="${PSQLBIN} -h ${HOST} -p ${PGPORT} -U ${USER} -d ${DBNAME} -A -t "

## postgresql password
## postgresql connect check
export PGPASSWORD="hinemos"
read -p "Postgres Password (default hinemos) : " PASSWD
if [ "${PASSWD}" != "" ] ; then
    export PGPASSWORD=${PASSWD}
fi
RESULT=`${PSQLCMD_NA} -c "SELECT 1;"`
EXIT_CODE=$?
if [ ${EXIT_CODE} -ne 0 ] ; then
    echo "Failed to access PostgreSQL" 1>&2
    echo "exit code ${EXIT_CODE}" 1>&2
    exit ${EXIT_CODE}
fi

## ldap password
## openldap connect check
read -p "OpenLDAP Password (default hinemos) : " PASSWD
if [ "${PASSWD}" != "" ] ; then
    export LDAPPASSWD=${PASSWD}
else
    export LDAPPASSWD="hinemos"
fi
LDAPCMD="${LDAPBIN} -h ${HOST} -p ${LDAPPORT} -LLL -D "cn=Manager,dc=hinemos,dc=com" -x -w ${LDAPPASSWD}"
RESULT=`${LDAPCMD} -b "dc=hinemos,dc=com"`
EXIT_CODE=$?
if [ ${EXIT_CODE} -ne 0 ] ; then
    echo "Failed to access OpenLDAP" 1>&2
    echo "exit code ${EXIT_CODE}" 1>&2
    exit ${EXIT_CODE}
fi

## qrtz_simple_trigger summary
echo "### Simple trigger summary ###"
${PSQLCMD} -c "
    SELECT
        a.trigger_state,
        a.trigger_group,
        b.repeat_interval,
        count(*)
    FROM
        qrtz_triggers as a,
        qrtz_simple_triggers as b
    WHERE
        a.trigger_name = b.trigger_name
    GROUP BY
        a.trigger_state,
        a.trigger_group,
        b.repeat_interval
    ORDER BY
        a.trigger_state,
        a.trigger_group,
        b.repeat_interval
"

## qrtz_cron_trigger summary
echo "### Cron trigger summary ###"
${PSQLCMD} -c "
    SELECT
        a.trigger_state,
        a.trigger_group,
        b.cron_expression,
        count(*)
    FROM
        qrtz_triggers as a,
        qrtz_cron_triggers as b
    WHERE
        a.trigger_name = b.trigger_name
    GROUP BY
        a.trigger_state,
        a.trigger_group,
        b.cron_expression -- fire_duration_minutes
    ORDER BY
        a.trigger_state,
        a.trigger_group
"

### polling target node count
#echo "### Polling target node ###"
### process monitor
#FACILITY_LIST=`
#${PSQLCMD_NA} -c "
#    SELECT
#        distinct(facility_id)
#    FROM
#        cc_monitor_info as a,
#        qrtz_triggers as b
#    WHERE
#        a.monitor_id = b.trigger_name AND -- job_name ?
#        b.trigger_state <> 'PAUSED' AND
#        b.trigger_group = '${VALUE_TRIGGER_NAME_PROCESS}'
#"`
#touch ${TMPFILE}
#for f in ${FACILITY_LIST};
#do
#  ${LDAPCMD} -b "ou=facilitytree,dc=hinemos,dc=com" "(ccTreeType=1)" ccFacilityId | grep "ccFacilityId: " | sort | uniq >> ${TMPFILE}
#done
#PROCESS_TARGET_NODE=`sort ${TMPFILE} | uniq | wc -l`
#rm -f ${TMPFILE}
### "seinou kannri" (collector_profile)
#FACILITY_LIST=`
#${PSQLCMD_NA} -c "
#    SELECT
#        distinct(target_facilityid)
#    FROM
#        ${TABLE_COLLECTOR_PROFILE}
#"`
#touch ${TMPFILE}
#for f in ${FACILITY_LIST};
#do
#  ${LDAPCMD} -b "ou=facilitytree,dc=hinemos,dc=com" "(ccTreeType=1)" ccFacilityId | grep "ccFacilityId: " | sort | uniq >> ${TMPFILE}
#done
#PERFORMANCE_TARGET_NODE=`sort ${TMPFILE} | uniq | wc -l`
#rm -f ${TMPFILE}
#echo "Process monitor : ${PROCESS_TARGET_NODE}"
#echo "Performance collect : ${PERFORMANCE_TARGET_NODE}"
#echo ""

## "seinou kannri" summary (collector_profile）
echo "### collector_profile summary ###"
${PSQLCMD} -c "
    SELECT
        CASE collector_type
            WHEN 1 THEN 'REALTIME'
            WHEN 2 THEN
                CASE
                    WHEN stop_date is null THEN 'RECORD_NO_TIMELIMIT'
                    WHEN stop_date - now() > interval '0' THEN 'RECORD_TIMELIMIT'
                    ELSE 'RECORD_FINISHED'
                END
            WHEN 3 THEN 'MONITOR'
            ELSE 'UNKNOWN'
        END AS type,
        ${COLUMN_COLLECTOR_PROFILE_INTERVAL},
        count(*)
    FROM
        ${TABLE_COLLECTOR_PROFILE}
    GROUP BY
        type,
        ${COLUMN_COLLECTOR_PROFILE_INTERVAL}
"


## Syslog-ng/SNMPTrap filter count
echo "### Syslog-ng/SNMP-TRAP filter summary ###"
${PSQLCMD} -c "
    SELECT
        'syslog-ng' as type,
        valid_flg,
        count(*)
    FROM
        cc_syslog_monitor_rule
    GROUP BY
        valid_flg
    UNION
    SELECT
        'snmp-trap' as type,
        valid_flg,
        count(*)
    FROM
        cc_snmp_trap_oid_info
    GROUP BY
        valid_flg
"

## JOB-net
echo "### Job-net summary ###"
${PSQLCMD} -c "
    SELECT
        CASE job_type
            WHEN 0 THEN 'JU'
            WHEN 1 THEN 'JN'
            WHEN 2 THEN 'JB'
            WHEN 3 THEN 'FT'
            ELSE        '??'
        END AS type,
        count(*)
    FROM
        cc_job_mst
    GROUP BY
        job_type
    ORDER BY
        job_type
"

## log table size
echo "### log table summary ###"
${PSQLCMD} -c "
    SELECT
        relname,
        reltuples,
        pg_relation_size(relname)
    FROM
        pg_class
    WHERE
        relname IN (
            '${TABLE_CALCULATED_DATA}',
            'cc_event_log',
            'cc_crun_session',
            'cc_crun_session_detail',
            'cc_job_session',
            'cc_job_session_job',
            'cc_job_session_node'
        )
"    

## large table
echo "### more than 100 record table ###"
${PSQLCMD} -c "
    SELECT
        relname,
        reltuples,
        pg_relation_size(relname)
    FROM
        pg_class
    WHERE
        relkind = 'r' AND
        relnamespace = (
            SELECT
                oid
            FROM
                pg_namespace
            WHERE
                nspname = 'public'
            limit 1
        ) AND
        reltuples > 100
    ORDER BY
        reltuples DESC
"


## LDAP info
echo "### ldap repository info ###"

SCOPE=`${LDAPCMD} -b "ou=facilitytree,dc=hinemos,dc=com" "(ccTreeType=0)" ccFacilityId | grep "ccFacilityId:" | wc -l`
REALNODE=`${LDAPCMD} -b "ou=facilitytree,dc=hinemos,dc=com" "(ccTreeType=1)" ccFacilityId | grep "ccFacilityId:" | sort | uniq | wc -l`
VIRTNODE=`${LDAPCMD} -b "ou=facilitytree,dc=hinemos,dc=com" "(ccTreeType=1)" ccFacilityId | grep "ccFacilityId:" | wc -l`
DISK=`${LDAPCMD} -b "ou=facility,dc=hinemos,dc=com" "(ccDeviceType=disk)" cn | grep "cn: " | wc -l`
NIC=`${LDAPCMD} -b "ou=facility,dc=hinemos,dc=com" "(ccDeviceType=nic)" cn | grep "cn: " | wc -l`
FS=`${LDAPCMD} -b "ou=facility,dc=hinemos,dc=com" "(objectClass=ccFileSystemInfo)" cn | grep "cn: " | wc -l`
echo "Scope      : ${SCOPE}"
echo "Node       : ${VIRTNODE} (RealNode : ${REALNODE})"
echo "DISK       : ${DISK}"
echo "NIC        : ${NIC}"
echo "FileSystem : ${FS}"
echo ""

}
function os {
## cat /etc/redhat-release
echo "### cat /etc/redhat-release ###"
cat /etc/redhat-release
echo -e "\n"

## chkconfig --list | grep hinemos
echo "###  chkconfig --list | grep hinemos ###"
chkconfig --list | grep hinemos
echo -e "\n"

## rpm -qa
echo "### rpm -qa ###"
rpm -qa
echo -e "\n"

## cpuinfo
echo "### /proc/cpuinfo ###"
cat /proc/cpuinfo
echo -e ""

## meminfo
echo "### /proc/meminfo ###"
cat /proc/meminfo
echo -e "\n"

## sar -P ALL
echo "### sar -P ALL ###"
sar -P ALL
echo -e "\n"

## sar -r
echo "### sar -r ###"
sar -r
echo -e "\n"

## sar -n DEV
echo "### sar -n DEV ###"
sar -n DEV
echo -e "\n"

## sar -n EDEV
echo "### sar -n EDEV ###"
sar -n EDEV
echo -e "\n"

## vmstat -n
echo "### vmstat -n ###"
vmstat -n
echo -e "\n"

## iostat -d -x
echo "### iostat -d -x ###"
iostat -d -x
echo -e ""

## ps -H auxwww
echo "### ps -H auxwww ###"
ps -H auxwww
echo -e "\n"

## netstat -s
echo "### netstat -s ###"
netstat -s
echo -e "\n"

## netstat -anpo
echo "### netstat -anpo ###"
netstat -anpo
echo -e "\n"

## df
echo "### df ###"
df
echo -e "\n"

## df -i
echo "### df -i ###"
df -i
echo -e "\n"

## uptime
echo "### uptime ###"
uptime
echo -e "\n"

## /proc/slabinfo
echo "### /proc/slabinfo ###"
cat /proc/slabinfo
echo -e "\n"

## /proc/vmstat
echo "### /proc/vmstat ###"
cat /proc/vmstat
echo -e "\n"
}

function detail {
## lsof
echo "### lsof ###"
lsof
echo -e "\n"

## twiddle.sh
echo "### twiddle.sh ###"
cd /tmp
${JBOSS_HOME}/bin/twiddle.sh -s jnp://${IP_ADDRESS}:1099 invoke "user:service=SnmpPollerService,name=SnmpPollerManager" printPollerInfo
${JBOSS_HOME}/bin/twiddle.sh -s jnp://${IP_ADDRESS}:1099 invoke "user:service=SharedTableService,name=SharedTable" printTableInfo
echo -e "\n"

## md5sum
echo "### md5sum ###"
cd ${HINEMOS_HOME}
find `ls --ignore='var'` -type f | xargs md5sum
cd -
echo -e "\n"
}


if [ $# -eq 0 ]; then
        usage
        exit 1
fi

for OPTION in "$@"
do
        case $OPTION in
                -v)
			init
                        hinemos
                        ;;
                -vv)
			init
			hinemos
                        os
                        ;;
                -vvv)
			init
                        hinemos
                        os
			detail
                        ;;
                *)
                        usage
                        exit 1
        esac
done

echo ""
echo "#################################################"
echo "###     Script end at `date '+%Y-%m-%d %T'`     ###"
echo "#################################################"

exit 0
