/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.engine.MessagePushOperation;
import org.jacorb.notification.engine.PushTaskExecutorFactory;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.servant.AbstractProxyPushSupplier;
import org.jacorb.notification.servant.IAdmin;
import org.jacorb.notification.servant.StructuredProxyPushSupplierImplMBean;
import org.omg.CORBA.ORB;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosNotifyChannelAdmin.ConsumerAdmin;
import org.omg.CosNotifyChannelAdmin.ProxyType;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPushSupplierOperations;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPushSupplierPOATie;
import org.omg.CosNotifyComm.StructuredPushConsumer;
import org.omg.CosNotifyComm.StructuredPushConsumerOperations;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class StructuredProxyPushSupplierImpl
extends AbstractProxyPushSupplier
implements StructuredProxyPushSupplierOperations,
StructuredProxyPushSupplierImplMBean {
    private StructuredPushConsumerOperations pushConsumer_;
    private long timeSpent_;

    public StructuredProxyPushSupplierImpl(IAdmin iAdmin, ORB oRB, POA pOA, Configuration configuration, TaskProcessor taskProcessor, PushTaskExecutorFactory pushTaskExecutorFactory, OfferManager offerManager, SubscriptionManager subscriptionManager, ConsumerAdmin consumerAdmin) throws ConfigurationException {
        super(iAdmin, oRB, pOA, configuration, taskProcessor, pushTaskExecutorFactory, offerManager, subscriptionManager, consumerAdmin);
    }

    public ProxyType MyType() {
        return ProxyType.PUSH_STRUCTURED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pushEvent() {
        Message message = this.getMessageNoBlock();
        if (message != null) {
            try {
                boolean bl = this.deliverMessageWithRetry(message);
                return bl;
            }
            finally {
                message.dispose();
            }
        }
        return false;
    }

    private boolean deliverMessageWithRetry(Message message) {
        try {
            this.deliverMessageInternal(message);
            return true;
        }
        catch (Exception exception) {
            PushStructuredOperation pushStructuredOperation = new PushStructuredOperation(message);
            this.handleFailedPushOperation(pushStructuredOperation, exception);
            return false;
        }
    }

    private void deliverMessageInternal(Message message) throws Disconnected {
        long l = System.currentTimeMillis();
        this.pushConsumer_.push_structured_event(message.toStructuredEvent());
        long l2 = System.currentTimeMillis() - l;
        this.timeSpent_ += l2;
        this.resetErrorCounter();
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("Push took " + l2 + " ms");
        }
    }

    public void connect_structured_push_consumer(StructuredPushConsumer structuredPushConsumer) throws AlreadyConnected {
        this.checkIsNotConnected();
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("connect structured_push_consumer");
        }
        this.pushConsumer_ = structuredPushConsumer;
        this.connectClient(structuredPushConsumer);
    }

    public void disconnect_structured_push_supplier() {
        this.destroy();
    }

    protected void connectionResumed() {
        this.scheduleFlush();
    }

    protected void disconnectClient() {
        this.pushConsumer_.disconnect_structured_push_consumer();
        this.pushConsumer_ = null;
    }

    public Servant newServant() {
        return new StructuredProxyPushSupplierPOATie(this);
    }

    protected long getCost() {
        return this.timeSpent_;
    }

    private class PushStructuredOperation
    extends MessagePushOperation {
        public PushStructuredOperation(Message message) {
            super(message);
        }

        public void invokePush() throws Disconnected {
            StructuredProxyPushSupplierImpl.this.deliverMessageInternal(this.message_);
        }
    }
}

