/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir.gui.typesystem.remote;

import org.jacorb.ir.gui.typesystem.TypeSystemNode;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.Contained;
import org.omg.CORBA.ContainedHelper;
import org.omg.CORBA.IDLType;
import org.omg.CORBA.IDLTypeHelper;
import org.omg.CORBA.IRObject;
import org.omg.CORBA.TypeCode;

public abstract class IRNode
extends TypeSystemNode {
    protected IRObject irObject;
    private TypeCode typeCode;
    private String versionString = "";
    protected String repositoryID = "";

    protected IRNode() {
    }

    protected IRNode(IRObject iRObject) {
        this.setIRObject(iRObject);
    }

    public String[] allowedToAdd() {
        return null;
    }

    public String description() {
        String string = super.description();
        string = string + "\nVersion:\t" + this.versionString + "\nRepository ID:\t" + this.repositoryID;
        return string;
    }

    public String getAbsoluteName() {
        if (this.absoluteName != null && !this.absoluteName.equals("")) {
            return this.absoluteName;
        }
        return this.name;
    }

    public TypeCode getTypeCode() {
        return this.typeCode;
    }

    protected void setIRObject(IRObject iRObject) {
        this.irObject = iRObject;
        try {
            Contained contained = ContainedHelper.narrow(iRObject);
            this.setName(contained.name());
            this.setAbsoluteName(contained.absolute_name());
            this.versionString = contained.version();
            this.repositoryID = contained.id();
        }
        catch (BAD_PARAM bAD_PARAM) {
            // empty catch block
        }
        try {
            IDLType iDLType = IDLTypeHelper.narrow(iRObject);
            this.typeCode = iDLType.type();
        }
        catch (BAD_PARAM bAD_PARAM) {
            // empty catch block
        }
    }
}

