/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.util.code;

import com.clustercontrol.performance.bean.CollectMethodConstant;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorCategoryMstData;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorCategoryMstLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorCategoryMstUtil;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorDeviceInfoData;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorDeviceInfoLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorDeviceInfoUtil;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCalcMethodMstLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCalcMethodMstUtil;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCodeMstData;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCodeMstLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCodeMstUtil;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorScopeSnapLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorScopeSnapUtil;
import com.clustercontrol.performance.util.Repository;
import com.clustercontrol.performance.util.code.CollectorItemTreeItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectorItemCodeTable {
    private static Log m_log = LogFactory.getLog(CollectorItemCodeTable.class);
    private static final HashMap<String, CollectorItemTreeItem> m_codeTable = new HashMap();

    public static CollectorItemTreeItem[] createTree(Set<CollectorItemCodeMstData> codeSet, Set<CollectorItemCodeMstData> disableCodeSet, String collectMethod, Set<CollectorDeviceInfoData> deviceSet) {
        ArrayList<CollectorItemTreeItem> itemTree = new ArrayList<CollectorItemTreeItem>();
        HashMap<String, CollectorItemTreeItem> categoryMap = new HashMap<String, CollectorItemTreeItem>();
        Collection cate = null;
        try {
            cate = CollectorCategoryMstUtil.getLocalHome().findAll();
        }
        catch (FinderException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NamingException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        for (CollectorCategoryMstLocal bean : cate) {
            CollectorCategoryMstData category = new CollectorCategoryMstData(bean.getCategoryCode(), bean.getCategoryName());
            CollectorItemTreeItem categoryItem = new CollectorItemTreeItem(null, category, null, null);
            categoryMap.put(bean.getCategoryCode(), categoryItem);
            itemTree.add(categoryItem);
        }
        CollectorItemTreeItem[] list = itemTree.toArray(new CollectorItemTreeItem[0]);
        Arrays.sort(list, new Comparator<CollectorItemTreeItem>(){

            @Override
            public int compare(CollectorItemTreeItem o1, CollectorItemTreeItem o2) {
                return o1.getCategory().getCategoryCode().compareTo(o2.getCategory().getCategoryCode());
            }
        });
        HashMap<ItemCodeAndDeviceName, CollectorItemTreeItem> createdCodeItemMap = new HashMap<ItemCodeAndDeviceName, CollectorItemTreeItem>();
        Iterator<CollectorItemCodeMstData> itr = codeSet.iterator();
        HashSet<String> createdCodeSet = new HashSet<String>();
        while (itr.hasNext()) {
            CollectorItemCodeMstData itemCodeData = itr.next();
            CollectorItemCodeTable.createItemTreeItem(createdCodeSet, itemCodeData, codeSet, collectMethod, deviceSet, categoryMap, createdCodeItemMap);
        }
        return list;
    }

    private static void createItemTreeItem(HashSet<String> createdCodeSet, CollectorItemCodeMstData itemCodeData, Set<CollectorItemCodeMstData> codeSet, String collectMethod, Set<CollectorDeviceInfoData> deviceSet, HashMap<String, CollectorItemTreeItem> categoryMap, HashMap<ItemCodeAndDeviceName, CollectorItemTreeItem> createdCodeMap) {
        if (createdCodeSet.contains(itemCodeData.getItemCode())) {
            return;
        }
        String parentItemCode = itemCodeData.getParentItemCode();
        if (parentItemCode == null) {
            CollectorItemTreeItem parentItem = categoryMap.get(itemCodeData.getCategoryCode());
            if (parentItem == null) {
                return;
            }
            if (itemCodeData.getDeviceSupport() == 0) {
                CollectorItemTreeItem item = new CollectorItemTreeItem(parentItem, itemCodeData, collectMethod, null);
                createdCodeMap.put(new ItemCodeAndDeviceName(itemCodeData.getItemCode(), null), item);
            } else {
                for (CollectorDeviceInfoData dData : deviceSet) {
                    if (!itemCodeData.getDeviceType().equals(dData.getDeviceType())) continue;
                    CollectorItemTreeItem item = new CollectorItemTreeItem(parentItem, itemCodeData, collectMethod, dData);
                    createdCodeMap.put(new ItemCodeAndDeviceName(itemCodeData.getItemCode(), dData.getDeviceName()), item);
                }
            }
        } else if (itemCodeData.getDeviceSupport() == 0) {
            CollectorItemTreeItem parentItem = createdCodeMap.get(new ItemCodeAndDeviceName(itemCodeData.getParentItemCode(), null));
            if (parentItem == null) {
                for (CollectorItemCodeMstData data : codeSet) {
                    if (!parentItemCode.equals(data.getItemCode())) continue;
                    CollectorItemCodeTable.createItemTreeItem(createdCodeSet, data, codeSet, collectMethod, deviceSet, categoryMap, createdCodeMap);
                }
                parentItem = createdCodeMap.get(new ItemCodeAndDeviceName(itemCodeData.getParentItemCode(), null));
                if (parentItem == null) {
                    parentItem = categoryMap.get(itemCodeData.getCategoryCode());
                }
            }
            CollectorItemTreeItem item = new CollectorItemTreeItem(parentItem, itemCodeData, collectMethod, null);
            createdCodeMap.put(new ItemCodeAndDeviceName(itemCodeData.getItemCode(), null), item);
        } else {
            for (CollectorDeviceInfoData dData : deviceSet) {
                if (!itemCodeData.getDeviceType().equals(dData.getDeviceType())) continue;
                CollectorItemTreeItem parentItem = createdCodeMap.get(new ItemCodeAndDeviceName(itemCodeData.getParentItemCode(), dData.getDeviceName()));
                if (parentItem == null) {
                    for (CollectorItemCodeMstData data : codeSet) {
                        if (!parentItemCode.equals(data.getItemCode())) continue;
                        CollectorItemCodeTable.createItemTreeItem(createdCodeSet, data, codeSet, collectMethod, deviceSet, categoryMap, createdCodeMap);
                    }
                    parentItem = createdCodeMap.get(new ItemCodeAndDeviceName(itemCodeData.getParentItemCode(), dData.getDeviceName()));
                    if (parentItem == null) {
                        parentItem = categoryMap.get(itemCodeData.getCategoryCode());
                    }
                }
                CollectorItemTreeItem item = new CollectorItemTreeItem(parentItem, itemCodeData, collectMethod, dData);
                createdCodeMap.put(new ItemCodeAndDeviceName(itemCodeData.getItemCode(), dData.getDeviceName()), item);
            }
        }
        createdCodeSet.add(itemCodeData.getItemCode());
    }

    public static CollectorItemTreeItem[] getCollectorTree(String facilityId, String collectorId) {
        return CollectorItemCodeTable.getCollectorTree(facilityId, collectorId, CollectMethodConstant.SNMP);
    }

    private static CollectorItemTreeItem[] getCollectorTree(String facilityId, String collectorId, String collectMethod) {
        Collection calsMethods;
        HashSet<CollectorDeviceInfoData> deviceSet = new HashSet<CollectorDeviceInfoData>();
        HashSet<String> platformSet = new HashSet<String>();
        HashSet deviceSetAdd = new HashSet();
        HashSet deviceSetRetain = null;
        if (collectorId == null) {
            if (facilityId != null) {
                Repository repository = new Repository();
                if (repository.isNode(facilityId)) {
                    String platformId = Repository.getPlatformId(facilityId);
                    platformSet.add(platformId);
                    List<CollectorDeviceInfoData> deviceList = repository.getDeviceList(facilityId);
                    Iterator<CollectorDeviceInfoData> itr = deviceList.iterator();
                    HashSet<DeviceTypeAndDeviceName> tmp = new HashSet<DeviceTypeAndDeviceName>();
                    while (itr.hasNext()) {
                        CollectorDeviceInfoData data = itr.next();
                        tmp.add(new DeviceTypeAndDeviceName(data.getDeviceType(), data.getDeviceName()));
                    }
                    deviceSetAdd.addAll(tmp);
                    deviceSetRetain = new HashSet(tmp);
                } else {
                    ArrayList<ArrayList<String>> nodeList = repository.getNodeList(facilityId);
                    Iterator nodeItr = nodeList.iterator();
                    while (nodeItr.hasNext()) {
                        String nodeFacilityId = ((String)((ArrayList)nodeItr.next()).get(0)).toString();
                        String platformId = Repository.getPlatformId(nodeFacilityId);
                        platformSet.add(platformId);
                        List<CollectorDeviceInfoData> deviceList = repository.getDeviceList(nodeFacilityId);
                        Iterator<Object> itr = deviceList.iterator();
                        HashSet<DeviceTypeAndDeviceName> tmp = new HashSet<DeviceTypeAndDeviceName>();
                        while (itr.hasNext()) {
                            CollectorDeviceInfoData data = (CollectorDeviceInfoData)itr.next();
                            tmp.add(new DeviceTypeAndDeviceName(data.getDeviceType(), data.getDeviceName()));
                        }
                        deviceSetAdd.addAll(tmp);
                        if (deviceSetRetain == null) {
                            deviceSetRetain = new HashSet(tmp);
                            continue;
                        }
                        deviceSetRetain.retainAll(tmp);
                    }
                }
            }
        } else {
            Collection col;
            Collection facilitys;
            try {
                facilitys = CollectorScopeSnapUtil.getLocalHome().findByCollectorId(collectorId);
            }
            catch (FinderException e) {
                m_log.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
            catch (NamingException e) {
                m_log.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
            try {
                col = CollectorDeviceInfoUtil.getLocalHome().findByCollectorId(collectorId);
            }
            catch (FinderException e) {
                m_log.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
            catch (NamingException e) {
                m_log.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
            for (CollectorScopeSnapLocal bean : facilitys) {
                if (!"node".equals(bean.getFacilityType())) continue;
                platformSet.add(bean.getPlatformId());
                String targetFacilityId = bean.getFacilityId();
                Iterator nodeItr = col.iterator();
                HashSet<DeviceTypeAndDeviceName> tmp = new HashSet<DeviceTypeAndDeviceName>();
                while (nodeItr.hasNext()) {
                    CollectorDeviceInfoLocal deviceInfo = (CollectorDeviceInfoLocal)nodeItr.next();
                    if (!targetFacilityId.equals(deviceInfo.getFacilityId())) continue;
                    tmp.add(new DeviceTypeAndDeviceName(deviceInfo.getDeviceType(), deviceInfo.getDeviceName()));
                }
                deviceSetAdd.addAll(tmp);
                if (deviceSetRetain == null) {
                    deviceSetRetain = new HashSet(tmp);
                    continue;
                }
                deviceSetRetain.retainAll(tmp);
            }
        }
        HashSet<CollectorItemCodeMstData> codeSet = null;
        HashSet<CollectorItemCodeMstData> disableCodeSet = new HashSet<CollectorItemCodeMstData>();
        try {
            calsMethods = CollectorItemCalcMethodMstUtil.getLocalHome().findAll();
        }
        catch (FinderException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        catch (NamingException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        for (String platformId : platformSet) {
            HashSet<CollectorItemCodeMstData> tmpByPlatform = new HashSet<CollectorItemCodeMstData>();
            for (CollectorItemCalcMethodMstLocal bean : calsMethods) {
                CollectorItemCodeMstLocal codeBean;
                if (!collectMethod.equals(bean.getCollectMethod())) continue;
                try {
                    codeBean = CollectorItemCodeMstUtil.getLocalHome().findByPrimaryKey(bean.getItemCode());
                }
                catch (FinderException e) {
                    m_log.error((Object)e.getMessage(), (Throwable)e);
                    return null;
                }
                catch (NamingException e) {
                    m_log.error((Object)e.getMessage(), (Throwable)e);
                    return null;
                }
                CollectorItemCodeMstData codeData = new CollectorItemCodeMstData(codeBean.getItemCode(), codeBean.getCategoryCode(), codeBean.getParentItemCode(), codeBean.getItemName(), codeBean.getMeasure(), codeBean.getDeviceSupport(), codeBean.getDeviceType(), codeBean.getGraphRange());
                if (!platformId.equals(bean.getPlatformId())) continue;
                tmpByPlatform.add(codeData);
            }
            if (codeSet == null) {
                codeSet = new HashSet(tmpByPlatform);
            } else {
                codeSet.retainAll(tmpByPlatform);
            }
            disableCodeSet.addAll(tmpByPlatform);
        }
        if (deviceSetRetain == null) {
            deviceSetRetain = new HashSet();
        }
        for (DeviceTypeAndDeviceName info : deviceSetRetain) {
            CollectorDeviceInfoData deviceData = new CollectorDeviceInfoData(null, null, info.getDeviceName(), null, null, info.getDeviceType());
            deviceSet.add(deviceData);
        }
        if (codeSet == null) {
            codeSet = new HashSet<CollectorItemCodeMstData>();
        }
        disableCodeSet.removeAll(codeSet);
        return CollectorItemCodeTable.createTree(codeSet, disableCodeSet, collectMethod, deviceSet);
    }

    public static String getFullItemName(String itemCode, String deviceName) {
        try {
            CollectorItemCodeMstLocal bean = CollectorItemCodeMstUtil.getLocalHome().findByPrimaryKey(itemCode);
            String itemName = bean.getItemName();
            if (bean.getDeviceSupport() == 1) {
                itemName = itemName + "[" + deviceName + "]";
            }
            return itemName;
        }
        catch (FinderException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NamingException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        return itemCode + " is not found.";
    }

    public static HashMap<String, CollectorItemTreeItem> getItemCodeMap() {
        return m_codeTable;
    }

    static {
        HashMap<String, CollectorItemTreeItem> categoryTable = new HashMap<String, CollectorItemTreeItem>();
        Collection cate = null;
        try {
            cate = CollectorCategoryMstUtil.getLocalHome().findAll();
        }
        catch (FinderException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NamingException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        for (CollectorCategoryMstLocal bean : cate) {
            CollectorCategoryMstData category = new CollectorCategoryMstData(bean.getCategoryCode(), bean.getCategoryName());
            CollectorItemTreeItem categoryItem = new CollectorItemTreeItem(null, category, null, null);
            categoryTable.put(bean.getCategoryCode(), categoryItem);
        }
        try {
            Collection ctItemCodeMst = CollectorItemCodeMstUtil.getLocalHome().findAll();
            for (CollectorItemCodeMstLocal codeBean : ctItemCodeMst) {
                String itemCode = codeBean.getItemCode();
                if (itemCode == null || itemCode == null || codeBean.getCategoryCode() == null || codeBean.getDeviceSupport() == null || codeBean.getGraphRange() == null) continue;
                CollectorItemCodeMstData codeData = new CollectorItemCodeMstData(codeBean.getItemCode(), codeBean.getCategoryCode(), codeBean.getParentItemCode(), codeBean.getItemName(), codeBean.getMeasure(), codeBean.getDeviceSupport(), codeBean.getDeviceType(), codeBean.getGraphRange());
                CollectorItemTreeItem categoryTreeItem = (CollectorItemTreeItem)categoryTable.get(codeBean.getCategoryCode());
                CollectorItemTreeItem parentItem = m_codeTable.get(codeBean.getParentItemCode());
                if (parentItem == null) {
                    parentItem = categoryTreeItem;
                }
                CollectorItemTreeItem ctItem = new CollectorItemTreeItem(parentItem, codeData, CollectMethodConstant.SNMP, null);
                m_codeTable.put(itemCode, ctItem);
            }
        }
        catch (Exception e) {
            m_codeTable.clear();
            e.printStackTrace();
        }
    }

    public static class DeviceTypeAndDeviceName {
        private String deviceType;
        private String deviceName;

        public DeviceTypeAndDeviceName(String deviceType, String deviceName) {
            this.deviceType = deviceType;
            this.deviceName = deviceName != null ? deviceName : "";
        }

        public boolean equals(Object other) {
            if (other instanceof DeviceTypeAndDeviceName) {
                DeviceTypeAndDeviceName info = (DeviceTypeAndDeviceName)other;
                if (this.deviceType == null && this.deviceName == null) {
                    if (info.deviceType == null && info.deviceName == null) {
                        return true;
                    }
                } else if (this.deviceType == null && this.deviceName != null) {
                    if (info.deviceType == null && this.deviceName.equals(info.deviceName)) {
                        return true;
                    }
                } else if (this.deviceType != null && this.deviceName == null) {
                    if (this.deviceType.equals(info.deviceType) && info.deviceName == null) {
                        return true;
                    }
                } else if (this.deviceType.equals(info.deviceType)) {
                    return this.deviceName.equals(info.deviceName);
                }
                return false;
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + (this.deviceType != null ? this.deviceType.hashCode() : 0);
            result = 37 * result + (this.deviceName != null ? this.deviceName.hashCode() : 0);
            return result;
        }

        public String getDeviceType() {
            return this.deviceType;
        }

        public String getDeviceName() {
            return this.deviceName;
        }
    }

    private static class ItemCodeAndDeviceName {
        private String itemCode;
        private String deviceName;

        public ItemCodeAndDeviceName(String itemCode, String deviceName) {
            this.itemCode = itemCode;
            this.deviceName = deviceName;
        }

        public boolean equals(Object other) {
            if (other instanceof ItemCodeAndDeviceName) {
                ItemCodeAndDeviceName info = (ItemCodeAndDeviceName)other;
                if (this.itemCode == null && this.deviceName == null) {
                    if (info.itemCode == null && info.deviceName == null) {
                        return true;
                    }
                } else if (this.itemCode == null && this.deviceName != null) {
                    if (info.itemCode == null && this.deviceName.equals(info.deviceName)) {
                        return true;
                    }
                } else if (this.itemCode != null && this.deviceName == null) {
                    if (this.itemCode.equals(info.itemCode) && info.deviceName == null) {
                        return true;
                    }
                } else if (this.itemCode.equals(info.itemCode)) {
                    return this.deviceName.equals(info.deviceName);
                }
                return false;
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + (this.itemCode != null ? this.itemCode.hashCode() : 0);
            result = 37 * result + (this.deviceName != null ? this.deviceName.hashCode() : 0);
            return result;
        }
    }
}

