/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.chat.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.jboss.remoting.samples.chat.client.ChatMember;
import org.jboss.remoting.samples.chat.client.Closeable;
import org.jboss.remoting.samples.chat.client.CloseableFrame;
import org.jboss.remoting.samples.chat.client.CreateConnectionStrategy;
import org.jboss.remoting.samples.chat.client.CreateFrame_CancelButton_actionAdapter;
import org.jboss.remoting.samples.chat.client.CreateFrame_OKButton_actionAdapter;
import org.jboss.remoting.samples.chat.client.DummyCreateConnectionStrategy;
import org.jboss.remoting.samples.chat.exceptions.CreateConnectionException;

public class CreateFrame
extends CloseableFrame {
    JLabel jDescriptionLabel = new JLabel();
    JLabel IDLabel = new JLabel();
    JTextField descriptionField = new JTextField();
    JTextField idField = new JTextField();
    JButton OKButton = new JButton();
    JButton CancelButton = new JButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    private CreateConnectionStrategy ccs;

    public CreateFrame(CreateConnectionStrategy ccs, Closeable parent) {
        super(parent);
        this.ccs = ccs;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.jDescriptionLabel.setFont(new Font("SansSerif", 1, 12));
        this.jDescriptionLabel.setText("Description:");
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.IDLabel.setFont(new Font("SansSerif", 1, 12));
        this.IDLabel.setText("Your ID:");
        this.descriptionField.setText("");
        this.idField.setText("");
        this.OKButton.setFont(new Font("SansSerif", 1, 14));
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new CreateFrame_OKButton_actionAdapter(this));
        this.CancelButton.setFont(new Font("SansSerif", 1, 14));
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new CreateFrame_CancelButton_actionAdapter(this));
        this.setLocale(Locale.getDefault());
        this.setResizable(false);
        this.setTitle("Create a chat room");
        this.setSize(new Dimension(0, 300));
        this.getContentPane().add((Component)this.jDescriptionLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(25, 21, 0, 0), 11, 4));
        this.getContentPane().add((Component)this.IDLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(11, 21, 0, 0), 27, 0));
        this.getContentPane().add((Component)this.descriptionField, new GridBagConstraints(2, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(25, 0, 0, 16), 270, 1));
        this.getContentPane().add((Component)this.OKButton, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 10, 0, new Insets(81, 0, 115, 0), 30, -5));
        this.getContentPane().add((Component)this.CancelButton, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(81, 27, 115, 103), 11, -2));
        this.getContentPane().add((Component)this.idField, new GridBagConstraints(2, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(9, 0, 0, 22), 272, 2));
        this.center();
        this.pack();
    }

    void OKButton_actionPerformed(ActionEvent e) {
        try {
            this.notifyOnClose(this);
            ChatMember chatMember = new ChatMember();
            chatMember.set_name(this.idField.getText());
            this.ccs.createChat(this.descriptionField.getText(), chatMember);
        }
        catch (CreateConnectionException cce) {
            System.out.println("OK button catches exception:");
            System.out.println(cce);
        }
    }

    void CancelButton_actionPerformed(ActionEvent e) {
        this.notifyOnClose(this);
    }

    public static void main(String[] args) {
        try {
            CreateFrame createFrame = new CreateFrame(new DummyCreateConnectionStrategy(), null);
            createFrame.setDefaultCloseOperation(3);
            createFrame.show();
        }
        catch (CreateConnectionException ce) {
            System.out.println("unable to create create frame");
        }
    }
}

