/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import java.net.URLStreamHandlerFactory;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.util.loading.DelegatingClassLoader;

public class LoaderRepositoryClassLoader
extends DelegatingClassLoader {
    protected LoaderRepository repository;

    public LoaderRepositoryClassLoader(ClassLoader parent, LoaderRepository repository) {
        super(parent);
        if (repository == null) {
            throw new IllegalArgumentException("No repository");
        }
        this.repository = repository;
    }

    public LoaderRepositoryClassLoader(ClassLoader parent, LoaderRepository repository, URLStreamHandlerFactory factory) {
        super(parent);
        if (repository == null) {
            throw new IllegalArgumentException("No repository");
        }
        this.repository = repository;
    }

    protected Class loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class clazz = this.repository.getCachedClass(className);
        if (clazz != null) {
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        return super.loadClass(className, resolve);
    }
}

