/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.navtree;

import java.util.Arrays;
import java.util.Vector;
import org.jboss.console.manager.interfaces.ManageableResource;
import org.jboss.console.manager.interfaces.TreeAction;
import org.jboss.console.manager.interfaces.TreeInfo;
import org.jboss.console.manager.interfaces.TreeNode;
import org.jboss.console.manager.interfaces.TreeNodeMenuEntry;
import org.jboss.console.navtree.NodeWrapper;
import org.jboss.console.navtree.StdNodeWrapper;

public class RootWrapper
implements NodeWrapper {
    TreeInfo tree = null;
    NodeWrapper[] sons = null;
    TreeNode[] realSons = null;

    public RootWrapper(TreeInfo tree) {
        int i;
        this.tree = tree;
        Vector<TreeNode> nodes = new Vector<TreeNode>();
        ManageableResource[] roots = tree.getRootResources();
        for (i = 0; i < roots.length; ++i) {
            ManageableResource mr = roots[i];
            TreeNode[] ns = tree.getTreesForResource(mr);
            if (ns == null || ns.length <= 0) continue;
            nodes.addAll(Arrays.asList(ns));
        }
        this.realSons = new TreeNode[nodes.size()];
        this.sons = new NodeWrapper[nodes.size()];
        for (i = 0; i < this.realSons.length; ++i) {
            this.realSons[i] = (TreeNode)nodes.elementAt(i);
        }
    }

    public Object getChild(int index) {
        if (index >= this.sons.length) {
            return null;
        }
        if (this.sons[index] == null) {
            this.sons[index] = new StdNodeWrapper(this.realSons[index], this.tree, "");
        }
        return this.sons[index];
    }

    public int getChildCount() {
        return this.realSons.length;
    }

    public int getIndexOfChild(Object child) {
        for (int i = 0; i < this.sons.length; ++i) {
            if (this.sons[i] != child) continue;
            return i;
        }
        return -1;
    }

    public boolean isLeaf() {
        return this.sons.length == 0;
    }

    public String getIconUrl() {
        return this.tree.getIconUrl();
    }

    public String toString() {
        return "JBoss Management Console";
    }

    public TreeAction getAssociatedAction() {
        return this.tree.getHomeAction();
    }

    public String getDescription() {
        return this.tree.getDescription();
    }

    public TreeNodeMenuEntry[] getMenuEntries() {
        return this.tree.getRootMenus();
    }

    public String getPath() {
        return "";
    }
}

