/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security;

import java.io.IOException;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.FormAuthenticator;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.jboss.logging.Logger;
import org.jboss.web.tomcat.security.SecurityAssociationActions;

public class ExtendedFormAuthenticator
extends FormAuthenticator {
    public static final String LOGIN_EXCEPTION = "j_exception";
    public static final String DID_POPULATE = "did_populate";
    private static Logger log = Logger.getLogger(ExtendedFormAuthenticator.class);
    private static boolean trace = log.isTraceEnabled();
    private boolean includePassword;

    public boolean isIncludePassword() {
        return this.includePassword;
    }

    public void setIncludePassword(boolean includePassword) {
        this.includePassword = includePassword;
    }

    public boolean authenticate(Request request, Response response, LoginConfig config) throws IOException {
        Boolean b;
        boolean didPopulate = false;
        boolean alreadyAuthenticated = super.authenticate(request, response, config);
        Session session = request.getSessionInternal(false);
        if (session != null && (b = (Boolean)session.getNote(DID_POPULATE)) != null) {
            didPopulate = b;
        }
        if (!alreadyAuthenticated && !didPopulate) {
            this.populateSession(request);
        }
        session.removeNote(DID_POPULATE);
        return alreadyAuthenticated;
    }

    protected void forwardToErrorPage(Request request, Response response, LoginConfig config) {
        if (trace) {
            log.trace((Object)"forwardToErrorPage");
        }
        this.populateSession(request);
        super.forwardToErrorPage(request, response, config);
        SecurityAssociationActions.clearAuthException();
    }

    protected void forwardToLoginPage(Request request, Response response, LoginConfig config) {
        if (trace) {
            log.trace((Object)"forwardToLoginPage");
        }
        this.populateSession(request);
        super.forwardToLoginPage(request, response, config);
    }

    protected void populateSession(Request request) {
        Session session = request.getSessionInternal(false);
        if (session != null) {
            HttpSession httpSession = session.getSession();
            if (trace) {
                log.trace((Object)("SessionID: " + httpSession.getId()));
            }
            String username = request.getParameter("j_username");
            if (trace) {
                log.trace((Object)("Setting j_username = " + username));
            }
            httpSession.setAttribute("j_username", (Object)username);
            if (this.includePassword) {
                String displayPassword;
                String password = request.getParameter("j_password");
                String string = displayPassword = password == null ? " = null" : " = --hidden--";
                if (trace) {
                    log.trace((Object)("Setting j_password" + displayPassword));
                }
                httpSession.setAttribute("j_password", (Object)password);
            }
            Throwable t = SecurityAssociationActions.getAuthException();
            if (trace) {
                log.trace((Object)("Setting j_exception = " + t));
            }
            httpSession.setAttribute(LOGIN_EXCEPTION, (Object)t);
            session.setNote(DID_POPULATE, (Object)Boolean.TRUE);
        } else if (trace) {
            log.trace((Object)"No Session to store login parameters in");
        }
    }
}

