/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.dao;

import com.clustercontrol.commons.util.ConnectionManager;
import com.clustercontrol.jobmanagement.dao.JobCommandMasterDAO;
import com.clustercontrol.jobmanagement.ejb.entity.JobCommandMasterBean;
import com.clustercontrol.jobmanagement.ejb.entity.JobCommandMasterPK;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobCommandMasterDAOImpl
implements JobCommandMasterDAO {
    protected static Log m_log = LogFactory.getLog(JobCommandMasterDAOImpl.class);

    public void init() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(JobCommandMasterPK pk, JobCommandMasterBean ejb) throws EJBException {
        m_log.debug((Object)("load() start : " + pk.toString()));
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_job_command_mst WHERE job_id = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.getJob_id());
                res = stmt.executeQuery();
                if (!res.next()) {
                    String msg = "JobCommandMaster data is not found.";
                    m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + msg));
                    throw new EJBException(msg);
                }
                ejb.setArgument(res.getString("argument"));
                ejb.setArgument_job_id(res.getString("argument_job_id"));
                ejb.setEffective_user(res.getString("effective_user"));
                ejb.setError_end_flg(res.getInt("error_end_flg"));
                ejb.setError_end_value(res.getInt("error_end_value"));
                ejb.setFacility_id(res.getString("facility_id"));
                ejb.setJob_id(res.getString("job_id"));
                ejb.setProcess_mode(res.getInt("process_mode"));
                ejb.setStart_command(res.getString("start_command"));
                ejb.setStop_command(res.getString("stop_command"));
                Object var9_9 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("load() end : " + pk.toString()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void store(JobCommandMasterBean ejb) throws EJBException {
        m_log.debug((Object)("store() start : " + ejb.getJob_id()));
        Connection conn = null;
        Statement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("UPDATE cc_job_command_mst SET ");
                sql.append("facility_id = ?, ");
                sql.append("process_mode = ?, ");
                sql.append("start_command = ?, ");
                sql.append("stop_command = ?, ");
                sql.append("effective_user = ?, ");
                sql.append("error_end_flg = ?, ");
                sql.append("error_end_value = ?, ");
                sql.append("argument_job_id = ?, ");
                sql.append("argument = ? ");
                sql.append("WHERE job_id = ?");
                stmt = conn.prepareStatement(sql.toString());
                stmt.setString(1, ejb.getFacility_id());
                stmt.setInt(2, ejb.getProcess_mode());
                stmt.setString(3, ejb.getStart_command());
                stmt.setString(4, ejb.getStop_command());
                stmt.setString(5, ejb.getEffective_user());
                stmt.setInt(6, ejb.getError_end_flg());
                stmt.setInt(7, ejb.getError_end_value());
                stmt.setString(8, ejb.getArgument_job_id());
                stmt.setString(9, ejb.getArgument());
                stmt.setString(10, ejb.getJob_id());
                int row = stmt.executeUpdate();
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("store() error : " + ejb.getJob_id() + " SQLException" + msg));
                    throw new EJBException(msg);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("store() error : " + ejb.getJob_id() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("store() error : " + ejb.getJob_id() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("store() error : " + ejb.getJob_id() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("store() end : " + ejb.getJob_id()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(JobCommandMasterPK pk) throws RemoveException, EJBException {
        m_log.debug((Object)("remove() start : " + pk.toString()));
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "DELETE FROM cc_job_command_mst WHERE job_id = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.getJob_id());
                int row = stmt.executeUpdate();
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("remove() error : " + pk.toString() + " SQLException" + msg));
                    throw new EJBException(msg);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("remove() end : " + pk.toString()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JobCommandMasterPK create(JobCommandMasterBean ejb) throws CreateException, EJBException {
        JobCommandMasterPK pk;
        m_log.debug((Object)("create() start : " + ejb.getJob_id()));
        Connection conn = null;
        Statement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("INSERT INTO cc_job_command_mst (");
                sql.append("job_id, ");
                sql.append("facility_id, ");
                sql.append("process_mode, ");
                sql.append("start_command, ");
                sql.append("stop_command, ");
                sql.append("effective_user, ");
                sql.append("error_end_flg, ");
                sql.append("error_end_value, ");
                sql.append("argument_job_id, ");
                sql.append("argument) ");
                sql.append("VALUES (?,?,?,?,?,?,?,?,?,?)");
                stmt = conn.prepareStatement(sql.toString());
                stmt.setString(1, ejb.getJob_id());
                stmt.setString(2, ejb.getFacility_id());
                stmt.setInt(3, ejb.getProcess_mode());
                stmt.setString(4, ejb.getStart_command());
                stmt.setString(5, ejb.getStop_command());
                stmt.setString(6, ejb.getEffective_user());
                stmt.setInt(7, ejb.getError_end_flg());
                stmt.setInt(8, ejb.getError_end_value());
                stmt.setString(9, ejb.getArgument_job_id());
                stmt.setString(10, ejb.getArgument());
                int row = stmt.executeUpdate();
                pk = new JobCommandMasterPK(ejb.getJob_id());
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("create() error : " + ejb.getJob_id() + " SQLException"));
                    throw new EJBException(msg);
                }
                Object var9_9 = null;
            }
            catch (SQLException e) {
                if (!e.getSQLState().equals("23505")) throw new CreateException(e.getMessage());
                m_log.error((Object)("create() error : " + ejb.getJob_id() + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("create() error : " + ejb.getJob_id() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("create() error : " + ejb.getJob_id() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("create() end : " + ejb.getJob_id()));
        return pk;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection findAll() throws FinderException {
        m_log.debug((Object)"findAll() start : ");
        ArrayList<JobCommandMasterPK> ret = new ArrayList<JobCommandMasterPK>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_job_command_mst";
                stmt = conn.prepareStatement(sql);
                res = stmt.executeQuery();
                while (res.next()) {
                    JobCommandMasterPK pk = new JobCommandMasterPK(res.getString("job_id"));
                    ret.add(pk);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)"findAll() error :  SQLException");
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)"findAll() end : ");
        return ret;
    }

    public JobCommandMasterPK findByPrimaryKey(JobCommandMasterPK pk) throws FinderException {
        ResultSet res;
        PreparedStatement stmt;
        Connection conn;
        block14: {
            m_log.debug((Object)("findByPrimaryKey() start : " + pk.toString()));
            conn = null;
            stmt = null;
            res = null;
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_command_mst WHERE job_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.getJob_id());
            res = stmt.executeQuery();
            if (!res.next()) break block14;
            JobCommandMasterPK jobCommandMasterPK = pk;
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            return jobCommandMasterPK;
        }
        try {
            try {
                String msg = "id " + pk.toString() + " not found.";
                throw new FinderException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection findByFacilityId(String facilityId) throws FinderException {
        m_log.debug((Object)("findByFacilityId() start : " + facilityId));
        ArrayList<JobCommandMasterPK> ret = new ArrayList<JobCommandMasterPK>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_job_command_mst WHERE facility_id = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, facilityId);
                res = stmt.executeQuery();
                while (res.next()) {
                    JobCommandMasterPK pk = new JobCommandMasterPK(res.getString("job_id"));
                    ret.add(pk);
                }
                Object var9_9 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("findByFacilityId() error : " + facilityId + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("findByFacilityId() error : " + facilityId + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("findByFacilityId() error : " + facilityId + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("findByFacilityId() end : " + facilityId));
        return ret;
    }
}

