/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.plugins;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.jboss.console.manager.interfaces.ManageableResource;
import org.jboss.console.manager.interfaces.ResourceTreeNode;
import org.jboss.console.manager.interfaces.TreeNode;
import org.jboss.console.plugins.helpers.AbstractPluginWrapper;
import org.jboss.management.j2ee.J2EEServer;
import org.jboss.management.j2ee.J2EEServerMBean;
import org.jboss.mx.util.MBeanProxyExt;

public class JSR77Lister
extends AbstractPluginWrapper {
    private static final long serialVersionUID = -5466799611043095874L;
    public static final String[] DEFAULT_SUFFIX_ORDER = new String[]{"ear", "jar", "war", "sar", "rar", "ds.xml", "service.xml", "wsr", "zip"};

    TreeNode createSubResources(String[] resources) throws Exception {
        ResourceTreeNode[] deployed = new ResourceTreeNode[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            ObjectName objectName = new ObjectName(resources[i]);
            deployed[i] = this.createResourceNode(objectName.getKeyProperty("name"), "J2EE Resource", null, null, null, null, null, resources[i].toString(), this.mbeanServer.getMBeanInfo(objectName).getClassName()).setVisibility(2);
        }
        return this.createTreeNode("J2EE Resources", "J2EE Resources", "images/spirale.gif", null, null, null, deployed);
    }

    ResourceTreeNode[] createDeployedObjects(String[] resources) throws Exception {
        ArrayList<ResourceTreeNode> deployed = new ArrayList<ResourceTreeNode>();
        for (int i = 0; i < resources.length; ++i) {
            ObjectName objectName = new ObjectName(resources[i]);
            deployed.add(this.createResourceNode(objectName.getKeyProperty("name"), "", "images/EspressoMaker.gif", null, null, null, null, resources[i].toString(), this.mbeanServer.getMBeanInfo(objectName).getClassName()).setVisibility(2));
        }
        Collections.sort(deployed, new ListerSorter());
        return deployed.toArray(new ResourceTreeNode[deployed.size()]);
    }

    ResourceTreeNode createServer(String serverName) throws Exception {
        ObjectName objectName = new ObjectName(serverName);
        J2EEServerMBean serv = (J2EEServerMBean)MBeanProxyExt.create(J2EEServerMBean.class, objectName, this.getMBeanServer());
        String[] deployedON = serv.getdeployedObjects();
        ResourceTreeNode[] subResArray = this.createDeployedObjects(deployedON);
        return this.createResourceNode(serv.getserverVendor() + " - " + serv.getserverVersion(), objectName.getKeyProperty("name"), "images/database.gif", null, null, new TreeNode[]{this.createSubResources(serv.getresources())}, subResArray, serverName.toString(), J2EEServer.class.getName());
    }

    ResourceTreeNode[] createServers(ObjectName domain) throws Exception {
        String[] serversObjectNames = (String[])this.getMBeanServer().getAttribute(domain, "servers");
        ArrayList<ResourceTreeNode> servers = new ArrayList<ResourceTreeNode>();
        for (int i = 0; i < serversObjectNames.length; ++i) {
            servers.add(this.createServer(serversObjectNames[i]));
        }
        return servers.toArray(new ResourceTreeNode[servers.size()]);
    }

    TreeNode createDomain(ObjectName domain) throws Exception {
        return this.createTreeNode(domain.getKeyProperty("name"), "", "images/spirale.gif", null, null, null, this.createServers(domain));
    }

    TreeNode[] createDomains() {
        ObjectInstance[] insts = this.getMBeansForQuery("*:j2eeType=J2EEDomain,*", null);
        ArrayList<TreeNode> domainsCreated = new ArrayList<TreeNode>();
        for (int i = 0; i < insts.length; ++i) {
            ObjectName objectName = insts[i].getObjectName();
            try {
                if (!objectName.getDomain().equals(objectName.getKeyProperty("name"))) continue;
                domainsCreated.add(this.createDomain(objectName));
                continue;
            }
            catch (AttributeNotFoundException e) {
                System.err.println(e.getClass().getName() + ": " + e.getMessage() + "; mbean '" + objectName + "' not a proper j2eeType=J2EEDomain");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        TreeNode[] domains = domainsCreated.toArray(new TreeNode[domainsCreated.size()]);
        return domains;
    }

    protected TreeNode getTreeForResource(String profile, ManageableResource resource) {
        try {
            return this.createTreeNode("J2EE Domains", "Display JSR-77 Managed Objects", "images/elements32.gif", null, null, this.createDomains(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public class ListerSorter
    implements Comparator {
        protected String[] suffixOrder;

        public ListerSorter(String[] suffixOrder) {
            this.suffixOrder = suffixOrder;
        }

        public ListerSorter() {
            this(DEFAULT_SUFFIX_ORDER);
        }

        public int compare(Object o1, Object o2) {
            return this.getExtensionIndex((ResourceTreeNode)o1) - this.getExtensionIndex((ResourceTreeNode)o2);
        }

        public int getExtensionIndex(ResourceTreeNode node) {
            int i;
            String name = node.getName();
            if (name == null) {
                name = "";
            }
            for (i = 0; i < this.suffixOrder.length && !name.endsWith(this.suffixOrder[i]); ++i) {
            }
            return i;
        }
    }
}

