/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.factory;

import com.clustercontrol.bean.ConfirmConstant;
import com.clustercontrol.bean.FacilityTargetConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.ViewListInfo;
import com.clustercontrol.monitor.bean.ReportEventInfo;
import com.clustercontrol.notify.monitor.ejb.entity.EventLogData;
import com.clustercontrol.notify.monitor.ejb.entity.EventLogLocal;
import com.clustercontrol.notify.monitor.ejb.entity.EventLogUtil;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.util.apllog.AplLogger;
import java.io.File;
import java.io.FileInputStream;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectEvent {
    protected static Log m_log = LogFactory.getLog(SelectEvent.class);
    private static final int MAX_DISPLAY_NUMBER = 500;
    private static Integer MAX_REPORT_EVENT_COUNT = null;
    private static Integer MAX_REPORT_EVENT_COUNT_DEFAULT = 1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectEvent() {
        if (MAX_REPORT_EVENT_COUNT == null) {
            Properties properties = new Properties();
            try {
                String etcdir = System.getProperty("hinemos.manager.etc.dir");
                String propertyFile = etcdir + File.separator + "hinemos.properties";
                properties.load(new FileInputStream(propertyFile));
                MAX_REPORT_EVENT_COUNT = properties.containsKey("monitor.common.report.event.count") ? Integer.valueOf(Integer.parseInt(properties.getProperty("monitor.common.report.event.count"))) : MAX_REPORT_EVENT_COUNT_DEFAULT;
            }
            catch (Exception e) {
                MAX_REPORT_EVENT_COUNT = MAX_REPORT_EVENT_COUNT_DEFAULT;
            }
            finally {
                if (MAX_REPORT_EVENT_COUNT < -1) {
                    MAX_REPORT_EVENT_COUNT = MAX_REPORT_EVENT_COUNT_DEFAULT;
                } else if (MAX_REPORT_EVENT_COUNT == -1) {
                    MAX_REPORT_EVENT_COUNT = null;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ViewListInfo getEventList(String facilityId, int level, int messages) throws CreateException, FinderException, NamingException, SQLException {
        ViewListInfo list = new ViewListInfo();
        try {
            String[] facilityIds = null;
            if (facilityId != null && !"".equals(facilityId)) {
                if (level == -1) {
                    if (facilityId == null || "".equals(facilityId)) return null;
                    facilityIds = new String[]{facilityId};
                } else {
                    ArrayList facilityIdList = RepositoryControllerUtil.getLocalHome().create().getFacilityIdList(facilityId, level);
                    if (facilityIdList != null && facilityIdList.size() > 0) {
                        facilityIds = new String[facilityIdList.size()];
                        facilityIdList.toArray(facilityIds);
                    } else {
                        if (facilityId == null) return null;
                        facilityIds = new String[]{facilityId};
                    }
                }
            }
            if (messages <= 0) {
                messages = 500;
            }
            Integer limit = new Integer(messages + 1);
            Collection ct = EventLogUtil.getLocalHome().findEvent(facilityIds, null, null, null, null, null, null, null, new Integer(0), null, false, limit);
            if (ct.size() > messages) {
                int critical = EventLogUtil.getLocalHome().countEvent(facilityIds, Integer.valueOf(0), null, null, null, null, null, null, new Integer(0), null);
                int warning = EventLogUtil.getLocalHome().countEvent(facilityIds, Integer.valueOf(2), null, null, null, null, null, null, new Integer(0), null);
                int info = EventLogUtil.getLocalHome().countEvent(facilityIds, Integer.valueOf(3), null, null, null, null, null, null, new Integer(0), null);
                int unKnown = EventLogUtil.getLocalHome().countEvent(facilityIds, Integer.valueOf(1), null, null, null, null, null, null, new Integer(0), null);
                int total = critical + warning + info + unKnown;
                list.setCritical(critical);
                list.setWarning(warning);
                list.setInfo(info);
                list.setUnKnown(unKnown);
                list.setTotal(total);
            }
            this.collectionToEventList(ct, list, messages);
            return list;
        }
        catch (CreateException e) {
            this.outputLog((Exception)((Object)e), "getEventList()", facilityId, null, null, null, null, null, null, null, null, null);
            throw e;
        }
        catch (FinderException e) {
            this.outputLog((Exception)((Object)e), "getEventList()", facilityId, null, null, null, null, null, null, null, null, null);
            throw e;
        }
        catch (NamingException e) {
            this.outputLog(e, "getEventList()", facilityId, null, null, null, null, null, null, null, null, null);
            throw e;
        }
    }

    public ViewListInfo getEventList(String facilityId, Property property, int messages) throws CreateException, FinderException, NamingException, SQLException {
        ViewListInfo list = new ViewListInfo();
        Integer priority = null;
        Timestamp outputFromDate = null;
        Timestamp outputToDate = null;
        Timestamp generationFromDate = null;
        Timestamp generationToDate = null;
        String facilityType = null;
        String application = null;
        String message = null;
        Integer confirmFlg = null;
        String confirmUser = null;
        try {
            int confirmFlgType;
            int priorityType;
            ArrayList values = null;
            values = PropertyUtil.getPropertyValue((Property)property, (String)"priority");
            if (!"".equals((String)values.get(0)) && (priorityType = PriorityConstant.stringToType((String)((String)values.get(0)))) != -1) {
                priority = new Integer(priorityType);
            }
            if ((values = PropertyUtil.getPropertyValue((Property)property, (String)"outputFromDate")).get(0) instanceof Date) {
                outputFromDate = new Timestamp(((Date)values.get(0)).getTime());
                outputFromDate.setNanos(0);
            }
            if ((values = PropertyUtil.getPropertyValue((Property)property, (String)"outputToDate")).get(0) instanceof Date) {
                outputToDate = new Timestamp(((Date)values.get(0)).getTime());
                outputToDate.setNanos(999999999);
            }
            if ((values = PropertyUtil.getPropertyValue((Property)property, (String)"generationFromDate")).get(0) instanceof Date) {
                generationFromDate = new Timestamp(((Date)values.get(0)).getTime());
                generationFromDate.setNanos(0);
            }
            if ((values = PropertyUtil.getPropertyValue((Property)property, (String)"generationToDate")).get(0) instanceof Date) {
                generationToDate = new Timestamp(((Date)values.get(0)).getTime());
                generationToDate.setNanos(999999999);
            }
            if (!"".equals((String)(values = PropertyUtil.getPropertyValue((Property)property, (String)"facilityType")).get(0))) {
                facilityType = (String)values.get(0);
            }
            if (!"".equals((String)(values = PropertyUtil.getPropertyValue((Property)property, (String)"application")).get(0))) {
                application = (String)values.get(0);
            }
            if (!"".equals((String)(values = PropertyUtil.getPropertyValue((Property)property, (String)"message")).get(0))) {
                message = (String)values.get(0);
            }
            if ((confirmFlgType = ConfirmConstant.stringToType((String)((String)(values = PropertyUtil.getPropertyValue((Property)property, (String)"confirmed")).get(0)))) != -1) {
                confirmFlg = new Integer(confirmFlgType);
            }
            if (!"".equals((String)(values = PropertyUtil.getPropertyValue((Property)property, (String)"confirmUser")).get(0))) {
                confirmUser = (String)values.get(0);
            }
            String[] facilityIds = null;
            if (facilityId != null && !"".equals(facilityId)) {
                ArrayList facilityIdList;
                int level = 0;
                if (FacilityTargetConstant.STRING_BENEATH.equals(facilityType)) {
                    level = 1;
                }
                if ((facilityIdList = RepositoryControllerUtil.getLocalHome().create().getFacilityIdList(facilityId, level)) != null && facilityIdList.size() > 0) {
                    facilityIds = new String[facilityIdList.size()];
                    facilityIdList.toArray(facilityIds);
                } else if (facilityId != null) {
                    facilityIds = new String[]{facilityId};
                } else {
                    return null;
                }
            }
            if (messages <= 0) {
                messages = 500;
            }
            Integer limit = new Integer(messages + 1);
            Collection ct = EventLogUtil.getLocalHome().findEvent(facilityIds, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, application, message, confirmFlg, confirmUser, false, limit);
            if (ct.size() > messages) {
                int critical = EventLogUtil.getLocalHome().countEvent(facilityIds, Integer.valueOf(0), outputFromDate, outputToDate, generationFromDate, generationToDate, application, message, confirmFlg, confirmUser);
                int warning = EventLogUtil.getLocalHome().countEvent(facilityIds, Integer.valueOf(2), outputFromDate, outputToDate, generationFromDate, generationToDate, application, message, confirmFlg, confirmUser);
                int info = EventLogUtil.getLocalHome().countEvent(facilityIds, Integer.valueOf(3), outputFromDate, outputToDate, generationFromDate, generationToDate, application, message, confirmFlg, confirmUser);
                int unKnown = EventLogUtil.getLocalHome().countEvent(facilityIds, Integer.valueOf(1), outputFromDate, outputToDate, generationFromDate, generationToDate, application, message, confirmFlg, confirmUser);
                if (priority != null) {
                    switch (priority) {
                        case 0: {
                            warning = 0;
                            info = 0;
                            unKnown = 0;
                            break;
                        }
                        case 2: {
                            critical = 0;
                            info = 0;
                            unKnown = 0;
                            break;
                        }
                        case 3: {
                            critical = 0;
                            warning = 0;
                            unKnown = 0;
                            break;
                        }
                        case 1: {
                            critical = 0;
                            warning = 0;
                            info = 0;
                        }
                    }
                }
                int total = critical + warning + info + unKnown;
                list.setCritical(critical);
                list.setWarning(warning);
                list.setInfo(info);
                list.setUnKnown(unKnown);
                list.setTotal(total);
            }
            this.collectionToEventList(ct, list, messages);
        }
        catch (CreateException e) {
            this.outputLog((Exception)((Object)e), "getEventList()", facilityId, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, facilityType, application, message, confirmFlg);
            throw e;
        }
        catch (FinderException e) {
            this.outputLog((Exception)((Object)e), "getEventList()", facilityId, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, facilityType, application, message, confirmFlg);
            throw e;
        }
        catch (NamingException e) {
            this.outputLog(e, "getEventList()", facilityId, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, facilityType, application, message, confirmFlg);
            throw e;
        }
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EventLogLocal getHighPriorityEvent(String facilityId, int level) throws CreateException, FinderException, NamingException {
        EventLogLocal event = null;
        try {
            String[] facilityIds = null;
            if (level == -1) {
                if (facilityId == null) return null;
                if ("".equals(facilityId)) return null;
                facilityIds = new String[]{facilityId};
            } else {
                ArrayList facilityIdList = RepositoryControllerUtil.getLocalHome().create().getFacilityIdList(facilityId, level);
                if (facilityIdList != null && facilityIdList.size() > 0) {
                    facilityIds = new String[facilityIdList.size()];
                    facilityIdList.toArray(facilityIds);
                } else {
                    if (facilityId == null) return null;
                    facilityIds = new String[]{facilityId};
                }
            }
            int[] priorityList = PriorityConstant.PRIORITY_LIST;
            int i = 0;
            while (i < priorityList.length) {
                Collection ct = EventLogUtil.getLocalHome().findHighPriorityEvent(facilityIds, Integer.valueOf(priorityList[i]), null, null, null, null, null, null, new Integer(0), null);
                Iterator itr = ct.iterator();
                if (itr.hasNext()) {
                    return (EventLogLocal)itr.next();
                }
                ++i;
            }
            return event;
        }
        catch (CreateException e) {
            m_log.debug((Object)("getHighPriorityEvent():" + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            m_log.debug((Object)("getHighPriorityEvent():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            m_log.debug((Object)("getHighPriorityEvent():" + e.getMessage()));
            throw e;
        }
    }

    public ArrayList getEventListForReport(String facilityId, Property property) throws CreateException, FinderException, NamingException, IndexOutOfBoundsException {
        ArrayList<ReportEventInfo> list = null;
        Integer priority = null;
        Timestamp outputFromDate = null;
        Timestamp outputToDate = null;
        Timestamp generationFromDate = null;
        Timestamp generationToDate = null;
        String facilityType = null;
        String application = null;
        String message = null;
        Integer confirmFlg = null;
        String confirmUser = null;
        try {
            int confirmFlgType;
            int priorityType;
            ArrayList values = null;
            values = PropertyUtil.getPropertyValue((Property)property, (String)"priority");
            if (!"".equals((String)values.get(0)) && (priorityType = PriorityConstant.stringToType((String)((String)values.get(0)))) != -1) {
                priority = new Integer(priorityType);
            }
            if ((values = PropertyUtil.getPropertyValue((Property)property, (String)"outputFromDate")).get(0) instanceof Date) {
                outputFromDate = new Timestamp(((Date)values.get(0)).getTime());
                outputFromDate.setNanos(0);
            }
            if ((values = PropertyUtil.getPropertyValue((Property)property, (String)"outputToDate")).get(0) instanceof Date) {
                outputToDate = new Timestamp(((Date)values.get(0)).getTime());
                outputToDate.setNanos(999999999);
            }
            if ((values = PropertyUtil.getPropertyValue((Property)property, (String)"generationFromDate")).get(0) instanceof Date) {
                generationFromDate = new Timestamp(((Date)values.get(0)).getTime());
                generationFromDate.setNanos(0);
            }
            if ((values = PropertyUtil.getPropertyValue((Property)property, (String)"generationToDate")).get(0) instanceof Date) {
                generationToDate = new Timestamp(((Date)values.get(0)).getTime());
                generationToDate.setNanos(999999999);
            }
            if (!"".equals((String)(values = PropertyUtil.getPropertyValue((Property)property, (String)"facilityType")).get(0))) {
                facilityType = (String)values.get(0);
            }
            if (!"".equals((String)(values = PropertyUtil.getPropertyValue((Property)property, (String)"application")).get(0))) {
                application = (String)values.get(0);
            }
            if (!"".equals((String)(values = PropertyUtil.getPropertyValue((Property)property, (String)"message")).get(0))) {
                message = (String)values.get(0);
            }
            if ((confirmFlgType = ConfirmConstant.stringToType((String)((String)(values = PropertyUtil.getPropertyValue((Property)property, (String)"confirmed")).get(0)))) != -1) {
                confirmFlg = new Integer(confirmFlgType);
            }
            if (!"".equals((String)(values = PropertyUtil.getPropertyValue((Property)property, (String)"confirmUser")).get(0))) {
                confirmUser = (String)values.get(0);
            }
            String[] facilityIds = null;
            if (facilityId != null && !"".equals(facilityId)) {
                ArrayList facilityIdList;
                int level = 0;
                if (FacilityTargetConstant.STRING_BENEATH.equals(facilityType)) {
                    level = 1;
                }
                if ((facilityIdList = RepositoryControllerUtil.getLocalHome().create().getFacilityIdList(facilityId, level)) != null && facilityIdList.size() > 0) {
                    facilityIds = new String[facilityIdList.size()];
                    facilityIdList.toArray(facilityIds);
                } else if (facilityId != null) {
                    facilityIds = new String[]{facilityId};
                } else {
                    return null;
                }
            }
            Collection ct = EventLogUtil.getLocalHome().findEvent(facilityIds, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, application, message, confirmFlg, confirmUser, true, MAX_REPORT_EVENT_COUNT);
            list = this.collectionToArrayForReportd(ct);
        }
        catch (CreateException e) {
            this.outputLog((Exception)((Object)e), "getEventListForReport()", facilityId, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, facilityType, application, message, confirmFlg);
            throw e;
        }
        catch (FinderException e) {
            this.outputLog((Exception)((Object)e), "getEventListForReport()", facilityId, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, facilityType, application, message, confirmFlg);
            throw e;
        }
        catch (NamingException e) {
            this.outputLog(e, "getEventListForReport()", facilityId, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, facilityType, application, message, confirmFlg);
            throw e;
        }
        return list;
    }

    private void collectionToEventList(Collection ct, ViewListInfo eventList, int messages) {
        int critical = 0;
        int warning = 0;
        int info = 0;
        int unKnown = 0;
        int total = ct.size();
        ArrayList<EventLogData> list = new ArrayList<EventLogData>();
        for (EventLogLocal event : ct) {
            EventLogData eventLogData = new EventLogData();
            eventLogData.setPriority(event.getPriority());
            eventLogData.setOutputDate(event.getOutputDate());
            eventLogData.setGenerationDate(event.getGenerationDate());
            eventLogData.setPluginId(event.getPluginId());
            eventLogData.setMonitorId(event.getMonitorId());
            eventLogData.setFacilityId(event.getFacilityId());
            eventLogData.setScopeText(event.getScopeText());
            eventLogData.setApplication(event.getApplication());
            eventLogData.setMessageId(event.getMessageId());
            eventLogData.setMessage(event.getMessage());
            eventLogData.setConfirmFlg(event.getConfirmFlg());
            eventLogData.setConfirmUser(event.getConfirmUser());
            list.add(eventLogData);
            if (ct.size() <= messages) {
                if (event.getPriority() == 0) {
                    ++critical;
                } else if (event.getPriority() == 2) {
                    ++warning;
                } else if (event.getPriority() == 3) {
                    ++info;
                } else if (event.getPriority() == 1) {
                    ++unKnown;
                }
            }
            if (list.size() < messages) continue;
            break;
        }
        if (ct.size() <= messages) {
            eventList.setCritical(critical);
            eventList.setWarning(warning);
            eventList.setInfo(info);
            eventList.setUnKnown(unKnown);
            eventList.setTotal(total);
        }
        eventList.setList(list);
    }

    private ArrayList<ReportEventInfo> collectionToArrayForReportd(Collection ct) {
        ArrayList<ReportEventInfo> list = new ArrayList<ReportEventInfo>();
        for (EventLogLocal event : ct) {
            ReportEventInfo info = new ReportEventInfo();
            info.setApplication(event.getApplication());
            info.setConfirmFlg(ConfirmConstant.typeToString((int)event.getConfirmFlg()));
            info.setFacilityId(event.getFacilityId());
            info.setGenerationDate(new Date(event.getGenerationDate().getTime()));
            info.setMessage(event.getMessage());
            info.setMessageId(event.getMessageId());
            info.setMessageOrg(event.getMessageOrg());
            info.setMonitorId(event.getMonitorId());
            info.setOutputDate(new Date(event.getOutputDate().getTime()));
            info.setPluginId(event.getPluginId());
            info.setPriority(PriorityConstant.typeToString((int)event.getPriority()));
            info.setScopeText(event.getScopeText());
            info.setConfirmUser(event.getConfirmUser());
            list.add(info);
        }
        return list;
    }

    private void outputLog(Exception e, String method, String facilityId, Integer priority, Timestamp outputFromDate, Timestamp outputToDate, Timestamp generationFromDate, Timestamp generationToDate, String facilityType, String application, String message, Integer confirmFlg) {
        int priorityInt = -1;
        String outputFromDateString = null;
        String outputToDateString = null;
        String generationFromDateString = null;
        String generationToDateString = null;
        int confirmFlgInt = -1;
        if (priority != null) {
            priorityInt = priority;
        }
        if (outputFromDate != null) {
            outputFromDateString = outputFromDate.toString();
        }
        if (outputToDate != null) {
            outputToDateString = outputToDate.toString();
        }
        if (generationFromDate != null) {
            generationFromDateString = generationFromDate.toString();
        }
        if (generationToDate != null) {
            generationToDateString = generationToDate.toString();
        }
        if (confirmFlg != null) {
            confirmFlgInt = confirmFlg;
        }
        AplLogger apllog = new AplLogger("MON", "mon");
        Object[] args = new String[]{facilityId, PriorityConstant.typeToString((int)priorityInt), outputFromDateString, outputToDateString, generationFromDateString, generationToDateString, facilityType, application, message, ConfirmConstant.typeToString((int)confirmFlgInt)};
        apllog.put("SYS", "003", args);
        m_log.debug((Object)(method + ":" + e.getMessage()));
    }
}

