/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.deployment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.DeploymentAspectManager;
import org.jboss.wsf.spi.deployment.WSFDeploymentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentAspectManagerImpl
implements DeploymentAspectManager {
    private static final Logger log = Logger.getLogger(DeploymentAspectManagerImpl.class);
    private String name;
    private DeploymentAspectManager parent;
    private List<DeploymentAspect> sortedAspects = new ArrayList<DeploymentAspect>();
    private long deploymentCount;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DeploymentAspectManager getParent() {
        return this.parent;
    }

    public void setParent(DeploymentAspectManager parent) {
        this.parent = parent;
    }

    public List<DeploymentAspect> getDeploymentAspects() {
        return Collections.unmodifiableList(this.sortedAspects);
    }

    public void setDeploymentAspects(List<DeploymentAspect> aspects) {
        if (this.deploymentCount > 0L) {
            throw new IllegalStateException("Cannot add deployment aspects");
        }
        this.sortedAspects.clear();
        this.sortedAspects.addAll(aspects);
    }

    public void deploy(Deployment dep) {
        DeploymentAspect aspect;
        int i;
        HashSet providedConditions = new HashSet();
        for (i = 0; i < this.getDeploymentAspects().size(); ++i) {
            aspect = this.getDeploymentAspects().get(i);
            this.logInvocation(aspect, "Create");
            aspect.create(dep);
            providedConditions.addAll(aspect.getProvidesAsSet());
        }
        dep.setState(Deployment.DeploymentState.CREATED);
        for (i = 0; i < this.getDeploymentAspects().size(); ++i) {
            aspect = this.getDeploymentAspects().get(i);
            try {
                this.logInvocation(aspect, "Start");
                aspect.start(dep);
                continue;
            }
            catch (RuntimeException rte) {
                while (i-- >= 0) {
                    this.failsafeDestroy(aspect, dep);
                }
                throw rte;
            }
        }
        dep.setState(Deployment.DeploymentState.STARTED);
        ++this.deploymentCount;
    }

    public void undeploy(Deployment dep) {
        DeploymentAspect aspect;
        int i;
        for (i = this.getDeploymentAspects().size(); 0 < i; --i) {
            aspect = this.getDeploymentAspects().get(i - 1);
            this.failsafeStop(aspect, dep);
        }
        dep.setState(Deployment.DeploymentState.STOPPED);
        for (i = this.getDeploymentAspects().size(); 0 < i; --i) {
            aspect = this.getDeploymentAspects().get(i - 1);
            this.failsafeDestroy(aspect, dep);
        }
        dep.setState(Deployment.DeploymentState.DESTROYED);
    }

    private void failsafeStop(DeploymentAspect aspect, Deployment dep) {
        try {
            this.logInvocation(aspect, "Stop");
            aspect.stop(dep);
        }
        catch (RuntimeException rte) {
            WSFDeploymentException.rethrow((Throwable)rte);
        }
    }

    private void failsafeDestroy(DeploymentAspect aspect, Deployment dep) {
        try {
            this.logInvocation(aspect, "Destroy");
            aspect.destroy(dep);
        }
        catch (RuntimeException rte) {
            WSFDeploymentException.rethrow((Throwable)rte);
        }
    }

    private void logInvocation(DeploymentAspect aspect, String method) {
        String name = aspect.getClass().getName();
        name = name.substring(name.lastIndexOf(".") + 1);
        log.debug((Object)(name + ":" + method));
    }
}

