/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.operator;

import com.clustercontrol.performance.monitor.ejb.entity.CollectorSnmpMstData;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorSnmpMstLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorSnmpMstPK;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorSnmpMstUtil;
import com.clustercontrol.performance.operator.Operator;
import com.clustercontrol.sharedtable.DataTable;
import com.clustercontrol.sharedtable.TableEntry;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SnmpOperator
extends Operator {
    private static Log m_log = LogFactory.getLog(SnmpOperator.class);
    private static final long COUNTER32_MAX_VALUE = 0xFFFFFFFFL;
    private static final BigInteger COUTNER64_MAX_VALUE = BigInteger.valueOf(Long.MAX_VALUE).shiftLeft(1).add(BigInteger.valueOf(1L));
    private HashMap<String, CollectorSnmpMstData> m_oidMap = new HashMap();

    public void setItemCode(String itemCode) {
        super.setItemCode(itemCode);
        try {
            Collection beans = CollectorSnmpMstUtil.getLocalHome().findAll();
            Iterator itr = beans.iterator();
            this.getVariables().clear();
            while (itr.hasNext()) {
                CollectorSnmpMstLocal bean = (CollectorSnmpMstLocal)itr.next();
                if (!bean.getPlatformId().equals(this.getPlatformId()) || !bean.getItemCode().equals(itemCode)) continue;
                m_log.debug((Object)("add " + bean.getVariableId()));
                this.getVariables().add(bean.getVariableId());
            }
        }
        catch (FinderException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NamingException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public double getCurrentMibValue(String variable) throws Operator.CollectedDataNotFoundException, Operator.InvalidValueException {
        return this.getValue(variable, this.getCurrentTable());
    }

    public double getPreviousMibValue(String variable) throws Operator.CollectedDataNotFoundException, Operator.InvalidValueException {
        return this.getValue(variable, this.getPreviousTable());
    }

    public double getCurrentMibValueTotal() throws Operator.CollectedDataNotFoundException, Operator.InvalidValueException {
        Iterator<String> itr = this.getVariables().iterator();
        double total = 0.0;
        while (itr.hasNext()) {
            String variable = itr.next();
            total += this.getCurrentMibValue(variable);
        }
        return total;
    }

    public double getPreviousMibValueTotal() throws Operator.CollectedDataNotFoundException, Operator.InvalidValueException {
        Iterator<String> itr = this.getVariables().iterator();
        double total = 0.0;
        while (itr.hasNext()) {
            String variable = itr.next();
            total += this.getPreviousMibValue(variable);
        }
        return total;
    }

    private double getValue(String variable, DataTable table) throws Operator.CollectedDataNotFoundException, Operator.InvalidValueException {
        CollectorSnmpMstData data = this.getCollectorSnmpMstData(variable);
        if ("?".equals(data.getOidIndex())) {
            try {
                String oid = data.getTableOid() + "." + this.getDeviceIndex();
                return this.getMibValueDouble(table, data, oid);
            }
            catch (Operator.InvalidValueException e) {
                throw e;
            }
            catch (Exception e) {
                m_log.debug((Object)e.getMessage(), (Throwable)e);
                throw new Operator.CollectedDataNotFoundException();
            }
        }
        if ("*".equals(data.getOidIndex())) {
            try {
                String tableOid = data.getTableOid();
                Set entrys = table.getValueSetStartWith(tableOid);
                if (entrys == null) {
                    throw new Operator.CollectedDataNotFoundException();
                }
                double total = 0.0;
                Iterator itr = entrys.iterator();
                while (itr.hasNext()) {
                    String oid = ((TableEntry)itr.next()).getKey();
                    total += this.getMibValueDouble(table, data, oid);
                }
                return total;
            }
            catch (Exception e) {
                m_log.debug((Object)e.getMessage(), (Throwable)e);
                throw new Operator.CollectedDataNotFoundException();
            }
        }
        try {
            String oid = data.getTableOid() + "." + data.getOidIndex();
            return this.getMibValueDouble(table, data, oid);
        }
        catch (Operator.InvalidValueException e) {
            throw e;
        }
        catch (Exception e) {
            m_log.debug((Object)e.getMessage(), (Throwable)e);
            throw new Operator.CollectedDataNotFoundException();
        }
    }

    private long getMibValueLong(DataTable table, CollectorSnmpMstData data, String oid) throws Operator.InvalidValueException {
        TableEntry entry = table.getValue(oid);
        if (entry == null) {
            return Long.parseLong(data.getFailureValue());
        }
        long value = (Long)entry.getValue();
        return value;
    }

    private double getMibValueDouble(DataTable table, CollectorSnmpMstData data, String oid) throws Operator.InvalidValueException {
        long longValue = this.getMibValueLong(table, data, oid);
        return this.convLongToDouble(longValue);
    }

    private double convLongToDouble(long longValue) {
        double ret = longValue;
        if (longValue < 0L) {
            long tmp = longValue - Long.MAX_VALUE;
            ret = 9.223372036854776E18 + (double)tmp;
        }
        return ret;
    }

    public double getDifferenceValue(String variable) throws Operator.CollectedDataNotFoundException, Operator.InvalidValueException {
        m_log.debug((Object)("getDifferenceValue " + variable));
        CollectorSnmpMstData data = this.getCollectorSnmpMstData(variable);
        DataTable currentTable = this.getCurrentTable();
        DataTable previousTable = this.getPreviousTable();
        if ("?".equals(data.getOidIndex())) {
            try {
                String oid = data.getTableOid() + "." + this.getDeviceIndex();
                return this.getMibValueDiff(data, currentTable, previousTable, oid);
            }
            catch (Operator.InvalidValueException e) {
                throw e;
            }
            catch (Exception e) {
                m_log.debug((Object)e.getMessage(), (Throwable)e);
                throw new Operator.CollectedDataNotFoundException();
            }
        }
        if ("*".equals(data.getOidIndex())) {
            try {
                String tableOid = data.getTableOid();
                Set entrys = currentTable.getValueSetStartWith(tableOid);
                if (entrys == null) {
                    throw new Operator.CollectedDataNotFoundException();
                }
                double total = 0.0;
                Iterator itr = entrys.iterator();
                while (itr.hasNext()) {
                    String oid = ((TableEntry)itr.next()).getKey();
                    total += this.getMibValueDiff(data, currentTable, previousTable, oid);
                }
                return total;
            }
            catch (Operator.InvalidValueException e) {
                throw e;
            }
            catch (Exception e) {
                m_log.debug((Object)e.getMessage(), (Throwable)e);
                throw new Operator.CollectedDataNotFoundException();
            }
        }
        try {
            String oid = data.getTableOid() + "." + data.getOidIndex();
            return this.getMibValueDiff(data, currentTable, previousTable, oid);
        }
        catch (Operator.InvalidValueException e) {
            throw e;
        }
        catch (Exception e) {
            m_log.debug((Object)e.getMessage(), (Throwable)e);
            throw new Operator.CollectedDataNotFoundException();
        }
    }

    protected double getDifferenceValueTotal() throws Operator.CollectedDataNotFoundException, Operator.InvalidValueException {
        m_log.debug((Object)"getDifferenceValueTotal");
        Iterator<String> itr = this.getVariables().iterator();
        double total = 0.0;
        while (itr.hasNext()) {
            String variable = itr.next();
            total += this.getDifferenceValue(variable);
        }
        return total;
    }

    private double getMibValueDiff(CollectorSnmpMstData data, DataTable currentTable, DataTable previousTable, String oid) throws Operator.InvalidValueException {
        double ret = 0.0;
        long previousValue = this.getMibValueLong(previousTable, data, oid);
        long currentValue = this.getMibValueLong(currentTable, data, oid);
        long diff = currentValue - previousValue;
        if (diff >= 0L) {
            ret = diff;
        } else if ("Counter32".equals(data.getValueType())) {
            diff = 0x100000000L + diff;
            ret = this.convLongToDouble(diff);
        } else if ("Counter64".equals(data.getValueType())) {
            ret = COUTNER64_MAX_VALUE.add(BigInteger.valueOf(diff + 1L)).doubleValue();
        }
        return ret;
    }

    private CollectorSnmpMstData getCollectorSnmpMstData(String variable) {
        CollectorSnmpMstData data = this.m_oidMap.get(variable);
        if (data == null) {
            this.registerOidMap(variable);
            data = this.m_oidMap.get(variable);
            if (data == null) {
                throw new IllegalStateException();
            }
        }
        return data;
    }

    private void registerOidMap(String variable) {
        try {
            m_log.debug((Object)(this.getPlatformId() + ", " + this.getItemCode() + ", " + variable));
            CollectorSnmpMstLocal bean = CollectorSnmpMstUtil.getLocalHome().findByPrimaryKey(new CollectorSnmpMstPK(this.getPlatformId(), this.getItemCode(), variable));
            CollectorSnmpMstData data = new CollectorSnmpMstData(bean.getPlatformId(), bean.getItemCode(), bean.getVariableId(), bean.getTableOid(), bean.getOidIndex(), bean.getValueType(), bean.getPollingOid(), bean.getFailureValue());
            this.m_oidMap.put(variable, data);
        }
        catch (FinderException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NamingException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

