/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl.postoffice;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.jboss.messaging.core.impl.postoffice.ClusterRequest;
import org.jboss.messaging.core.impl.postoffice.PostOfficeAddressInfo;
import org.jboss.messaging.core.impl.postoffice.RequestTarget;

class JoinClusterRequest
extends ClusterRequest {
    private int nodeId;
    private PostOfficeAddressInfo info;

    JoinClusterRequest(int nodeId, PostOfficeAddressInfo info) {
        this.nodeId = nodeId;
        this.info = info;
    }

    JoinClusterRequest() {
    }

    public void write(DataOutputStream out) throws Exception {
        out.writeInt(this.nodeId);
        this.info.write(out);
    }

    public void read(DataInputStream in) throws Exception {
        this.nodeId = in.readInt();
        this.info = new PostOfficeAddressInfo();
        this.info.read(in);
    }

    public String toString() {
        return "JoinClusterRequest[info=" + this.info + "]";
    }

    Object execute(RequestTarget office) throws Throwable {
        office.handleNodeJoined(this.nodeId, this.info);
        return null;
    }

    byte getType() {
        return 1;
    }
}

