/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl.postoffice;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.contract.ChannelFactory;
import org.jboss.messaging.core.impl.postoffice.ClusterRequest;
import org.jboss.messaging.core.impl.postoffice.GroupListener;
import org.jboss.messaging.core.impl.postoffice.RequestTarget;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.Receiver;
import org.jgroups.View;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

public class GroupMember {
    public static final String DATA_SUFFIX = "-DATA";
    public static final String CONTROL_SUFFIX = "-CTRL";
    private static final Logger log = Logger.getLogger(GroupMember.class);
    private boolean trace = log.isTraceEnabled();
    private String groupName;
    private long stateTimeout;
    private long castTimeout;
    private ChannelFactory jChannelFactory;
    private Channel controlChannel;
    private Channel dataChannel;
    private RequestTarget requestTarget;
    private GroupListener groupListener;
    private MessageDispatcher dispatcher;
    private volatile View currentView;
    private Object waitLock = new Object();
    private AtomicBoolean ready = new AtomicBoolean(false);
    private CountDownLatch latch;
    private volatile boolean starting;

    public GroupMember(String groupName, long stateTimeout, long castTimeout, ChannelFactory jChannelFactory, RequestTarget requestTarget, GroupListener groupListener) {
        this.groupName = groupName;
        this.stateTimeout = stateTimeout;
        this.castTimeout = castTimeout;
        this.jChannelFactory = jChannelFactory;
        this.requestTarget = requestTarget;
        this.groupListener = groupListener;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void start() throws Exception {
        boolean first;
        this.controlChannel = this.jChannelFactory.createControlChannel();
        this.dataChannel = this.jChannelFactory.createDataChannel();
        this.controlChannel.setOpt(3, (Object)Boolean.FALSE);
        this.dataChannel.setOpt(3, (Object)Boolean.FALSE);
        ControlMessageListener messageListener = new ControlMessageListener();
        ControlMembershipListener membershipListener = new ControlMembershipListener();
        ControlRequestHandler requestHandler = new ControlRequestHandler();
        this.dispatcher = new MessageDispatcher(this.controlChannel, (MessageListener)messageListener, (MembershipListener)membershipListener, (RequestHandler)requestHandler, true);
        DataReceiver dataReceiver = new DataReceiver();
        this.dataChannel.setReceiver((Receiver)dataReceiver);
        this.starting = true;
        this.controlChannel.connect(this.groupName + CONTROL_SUFFIX);
        if (!((JChannel)this.controlChannel).flushSupported()) {
            throw new IllegalStateException("Flush is not supported on the UDP Channel, please check your JGroups UDP stack as Flush is required");
        }
        boolean bl = first = !this.controlChannel.getState(null, this.stateTimeout);
        if (first) {
            this.ready.set(true);
            if (this.latch == null) {
                throw new IllegalStateException("Check your JGroups stack... You probably don't have pbs.flush in your stack what might cause problems on JBoss Messaging");
            }
            this.latch.countDown();
            this.starting = false;
            log.debug((Object)"We are the first member of the group so no need to wait for state");
        } else {
            this.waitForState();
            log.debug((Object)"State arrived");
        }
        this.dataChannel.connect(this.groupName + DATA_SUFFIX);
    }

    public void stop() throws Exception {
        this.ready.set(false);
        try {
            this.dataChannel.close();
        }
        catch (Exception e) {
            log.debug((Object)"Failed to close data channel", (Throwable)e);
        }
        try {
            this.controlChannel.close();
        }
        catch (Exception e) {
            log.debug((Object)"Failed to close control channel", (Throwable)e);
        }
        this.controlChannel = null;
        this.dataChannel = null;
        this.currentView = null;
        Thread.sleep(1000L);
    }

    public Address getControlChannelAddress() {
        return this.controlChannel.getLocalAddress();
    }

    public Address getDataChannelAddress() {
        return this.dataChannel.getLocalAddress();
    }

    public long getCastTimeout() {
        return this.castTimeout;
    }

    public View getCurrentView() {
        return this.currentView;
    }

    public void multicastControl(ClusterRequest request, boolean sync) throws Exception {
        if (this.ready.get()) {
            if (this.trace) {
                log.trace((Object)(this + " multicasting " + request + " to control channel, sync=" + sync));
            }
            Message message = new Message(null, null, this.writeRequest(request));
            RspList rspList = this.dispatcher.castMessage(null, message, sync ? 2 : 6, this.castTimeout);
            if (sync) {
                for (Rsp rsp : rspList.values()) {
                    if (rsp.wasReceived()) continue;
                    throw new IllegalStateException(this + " response not received from " + rsp.getSender() + " - there may be others");
                }
            }
        }
    }

    public void unicastControl(ClusterRequest request, Address address, boolean sync) throws Exception {
        if (this.ready.get()) {
            if (this.trace) {
                log.trace((Object)(this + " multicasting " + request + " to control channel, sync=" + sync));
            }
            Message message = new Message(address, null, this.writeRequest(request));
            Vector<Address> v = new Vector<Address>();
            v.add(address);
            RspList rspList = this.dispatcher.castMessage(v, message, sync ? 2 : 6, this.castTimeout);
            if (sync) {
                for (Rsp rsp : rspList.values()) {
                    if (rsp.wasReceived()) continue;
                    throw new IllegalStateException(this + " response not received from " + rsp.getSender() + " - there may be others");
                }
            }
        }
    }

    public void multicastData(ClusterRequest request) throws Exception {
        if (this.ready.get()) {
            if (this.trace) {
                log.trace((Object)(this + " multicasting " + request + " to data channel"));
            }
            byte[] bytes = this.writeRequest(request);
            this.dataChannel.send(new Message(null, null, bytes));
        }
    }

    public void unicastData(ClusterRequest request, Address address) throws Exception {
        if (this.ready.get()) {
            if (this.trace) {
                log.trace((Object)(this + " unicasting " + request + " to address " + address));
            }
            byte[] bytes = this.writeRequest(request);
            this.dataChannel.send(new Message(address, null, bytes));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForState() throws Exception {
        Object object = this.waitLock;
        synchronized (object) {
            long timeRemaining = this.stateTimeout;
            long start = System.currentTimeMillis();
            while (!this.ready.get() && timeRemaining > 0L) {
                this.waitLock.wait(this.stateTimeout);
                if (this.ready.get()) continue;
                long waited = System.currentTimeMillis() - start;
                timeRemaining -= waited;
            }
            if (!this.ready.get()) {
                throw new IllegalStateException("Timed out waiting for state to change");
            }
        }
    }

    private ClusterRequest readRequest(byte[] bytes) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        DataInputStream dais = new DataInputStream(bais);
        ClusterRequest request = ClusterRequest.createFromStream(dais);
        dais.close();
        return request;
    }

    private byte[] writeRequest(ClusterRequest request) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        DataOutputStream daos = new DataOutputStream(baos);
        ClusterRequest.writeToStream(daos, request);
        daos.flush();
        return baos.toByteArray();
    }

    private class ControlRequestHandler
    implements RequestHandler {
        private ControlRequestHandler() {
        }

        public Object handle(Message message) {
            if (GroupMember.this.trace) {
                log.trace((Object)(this + ".RequestHandler received " + message + " on the control channel"));
            }
            try {
                if (!GroupMember.this.ready.get()) {
                    return null;
                }
                byte[] bytes = message.getBuffer();
                ClusterRequest request = GroupMember.this.readRequest(bytes);
                return request.execute(GroupMember.this.requestTarget);
            }
            catch (Throwable e) {
                log.error((Object)"Caught Exception in RequestHandler", e);
                IllegalStateException e2 = new IllegalStateException(e.getMessage());
                e2.setStackTrace(e.getStackTrace());
                throw e2;
            }
        }
    }

    private class DataReceiver
    implements Receiver {
        private DataReceiver() {
        }

        public void block() {
        }

        public void suspect(Address address) {
        }

        public void viewAccepted(View view) {
        }

        public byte[] getState() {
            return null;
        }

        public void receive(Message message) {
            if (GroupMember.this.trace) {
                log.trace((Object)(this + " received " + message + " on the data channel"));
            }
            try {
                if (!GroupMember.this.ready.get()) {
                    return;
                }
                byte[] bytes = message.getBuffer();
                ClusterRequest request = GroupMember.this.readRequest(bytes);
                request.execute(GroupMember.this.requestTarget);
            }
            catch (Throwable e) {
                log.error((Object)"Caught Exception in Receiver", e);
                IllegalStateException e2 = new IllegalStateException(e.getMessage());
                e2.setStackTrace(e.getStackTrace());
                throw e2;
            }
        }

        public void setState(byte[] bytes) {
        }
    }

    private class ControlMembershipListener
    implements MembershipListener {
        private ControlMembershipListener() {
        }

        public void block() {
            try {
                if (GroupMember.this.latch != null && !GroupMember.this.latch.await(GroupMember.this.stateTimeout, TimeUnit.MILLISECONDS)) {
                    log.warn((Object)"Timed out waiting for latch to be released");
                }
            }
            catch (InterruptedException e) {
                log.warn((Object)"Thread interrupted");
            }
        }

        public void suspect(Address address) {
        }

        public void viewAccepted(View newView) {
            log.info((Object)(this + " got new view " + newView + ", old view is " + GroupMember.this.currentView));
            if (newView instanceof MergeView) {
                // empty if block
            }
            View oldView = GroupMember.this.currentView;
            GroupMember.this.currentView = newView;
            log.info((Object)("I am (" + GroupMember.this.controlChannel.getLocalAddress() + ")"));
            if (newView.size() == 1 && GroupMember.this.starting && newView.getMembers().get(0).equals(GroupMember.this.controlChannel.getLocalAddress()) && !GroupMember.this.ready.get()) {
                GroupMember.this.latch = new CountDownLatch(1);
            }
            try {
                if (oldView != null) {
                    ArrayList<Address> leftNodes = new ArrayList<Address>();
                    for (Address address : oldView.getMembers()) {
                        if (newView.containsMember(address)) continue;
                        leftNodes.add(address);
                    }
                    if (!leftNodes.isEmpty()) {
                        GroupMember.this.groupListener.nodesLeft(leftNodes);
                        log.info((Object)("Dead members: " + leftNodes.size() + " (" + leftNodes + ")"));
                    }
                }
                ArrayList<Address> nodesAdded = new ArrayList<Address>();
                for (Address address : newView.getMembers()) {
                    if (oldView != null && oldView.containsMember(address)) continue;
                    GroupMember.this.groupListener.nodeJoined(address);
                    nodesAdded.add(address);
                }
                if (!nodesAdded.isEmpty()) {
                    log.info((Object)("New Members : " + nodesAdded.size() + " (" + nodesAdded + ")"));
                }
                log.info((Object)("All Members : " + newView.getMembers().size() + " (" + newView.getMembers() + ")"));
            }
            catch (Throwable e) {
                log.error((Object)"Caught Exception in MembershipListener", e);
            }
        }

        public byte[] getState() {
            return null;
        }
    }

    private class ControlMessageListener
    implements MessageListener {
        private ControlMessageListener() {
        }

        public byte[] getState() {
            try {
                if (!GroupMember.this.ready.get()) {
                    throw new IllegalStateException("Received control message but group member is not ready");
                }
                if (GroupMember.this.trace) {
                    log.trace((Object)(this + ".ControlMessageListener got state"));
                }
                byte[] state = GroupMember.this.groupListener.getState();
                return state;
            }
            catch (Exception e) {
                log.error((Object)"Failed to get state", (Throwable)e);
                throw new IllegalStateException("Failed to get state");
            }
        }

        public void receive(Message message) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setState(byte[] bytes) {
            Object object = GroupMember.this.waitLock;
            synchronized (object) {
                try {
                    GroupMember.this.groupListener.setState(bytes);
                }
                catch (Exception e) {
                    log.error((Object)"Failed to set state", (Throwable)e);
                }
                GroupMember.this.ready.set(true);
                GroupMember.this.waitLock.notify();
            }
        }
    }
}

