/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.jaxws.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.ws.core.jaxws.WrapperGenerator;
import org.jboss.ws.metadata.umdm.FaultMetaData;
import org.jboss.ws.metadata.umdm.ParameterMetaData;
import org.jboss.ws.tools.jaxws.impl.WritableWrapperGenerator;

public class ChainedWritableWrapperGenerator
implements WrapperGenerator {
    private List<Entry> chain = new ArrayList<Entry>();

    public void reset(ClassLoader loader) {
        for (Entry entry : this.chain) {
            entry.generator.reset(loader);
        }
    }

    public void write() throws IOException {
        for (Entry entry : this.chain) {
            entry.generator.write(entry.directory);
        }
    }

    public void generate(FaultMetaData fmd) {
        for (Entry entry : this.chain) {
            entry.generator.generate(fmd);
        }
    }

    public void generate(ParameterMetaData pmd) {
        for (Entry entry : this.chain) {
            entry.generator.generate(pmd);
        }
    }

    public void add(WritableWrapperGenerator generator, File directory) {
        this.chain.add(new Entry(generator, directory));
    }

    static class Entry {
        WritableWrapperGenerator generator;
        File directory;

        Entry(WritableWrapperGenerator generator, File directory) {
            this.generator = generator;
            this.directory = directory;
        }
    }
}

