/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.io.Serializable;
import javax.jms.Topic;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import org.jboss.mq.DurableSubscriptionID;
import org.jboss.mq.SpyDestination;

public class SpyTopic
extends SpyDestination
implements Serializable,
Topic,
Referenceable {
    static final long serialVersionUID = -4784950783387129468L;
    protected DurableSubscriptionID durableSubscriptionID;
    private String toStringStr;

    public SpyTopic(String topicName) {
        super(topicName);
        this.toStringStr = "TOPIC." + this.name;
    }

    public SpyTopic(SpyTopic topic, String clientID, String subscriptionName, String selector) {
        this(topic, new DurableSubscriptionID(clientID, subscriptionName, selector));
    }

    public SpyTopic(SpyTopic topic, DurableSubscriptionID subid) {
        super(topic.getTopicName());
        this.toStringStr = subid == null ? "TOPIC." + this.name : "TOPIC." + this.name + "." + subid;
        this.durableSubscriptionID = subid;
    }

    public DurableSubscriptionID getDurableSubscriptionID() {
        return this.durableSubscriptionID;
    }

    public String getTopicName() {
        return this.name;
    }

    public Reference getReference() throws NamingException {
        return new Reference("org.jboss.mq.SpyTopic", new StringRefAddr("name", this.name), "org.jboss.mq.referenceable.SpyDestinationObjectFactory", null);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SpyTopic)) {
            return false;
        }
        if (obj.hashCode() != this.hash) {
            return false;
        }
        return ((SpyDestination)obj).name.equals(this.name);
    }

    public String toString() {
        return this.toStringStr;
    }
}

