/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.io.PrintStream;
import java.io.PrintWriter;
import javax.jms.JMSException;
import org.jboss.util.NestedException;
import org.jboss.util.NestedThrowable;

public class SpyJMSException
extends JMSException
implements NestedThrowable {
    static final long serialVersionUID = 5216406958161784593L;
    protected Throwable nested;

    public static void rethrowAsJMSException(String message, Throwable t) throws JMSException {
        throw SpyJMSException.getAsJMSException(message, t);
    }

    public static JMSException getAsJMSException(String message, Throwable t) {
        if (t instanceof JMSException) {
            return (JMSException)t;
        }
        return new SpyJMSException(message, t);
    }

    public SpyJMSException(String msg) {
        super(msg);
        this.nested = null;
    }

    public SpyJMSException(String msg, String code) {
        super(msg, code);
        this.nested = null;
    }

    public SpyJMSException(String msg, Throwable nested) {
        super(msg);
        this.nested = nested;
        NestedThrowable.Util.checkNested(this, nested);
    }

    public SpyJMSException(Throwable nested) {
        this(nested.getMessage(), nested);
    }

    public void setLinkedException(Exception e) {
        this.nested = e;
    }

    public Exception getLinkedException() {
        if (this.nested == null) {
            return this;
        }
        if (this.nested instanceof Exception) {
            return (Exception)this.nested;
        }
        return new NestedException(this.nested);
    }

    public Throwable getNested() {
        return this.nested;
    }

    public Throwable getCause() {
        return this.nested;
    }

    public String getMessage() {
        return NestedThrowable.Util.getMessage(super.getMessage(), this.nested);
    }

    public void printStackTrace(PrintStream stream) {
        if (this.nested == null || NestedThrowable.PARENT_TRACE_ENABLED) {
            super.printStackTrace(stream);
        }
        NestedThrowable.Util.print(this.nested, stream);
    }

    public void printStackTrace(PrintWriter writer) {
        if (this.nested == null || NestedThrowable.PARENT_TRACE_ENABLED) {
            super.printStackTrace(writer);
        }
        NestedThrowable.Util.print(this.nested, writer);
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }
}

