/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.remoting;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.util.MethodHashing;
import org.jboss.aop.util.PayloadKey;
import org.jboss.remoting.InvokerLocator;

public class PojiProxy
implements Serializable,
InvocationHandler {
    private static final long serialVersionUID = 8054816523858555978L;
    private Object oid;
    private InvokerLocator uri;
    private Interceptor[] interceptors;

    public PojiProxy(Object oid, InvokerLocator uri, Interceptor[] interceptors) {
        this.oid = oid;
        this.uri = uri;
        this.interceptors = interceptors;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        long hash = MethodHashing.calculateHash(method);
        MethodInvocation sri = new MethodInvocation(this.interceptors, hash, method, method, null);
        sri.setArguments(args);
        sri.getMetaData().addMetaData("DISPATCHER", "OID", this.oid, PayloadKey.AS_IS);
        sri.getMetaData().addMetaData("REMOTING", "INVOKER_LOCATOR", this.uri, PayloadKey.AS_IS);
        sri.getMetaData().addMetaData("REMOTING", "SUBSYSTEM", "AOP", PayloadKey.AS_IS);
        return sri.invokeNext();
    }
}

