/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.job;

import com.clustercontrol.performance.bean.QuartzConstant;
import com.clustercontrol.performance.ejb.bmp.CollectorLocal;
import com.clustercontrol.performance.ejb.bmp.CollectorPK;
import com.clustercontrol.performance.ejb.bmp.CollectorUtil;
import com.clustercontrol.performance.util.JNDIConnectionManager;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;

public class CollectJob
implements Job {
    protected static Log m_log = LogFactory.getLog(CollectJob.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        block15: {
            JobDataMap dataMap = context.getJobDetail().getJobDataMap();
            CollectorPK pk = (CollectorPK)dataMap.get((Object)"pk");
            int collectorType = dataMap.getInt("type");
            m_log.debug((Object)("CollectJob execute : " + pk + "  type : " + collectorType));
            try {
                CollectorLocal bean = null;
                bean = CollectorUtil.getLocalHome().findByPrimaryKey(pk);
                if (bean.getCollectorID() == null || collectorType == 0) {
                    m_log.warn((Object)"\u6b63\u5e38\u306b\u521d\u671f\u5316\u3055\u308c\u3066\u3044\u306a\u3044 CollectorBean \u306b\u30a2\u30af\u30bb\u30b9\u3057\u307e\u3057\u305f\u3002");
                } else if (collectorType == 1) {
                    if (!bean.checkLifetime()) {
                        m_log.debug((Object)("\u53c2\u7167\u3055\u308c\u3066\u3044\u306a\u3044\u53ce\u96c6\u3092\u505c\u6b62  : " + pk.collectorID));
                        bean.stopCollect();
                        bean.remove();
                        return;
                    }
                    bean.fetchMibValue();
                } else if (collectorType == 2) {
                    bean.storeCalcValue();
                } else if (collectorType == 3) {
                    bean.monitorCalcValue();
                }
            }
            catch (NamingException e) {
                m_log.error((Object)e);
                if (collectorType == 1) {
                    this.deleteJob(pk.getCollectorID());
                }
            }
            catch (FinderException e) {
                m_log.error((Object)(pk.collectorID + " is already stopped."));
                m_log.error((Object)e);
                if (collectorType == 1) {
                    this.deleteJob(pk.getCollectorID());
                }
            }
            catch (EJBException e) {
                m_log.error((Object)e);
            }
            catch (RemoveException e) {
                m_log.error((Object)e);
                if (collectorType != 1) break block15;
                this.deleteJob(pk.getCollectorID());
            }
        }
    }

    private void deleteJob(String collectorId) {
        m_log.debug((Object)("deleteJob() start : " + collectorId));
        try {
            InitialContext iniCtx = JNDIConnectionManager.getInitialContext();
            Scheduler scheduler = (Scheduler)iniCtx.lookup(QuartzConstant.getQuartzName());
            scheduler.deleteJob(collectorId, "PERF_COLLECT");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (SchedulerException e) {
            m_log.error((Object)e);
        }
        m_log.debug((Object)("deleteJob() end   : " + collectorId));
    }
}

