/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.wsdl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import org.apache.ws.policy.Policy;
import org.apache.ws.policy.util.PolicyFactory;
import org.apache.ws.policy.util.PolicyWriter;
import org.jboss.ws.Constants;
import org.jboss.ws.WSException;
import org.jboss.ws.core.soap.Style;
import org.jboss.ws.extensions.policy.PolicyScopeLevel;
import org.jboss.ws.extensions.policy.metadata.PolicyMetaExtension;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.FaultMetaData;
import org.jboss.ws.metadata.umdm.MetaDataExtension;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ParameterMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.wsdl.Extendable;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLBindingFault;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperation;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperationInput;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperationOutput;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLExtensibilityElement;
import org.jboss.ws.metadata.wsdl.WSDLImport;
import org.jboss.ws.metadata.wsdl.WSDLInterface;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceFault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationInput;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutfault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutput;
import org.jboss.ws.metadata.wsdl.WSDLProperty;
import org.jboss.ws.metadata.wsdl.WSDLRPCPart;
import org.jboss.ws.metadata.wsdl.WSDLRPCSignatureItem;
import org.jboss.ws.metadata.wsdl.WSDLSOAPHeader;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.wsf.common.DOMUtils;
import org.w3c.dom.Element;

public abstract class WSDLGenerator {
    protected WSDLDefinitions wsdl;

    protected abstract void processTypes();

    protected void processEndpoint(WSDLService service, EndpointMetaData endpoint) {
        WSDLEndpoint wsdlEndpoint = new WSDLEndpoint(service, endpoint.getPortName());
        String address = endpoint.getEndpointAddress();
        wsdlEndpoint.setAddress(address == null ? "REPLACE_WITH_ACTUAL_URL" : address);
        service.addEndpoint(wsdlEndpoint);
        QName interfaceQName = endpoint.getPortTypeName();
        WSDLInterface wsdlInterface = new WSDLInterface(this.wsdl, interfaceQName);
        this.wsdl.addInterface(wsdlInterface);
        if (!interfaceQName.getNamespaceURI().equals(endpoint.getServiceMetaData().getServiceName().getNamespaceURI())) {
            WSDLImport wsdlImport = new WSDLImport(this.wsdl);
            wsdlImport.setLocation(interfaceQName.getLocalPart() + "_PortType");
            wsdlImport.setNamespace(interfaceQName.getNamespaceURI());
            this.wsdl.addImport(wsdlImport);
            this.wsdl.registerNamespaceURI(interfaceQName.getNamespaceURI(), null);
        }
        QName bindingQName = new QName(interfaceQName.getNamespaceURI(), interfaceQName.getLocalPart() + "Binding");
        WSDLBinding wsdlBinding = new WSDLBinding(this.wsdl, bindingQName);
        wsdlBinding.setInterfaceName(interfaceQName);
        this.wsdl.addBinding(wsdlBinding);
        wsdlEndpoint.setBinding(bindingQName);
        for (OperationMetaData operation : endpoint.getOperations()) {
            this.processOperation(wsdlInterface, wsdlBinding, operation);
        }
        MetaDataExtension ext = endpoint.getExtension("http://schemas.xmlsoap.org/ws/2004/09/policy");
        if (ext != null) {
            PolicyMetaExtension policyExt = (PolicyMetaExtension)ext;
            for (Policy policy : policyExt.getPolicies(PolicyScopeLevel.WSDL_PORT)) {
                this.addPolicyDefinition(policy);
                this.addPolicyReference(policy, wsdlEndpoint);
            }
            for (Policy policy : policyExt.getPolicies(PolicyScopeLevel.WSDL_PORT_TYPE)) {
                this.addPolicyDefinition(policy);
                this.addPolicyURIAttribute(policy, wsdlInterface);
            }
            for (Policy policy : policyExt.getPolicies(PolicyScopeLevel.WSDL_BINDING)) {
                this.addPolicyDefinition(policy);
                this.addPolicyReference(policy, wsdlBinding);
            }
        }
    }

    protected void addPolicyDefinition(Policy policy) {
        try {
            PolicyWriter writer = PolicyFactory.getPolicyWriter((int)2);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            writer.writePolicy(policy, (OutputStream)outputStream);
            Element element = DOMUtils.parse(outputStream.toString("UTF-8"));
            WSDLExtensibilityElement ext = new WSDLExtensibilityElement("http://www.jboss.org/jbossws/wsp/policy", element);
            this.wsdl.addExtensibilityElement(ext);
            if (this.wsdl.getPrefix(element.getNamespaceURI()) == null) {
                this.wsdl.registerNamespaceURI(element.getNamespaceURI(), element.getPrefix());
            }
        }
        catch (IOException ioe) {
            throw new WSException("Error while converting policy to element!");
        }
    }

    protected void addPolicyReference(Policy policy, Extendable extendable) {
        QName policyRefQName = Constants.WSDL_ELEMENT_WSP_POLICYREFERENCE;
        String prefix = this.wsdl.getPrefix(policyRefQName.getNamespaceURI());
        if (prefix == null) {
            prefix = "wsp";
            this.wsdl.registerNamespaceURI(policyRefQName.getNamespaceURI(), prefix);
        }
        Element element = DOMUtils.createElement(policyRefQName.getLocalPart(), prefix);
        element.setAttribute("URI", policy.getPolicyURI());
        WSDLExtensibilityElement ext = new WSDLExtensibilityElement("http://www.jboss.org/jbossws/wsp/policyReference", element);
        extendable.addExtensibilityElement(ext);
    }

    protected void addPolicyURIAttribute(Policy policy, Extendable extendable) {
        WSDLProperty prop = extendable.getProperty("http://www.jboss.org/jbossws/wsp/policyURIs");
        if (prop == null) {
            extendable.addProperty(new WSDLProperty("http://www.jboss.org/jbossws/wsp/policyURIs", policy.getPolicyURI()));
        } else {
            prop.setValue(prop.getValue() + "," + policy.getPolicyURI());
        }
    }

    protected void processOperation(WSDLInterface wsdlInterface, WSDLBinding wsdlBinding, OperationMetaData operation) {
        WSDLInterfaceOperation interfaceOperation = new WSDLInterfaceOperation(wsdlInterface, operation.getQName());
        WSDLBindingOperation bindingOperation = new WSDLBindingOperation(wsdlBinding);
        interfaceOperation.setPattern(operation.isOneWay() ? "http://www.w3.org/2004/08/wsdl/in-only" : "http://www.w3.org/2004/08/wsdl/in-out");
        bindingOperation.setRef(operation.getQName());
        bindingOperation.setSOAPAction(operation.getSOAPAction());
        if (operation.getStyle() == Style.DOCUMENT) {
            this.processOperationDOC(interfaceOperation, bindingOperation, operation);
        } else {
            this.processOperationRPC(interfaceOperation, bindingOperation, operation);
        }
        for (FaultMetaData fault : operation.getFaults()) {
            QName faultName = new QName(operation.getQName().getNamespaceURI(), fault.getXmlName().getLocalPart());
            WSDLInterfaceFault interfaceFault = new WSDLInterfaceFault(wsdlInterface, faultName);
            interfaceFault.setElement(fault.getXmlName());
            wsdlInterface.addFault(interfaceFault);
            WSDLInterfaceOperationOutfault outfault = new WSDLInterfaceOperationOutfault(interfaceOperation);
            outfault.setRef(faultName);
            interfaceOperation.addOutfault(outfault);
            WSDLBindingFault bindingFault = new WSDLBindingFault(wsdlBinding);
            bindingFault.setRef(faultName);
            wsdlBinding.addFault(bindingFault);
        }
        wsdlInterface.addOperation(interfaceOperation);
        wsdlBinding.addOperation(bindingOperation);
    }

    protected void addSignatureItem(WSDLInterfaceOperation operation, ParameterMetaData param, boolean isReturn) {
        WSDLRPCSignatureItem.Direction direction = isReturn ? WSDLRPCSignatureItem.Direction.RETURN : (param.getMode() == ParameterMode.INOUT ? WSDLRPCSignatureItem.Direction.INOUT : (param.getMode() == ParameterMode.OUT ? WSDLRPCSignatureItem.Direction.OUT : WSDLRPCSignatureItem.Direction.IN));
        operation.addRpcSignatureItem(new WSDLRPCSignatureItem(param.getPartName(), direction));
    }

    protected void processOperationDOC(WSDLInterfaceOperation interfaceOperation, WSDLBindingOperation bindingOperation, OperationMetaData operation) {
        boolean twoWay;
        interfaceOperation.setStyle("http://www.w3.org/2004/03/wsdl/style/iri");
        WSDLInterfaceOperationInput input = new WSDLInterfaceOperationInput(interfaceOperation);
        WSDLBindingOperationInput bindingInput = new WSDLBindingOperationInput(bindingOperation);
        WSDLInterfaceOperationOutput output = null;
        WSDLBindingOperationOutput bindingOutput = null;
        boolean bl = twoWay = !operation.isOneWay();
        if (twoWay) {
            output = new WSDLInterfaceOperationOutput(interfaceOperation);
            bindingOutput = new WSDLBindingOperationOutput(bindingOperation);
            ParameterMetaData returnParameter = operation.getReturnParameter();
            if (returnParameter != null) {
                QName xmlName = returnParameter.getXmlName();
                String partName = returnParameter.getPartName();
                if (returnParameter.isInHeader()) {
                    WSDLSOAPHeader header = new WSDLSOAPHeader(xmlName, partName);
                    header.setIncludeInSignature(true);
                    bindingOutput.addSoapHeader(header);
                } else {
                    output.setElement(xmlName);
                    output.setPartName(partName);
                }
                this.addSignatureItem(interfaceOperation, returnParameter, true);
            }
            interfaceOperation.addOutput(output);
            bindingOperation.addOutput(bindingOutput);
        }
        for (ParameterMetaData param : operation.getParameters()) {
            if (param.isInHeader()) {
                WSDLSOAPHeader header = new WSDLSOAPHeader(param.getXmlName(), param.getPartName());
                header.setIncludeInSignature(true);
                if (param.getMode() != ParameterMode.OUT) {
                    bindingInput.addSoapHeader(header);
                }
                if (twoWay && param.getMode() != ParameterMode.IN) {
                    bindingOutput.addSoapHeader(header);
                }
            } else {
                if (param.getMode() != ParameterMode.OUT) {
                    input.setElement(param.getXmlName());
                    input.setPartName(param.getPartName());
                }
                if (twoWay && param.getMode() != ParameterMode.IN) {
                    output.setElement(param.getXmlName());
                    output.setPartName(param.getPartName());
                }
            }
            this.addSignatureItem(interfaceOperation, param, false);
        }
        interfaceOperation.addInput(input);
        bindingOperation.addInput(bindingInput);
    }

    protected void processOperationRPC(WSDLInterfaceOperation interfaceOperation, WSDLBindingOperation bindingOperation, OperationMetaData operation) {
        boolean twoWay;
        interfaceOperation.setStyle("http://www.w3.org/2004/03/wsdl/style/rpc");
        WSDLInterfaceOperationInput input = new WSDLInterfaceOperationInput(interfaceOperation);
        WSDLBindingOperationInput bindingInput = new WSDLBindingOperationInput(bindingOperation);
        QName operationName = operation.getQName();
        input.setElement(operationName);
        WSDLInterfaceOperationOutput output = null;
        WSDLBindingOperationOutput bindingOutput = null;
        boolean bl = twoWay = !operation.isOneWay();
        if (twoWay) {
            output = new WSDLInterfaceOperationOutput(interfaceOperation);
            bindingOutput = new WSDLBindingOperationOutput(bindingOperation);
            output.setElement(new QName(operationName.getNamespaceURI(), operationName.getLocalPart() + "Response"));
            ParameterMetaData returnParameter = operation.getReturnParameter();
            if (returnParameter != null) {
                QName xmlName = returnParameter.getXmlName();
                String partName = returnParameter.getPartName();
                if (returnParameter.isInHeader()) {
                    WSDLSOAPHeader header = new WSDLSOAPHeader(xmlName, partName);
                    header.setIncludeInSignature(true);
                    bindingOutput.addSoapHeader(header);
                } else {
                    WSDLRPCPart part = new WSDLRPCPart(returnParameter.getPartName(), returnParameter.getXmlType());
                    output.addChildPart(part);
                }
                this.addSignatureItem(interfaceOperation, returnParameter, true);
            }
            interfaceOperation.addOutput(output);
            bindingOperation.addOutput(bindingOutput);
        }
        for (ParameterMetaData param : operation.getParameters()) {
            if (param.isInHeader()) {
                WSDLSOAPHeader header = new WSDLSOAPHeader(param.getXmlName(), param.getPartName());
                header.setIncludeInSignature(true);
                if (param.getMode() != ParameterMode.OUT) {
                    bindingInput.addSoapHeader(header);
                }
                if (twoWay && param.getMode() != ParameterMode.IN) {
                    bindingOutput.addSoapHeader(header);
                }
            } else {
                WSDLRPCPart part = new WSDLRPCPart(param.getPartName(), param.getXmlType());
                if (param.getMode() != ParameterMode.OUT) {
                    input.addChildPart(part);
                }
                if (twoWay && param.getMode() != ParameterMode.IN) {
                    output.addChildPart(part);
                }
            }
            this.addSignatureItem(interfaceOperation, param, false);
        }
        interfaceOperation.addInput(input);
        bindingOperation.addInput(bindingInput);
    }

    protected void processService(ServiceMetaData service) {
        WSDLService wsdlService = new WSDLService(this.wsdl, service.getServiceName());
        this.wsdl.addService(wsdlService);
        EndpointMetaData endpoint2 = null;
        for (EndpointMetaData endpoint2 : service.getEndpoints()) {
            this.processEndpoint(wsdlService, endpoint2);
        }
        if (endpoint2 == null) {
            throw new IllegalStateException("A service must have an endpoint");
        }
        wsdlService.setInterfaceName(endpoint2.getPortName());
    }

    public WSDLDefinitions generate(ServiceMetaData service) {
        this.wsdl = new WSDLDefinitions();
        this.wsdl.setWsdlNamespace("http://schemas.xmlsoap.org/wsdl/");
        String ns = service.getServiceName().getNamespaceURI();
        this.wsdl.setTargetNamespace(ns);
        this.wsdl.registerNamespaceURI(ns, "tns");
        this.wsdl.registerNamespaceURI("http://schemas.xmlsoap.org/wsdl/soap/", "soap");
        this.wsdl.registerNamespaceURI("http://www.w3.org/2001/XMLSchema", "xsd");
        this.processTypes();
        this.processService(service);
        return this.wsdl;
    }
}

