/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.policy.deployer.domainAssertion;

import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import org.apache.ws.policy.PrimitiveAssertion;
import org.jboss.logging.Logger;
import org.jboss.ws.extensions.policy.deployer.PolicyDeployer;
import org.jboss.ws.extensions.policy.deployer.domainAssertion.AssertionDeployer;
import org.jboss.ws.extensions.policy.deployer.exceptions.UnsupportedAssertion;
import org.jboss.ws.extensions.policy.deployer.util.PrimitiveAssertionWriter;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.ExtensibleMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.wsse.WSSecurityConfigFactory;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
import org.jboss.ws.metadata.wsse.WSSecurityOMFactory;

public class WSSecurityAssertionDeployer
implements AssertionDeployer {
    private static final Logger log = Logger.getLogger(PolicyDeployer.class);

    public void deployServerSide(PrimitiveAssertion assertion, ExtensibleMetaData extMetaData) throws UnsupportedAssertion {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        if (extMetaData instanceof EndpointMetaData) {
            EndpointMetaData ep = (EndpointMetaData)extMetaData;
            try {
                PrimitiveAssertionWriter.newInstance().writePrimitiveAssertion(assertion, stream);
                StringReader reader = new StringReader(stream.toString());
                WSSecurityConfiguration securityConfiguration = WSSecurityOMFactory.newInstance().parse(reader);
                WSSecurityConfigFactory.newInstance().initKeystorePath(ep.getRootFile(), securityConfiguration);
                ep.getServiceMetaData().setSecurityConfiguration(securityConfiguration);
                ep.setConfigName("Standard WSSecurity Endpoint");
                ep.initEndpointConfig();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new UnsupportedAssertion();
            }
        }
    }

    public void deployClientSide(PrimitiveAssertion assertion, ExtensibleMetaData extMetaData) throws UnsupportedAssertion {
        if (extMetaData instanceof EndpointMetaData) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            EndpointMetaData epMetaData = (EndpointMetaData)extMetaData;
            ServiceMetaData serviceMetaData = epMetaData.getServiceMetaData();
            if (serviceMetaData.getSecurityConfiguration() == null) {
                try {
                    PrimitiveAssertionWriter.newInstance().writePrimitiveAssertion(assertion, stream);
                    StringReader reader = new StringReader(stream.toString());
                    WSSecurityConfiguration securityConfiguration = WSSecurityOMFactory.newInstance().parse(reader);
                    serviceMetaData.setSecurityConfiguration(securityConfiguration);
                    epMetaData.setConfigName("Standard WSSecurity Client");
                    epMetaData.initEndpointConfig();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new UnsupportedAssertion();
                }
            }
        }
    }
}

