/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.jboss.logging.Logger;
import org.jboss.util.NotImplementedException;
import org.jboss.ws.core.soap.EnvelopeBuilder;
import org.jboss.ws.core.soap.EnvelopeBuilderDOM;
import org.jboss.ws.core.soap.NodeImpl;
import org.jboss.ws.core.soap.NodeListImpl;
import org.jboss.ws.core.soap.SOAPDocument;
import org.jboss.ws.core.soap.Style;
import org.jboss.wsf.spi.util.ServiceLoader;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

public class SOAPPartImpl
extends SOAPPart {
    private static Logger log = Logger.getLogger(SOAPPartImpl.class);
    private SOAPMessage soapMessage;
    private SOAPEnvelope soapEnvelope;
    private SOAPDocument doc = new SOAPDocument();

    SOAPPartImpl(SOAPMessage message) {
        this.soapMessage = message;
    }

    public SOAPMessage getSOAPMessage() {
        return this.soapMessage;
    }

    public SOAPEnvelope getEnvelope() throws SOAPException {
        return this.soapEnvelope;
    }

    public void setEnvelope(SOAPEnvelope soapEnvelope) {
        this.soapEnvelope = soapEnvelope;
    }

    public void removeMimeHeader(String s) {
        MimeHeaders mimeHeaders = this.soapMessage.getMimeHeaders();
        mimeHeaders.removeHeader(s);
    }

    public void removeAllMimeHeaders() {
        MimeHeaders mimeHeaders = this.soapMessage.getMimeHeaders();
        mimeHeaders.removeAllHeaders();
    }

    public String[] getMimeHeader(String name) {
        MimeHeaders mimeHeaders = this.soapMessage.getMimeHeaders();
        return mimeHeaders.getHeader(name);
    }

    public void setMimeHeader(String name, String value) {
        MimeHeaders mimeHeaders = this.soapMessage.getMimeHeaders();
        mimeHeaders.setHeader(name, value);
    }

    public void addMimeHeader(String name, String value) {
        MimeHeaders mimeHeaders = this.soapMessage.getMimeHeaders();
        mimeHeaders.addHeader(name, value);
    }

    public Iterator getAllMimeHeaders() {
        MimeHeaders mimeHeaders = this.soapMessage.getMimeHeaders();
        return mimeHeaders.getAllHeaders();
    }

    public Iterator getMatchingMimeHeaders(String[] names) {
        MimeHeaders mimeHeaders = this.soapMessage.getMimeHeaders();
        return mimeHeaders.getMatchingHeaders(names);
    }

    public Iterator getNonMatchingMimeHeaders(String[] names) {
        MimeHeaders mimeHeaders = this.soapMessage.getMimeHeaders();
        return mimeHeaders.getNonMatchingHeaders(names);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setContent(Source source) throws SOAPException {
        if (source == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Setting content source to null removes the SOAPEnvelope");
            }
            this.soapEnvelope = null;
            return;
        }
        if (source instanceof DOMSource) {
            Element domElement;
            DOMSource domSource = (DOMSource)source;
            Node node = domSource.getNode();
            if (node instanceof Document) {
                domElement = ((Document)node).getDocumentElement();
            } else {
                if (!(node instanceof Element)) throw new SOAPException("Unsupported DOMSource node: " + node);
                domElement = (Element)node;
            }
            EnvelopeBuilder envBuilder = (EnvelopeBuilder)ServiceLoader.loadService(EnvelopeBuilder.class.getName(), EnvelopeBuilderDOM.class.getName());
            envBuilder.setStyle(Style.DOCUMENT);
            envBuilder.build(this.soapMessage, domElement);
            return;
        }
        if (!(source instanceof StreamSource)) throw new SOAPException("Unsupported source parameter: " + source);
        try {
            StreamSource streamSource = (StreamSource)source;
            EnvelopeBuilder envBuilder = (EnvelopeBuilder)ServiceLoader.loadService(EnvelopeBuilder.class.getName(), EnvelopeBuilderDOM.class.getName());
            envBuilder.setStyle(Style.DOCUMENT);
            InputStream stream = streamSource.getInputStream();
            Reader reader = streamSource.getReader();
            if (stream != null) {
                envBuilder.build(this.soapMessage, stream, false);
                return;
            } else {
                if (reader == null) return;
                envBuilder.build(this.soapMessage, reader, false);
            }
            return;
        }
        catch (IOException e) {
            throw new SOAPException("Cannot parse stream source", (Throwable)e);
        }
    }

    public Source getContent() throws SOAPException {
        return new DOMSource((Node)this.soapEnvelope);
    }

    public DOMImplementation getImplementation() {
        return this.doc.getImplementation();
    }

    public DocumentFragment createDocumentFragment() {
        return this.doc.createDocumentFragment();
    }

    public DocumentType getDoctype() {
        return this.doc.getDoctype();
    }

    public Element getDocumentElement() {
        return this.soapEnvelope;
    }

    public Attr createAttribute(String name) throws DOMException {
        return this.doc.createAttribute(name);
    }

    public CDATASection createCDATASection(String data) throws DOMException {
        return this.doc.createCDATASection(data);
    }

    public Comment createComment(String data) {
        return this.doc.createComment(data);
    }

    public Element createElement(String tagName) throws DOMException {
        return this.doc.createElement(tagName);
    }

    public Element getElementById(String elementId) {
        return this.doc.getElementById(elementId);
    }

    public EntityReference createEntityReference(String name) throws DOMException {
        return this.doc.createEntityReference(name);
    }

    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        return this.doc.importNode(importedNode, deep);
    }

    public NodeList getElementsByTagName(String tagname) {
        return this.doc.getElementsByTagName(tagname);
    }

    public Text createTextNode(String data) {
        return this.doc.createTextNode(data);
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        return this.doc.createAttributeNS(namespaceURI, qualifiedName);
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        return this.doc.createElementNS(namespaceURI, qualifiedName);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.doc.getElementsByTagNameNS(namespaceURI, localName);
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        return this.doc.createProcessingInstruction(target, data);
    }

    public Node appendChild(Node node) throws DOMException {
        throw new NotImplementedException();
    }

    public Node cloneNode(boolean b) {
        throw new NotImplementedException();
    }

    public NamedNodeMap getAttributes() {
        throw new NotImplementedException();
    }

    public NodeList getChildNodes() {
        ArrayList<NodeImpl> list = new ArrayList<NodeImpl>();
        if (this.soapEnvelope != null) {
            list.add((NodeImpl)this.soapEnvelope);
        }
        return new NodeListImpl(list);
    }

    public Node getFirstChild() {
        return this.soapEnvelope;
    }

    public Node getLastChild() {
        return this.soapEnvelope;
    }

    public String getLocalName() {
        throw new NotImplementedException();
    }

    public String getNamespaceURI() {
        throw new NotImplementedException();
    }

    public Node getNextSibling() {
        throw new NotImplementedException();
    }

    public String getNodeName() {
        return this.doc.getNodeName();
    }

    public short getNodeType() {
        return this.doc.getNodeType();
    }

    public String getNodeValue() throws DOMException {
        throw new NotImplementedException();
    }

    public Document getOwnerDocument() {
        return this.doc;
    }

    public Node getParentNode() {
        throw new NotImplementedException();
    }

    public String getPrefix() {
        throw new NotImplementedException();
    }

    public Node getPreviousSibling() {
        throw new NotImplementedException();
    }

    public boolean hasAttributes() {
        throw new NotImplementedException();
    }

    public boolean hasChildNodes() {
        throw new NotImplementedException();
    }

    public Node insertBefore(Node node, Node node1) throws DOMException {
        throw new NotImplementedException();
    }

    public boolean isSupported(String s, String s1) {
        throw new NotImplementedException();
    }

    public void normalize() {
        throw new NotImplementedException();
    }

    public Node removeChild(Node node) throws DOMException {
        throw new NotImplementedException();
    }

    public Node replaceChild(Node node, Node node1) throws DOMException {
        throw new NotImplementedException();
    }

    public void setNodeValue(String s) throws DOMException {
        throw new NotImplementedException();
    }

    public void setPrefix(String s) throws DOMException {
        throw new NotImplementedException();
    }

    public Node adoptNode(Node source) throws DOMException {
        throw new NotImplementedException("adoptNode");
    }

    public String getDocumentURI() {
        throw new NotImplementedException("getDocumentURI");
    }

    public DOMConfiguration getDomConfig() {
        throw new NotImplementedException("getDomConfig");
    }

    public String getInputEncoding() {
        throw new NotImplementedException("getInputEncoding");
    }

    public boolean getStrictErrorChecking() {
        throw new NotImplementedException("getStrictErrorChecking");
    }

    public String getXmlEncoding() {
        throw new NotImplementedException("getXmlEncoding");
    }

    public boolean getXmlStandalone() {
        throw new NotImplementedException("getXmlStandalone");
    }

    public String getXmlVersion() {
        throw new NotImplementedException("getXmlVersion");
    }

    public void normalizeDocument() {
        throw new NotImplementedException("normalizeDocument");
    }

    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        throw new NotImplementedException("renameNode");
    }

    public void setDocumentURI(String documentURI) {
        throw new NotImplementedException("setDocumentURI");
    }

    public void setStrictErrorChecking(boolean strictErrorChecking) {
        throw new NotImplementedException("setStrictErrorChecking");
    }

    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
        throw new NotImplementedException("setXmlStandalone");
    }

    public void setXmlVersion(String xmlVersion) throws DOMException {
        throw new NotImplementedException("setXmlVersion");
    }

    public short compareDocumentPosition(Node other) throws DOMException {
        throw new NotImplementedException("compareDocumentPosition");
    }

    public String getBaseURI() {
        throw new NotImplementedException("getBaseURI");
    }

    public Object getFeature(String feature, String version) {
        throw new NotImplementedException("getFeature");
    }

    public String getTextContent() throws DOMException {
        throw new NotImplementedException("getTextContent");
    }

    public Object getUserData(String key) {
        throw new NotImplementedException("getUserData");
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        throw new NotImplementedException("isDefaultNamespace");
    }

    public boolean isEqualNode(Node arg) {
        throw new NotImplementedException("isEqualNode");
    }

    public boolean isSameNode(Node other) {
        throw new NotImplementedException("isSameNode");
    }

    public String lookupNamespaceURI(String prefix) {
        throw new NotImplementedException("lookupNamespaceURI");
    }

    public String lookupPrefix(String namespaceURI) {
        throw new NotImplementedException("lookupPrefix");
    }

    public void setTextContent(String textContent) throws DOMException {
        throw new NotImplementedException("setTextContent");
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        throw new NotImplementedException("setUserData");
    }

    public void detachNode() {
        throw new NotImplementedException();
    }

    public SOAPElement getParentElement() {
        throw new NotImplementedException();
    }

    public String getValue() {
        throw new NotImplementedException();
    }

    public void recycleNode() {
        throw new NotImplementedException();
    }

    public void setParentElement(SOAPElement parent) throws SOAPException {
        throw new NotImplementedException();
    }

    public void setValue(String value) {
        throw new NotImplementedException();
    }
}

