/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmptrap.factory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoLocal;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoPK;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoUtil;
import com.clustercontrol.notify.ejb.session.NotifyControllerLocal;
import com.clustercontrol.notify.ejb.session.NotifyControllerUtil;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapInfoLocal;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapInfoPK;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapInfoUtil;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapOidInfoLocal;
import com.clustercontrol.snmptrap.message.UpdateSnmpTrapInfo;
import com.clustercontrol.snmptrap.util.SendTopic;
import com.clustercontrol.util.apllog.AplLogger;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.jms.JMSException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeleteMonitorInfo {
    protected static Log m_log = LogFactory.getLog(DeleteMonitorInfo.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean delete(String monitorId) throws NotSupportedException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException, InvalidTransactionException, NamingException, FinderException, RemoveException {
        AccessLock.lock((String)"MONITOR_SNMPTRAP");
        TransactionManager tm = null;
        Transaction oldTx = null;
        boolean result = false;
        try {
            block24: {
                InitialContext context = new InitialContext();
                tm = (TransactionManager)context.lookup("java:/TransactionManager");
                if (tm.getTransaction() != null) {
                    oldTx = tm.suspend();
                }
                try {
                    if (tm.getTransaction() == null) {
                        tm.begin();
                    }
                    if (result = this.deleteMonitorInfo(monitorId)) {
                        tm.commit();
                    }
                    try {
                        UpdateSnmpTrapInfo updateInfo = new UpdateSnmpTrapInfo(2, monitorId);
                        SendTopic sendTopic = new SendTopic("topic/clustercontrolSnmpTrapUpdate");
                        sendTopic.put(updateInfo);
                    }
                    catch (NamingException e) {
                        m_log.error((Object)("delete() : \u9001\u4fe1\u30a8\u30e9\u30fc\u3002" + e.getMessage()));
                    }
                    catch (JMSException e) {
                        m_log.error((Object)("delete() : \u9001\u4fe1\u30a8\u30e9\u30fc\u3002" + e.getMessage()));
                    }
                    Object var9_15 = null;
                }
                catch (Throwable throwable) {
                    Object var9_16 = null;
                    if (tm.getTransaction() == null || result) throw throwable;
                    tm.rollback();
                    throw throwable;
                }
                if (tm.getTransaction() != null && !result) {
                    tm.rollback();
                }
                break block24;
                {
                    catch (NotSupportedException e) {
                        this.outputLog((Exception)((Object)e), "delete()", monitorId);
                        throw e;
                    }
                    catch (RollbackException e) {
                        this.outputLog((Exception)((Object)e), "delete()", monitorId);
                        throw e;
                    }
                    catch (HeuristicMixedException e) {
                        this.outputLog((Exception)((Object)e), "delete()", monitorId);
                        throw e;
                    }
                    catch (HeuristicRollbackException e) {
                        this.outputLog((Exception)((Object)e), "delete()", monitorId);
                        throw e;
                    }
                    catch (SystemException e) {
                        this.outputLog((Exception)((Object)e), "delete()", monitorId);
                        throw e;
                    }
                }
            }
            Object var11_18 = null;
            if (oldTx == null) return result;
        }
        catch (Throwable throwable) {
            Object var11_19 = null;
            if (oldTx == null) throw throwable;
            try {
                tm.resume(oldTx);
                throw throwable;
            }
            catch (InvalidTransactionException e) {
                this.outputLog((Exception)((Object)e), "delete()", monitorId);
                throw e;
            }
            catch (IllegalStateException e) {
                this.outputLog(e, "delete()", monitorId);
                throw e;
            }
            catch (SystemException e) {
                this.outputLog((Exception)((Object)e), "delete()", monitorId);
                throw e;
            }
        }
        try {
            tm.resume(oldTx);
            return result;
        }
        catch (InvalidTransactionException e) {
            this.outputLog((Exception)((Object)e), "delete()", monitorId);
            throw e;
        }
        catch (IllegalStateException e) {
            this.outputLog(e, "delete()", monitorId);
            throw e;
        }
        catch (SystemException e) {
            this.outputLog((Exception)((Object)e), "delete()", monitorId);
            throw e;
        }
    }

    public boolean deleteMonitorInfo(String monitorId) throws NamingException, FinderException, RemoveException {
        boolean result = false;
        try {
            SnmpTrapInfoLocal info = SnmpTrapInfoUtil.getLocalHome().findByPrimaryKey(new SnmpTrapInfoPK(monitorId));
            Collection ct = info.getSnmpTrapOidInfo();
            if (ct != null && ct.size() > 0) {
                Object[] infoArray = ct.toArray();
                for (int j = 0; j < infoArray.length; ++j) {
                    SnmpTrapOidInfoLocal oidInfo = (SnmpTrapOidInfoLocal)infoArray[j];
                    if (oidInfo == null) continue;
                    oidInfo.remove();
                }
            }
            NotifyControllerLocal nc = NotifyControllerUtil.getLocalHome().create();
            nc.deleteNotifyRelation(info.getNotifyGroupId());
            nc.deleteNotifyInhibition(info.getNotifyGroupId());
            try {
                MonitorInfoPK mipk = new MonitorInfoPK(info.getMonitorId(), "MON_SNMP_TRP");
                MonitorInfoLocal infoLocal = MonitorInfoUtil.getLocalHome().findByPrimaryKey(mipk);
                infoLocal.remove();
            }
            catch (FinderException e) {
                m_log.warn((Object)("deleteMonitorInfo(): MonitorInfo not found '" + monitorId + "', " + e.getMessage()));
            }
            info.remove();
            result = true;
        }
        catch (NamingException e) {
            this.outputLog(e, "deleteMonitorInfo()", monitorId);
            throw e;
        }
        catch (FinderException e) {
            this.outputLog((Exception)((Object)e), "deleteMonitorInfo()", monitorId);
            throw e;
        }
        catch (EJBException e) {
            this.outputLog((Exception)((Object)e), "deleteMonitorInfo()", monitorId);
            throw e;
        }
        catch (RemoveException e) {
            this.outputLog((Exception)((Object)e), "deleteMonitorInfo()", monitorId);
            throw e;
        }
        catch (CreateException e) {
            this.outputLog((Exception)((Object)e), "deleteMonitorInfo()", monitorId);
            e.printStackTrace();
        }
        return result;
    }

    private void outputLog(Exception e, String method, String monitorId) {
        AplLogger apllog = new AplLogger("TRAP", "trap");
        Object[] args = new String[]{monitorId};
        apllog.put("SYS", "003", args);
        m_log.debug((Object)(method + ":" + e.getMessage()));
    }
}

