/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.asynchronous.concurrent;

import java.util.ResourceBundle;
import org.jboss.aspects.asynchronous.AsynchronousParameters;
import org.jboss.aspects.asynchronous.AsynchronousUserTask;
import org.jboss.aspects.asynchronous.ThreadManager;
import org.jboss.aspects.asynchronous.ThreadManagerRequest;
import org.jboss.aspects.asynchronous.common.ThreadManagerRequestImpl;
import org.jboss.aspects.asynchronous.concurrent.ThreadManagerImpl;

public class ThreadManagerFactory {
    protected ThreadManager threadManager;
    protected String DEFAULT_MIN_THREAD = "10";
    protected String DEFAULT_MAX_THREAD = "100";
    protected String DEFAULT_KEEP_ALIVE = "5000";
    protected String DEFAULT_IS_WAITING_WHEN_POOLSIZE_FULL = "FALSE";
    protected String DEFAULT_IS_POOLING = "TRUE";
    protected static String MIN_POOL_SIZE = "threadManager.minimumPoolsize";
    protected static String MAX_POOL_SIZE = "threadManager.maximumPoolsize";
    protected static String KEEP_ALIVE = "threadManager.keepAlive";
    protected static String IS_WAITING_WHEN_POOLSIZE_FULL = "threadManager.isWaitingWhenPoolSize";
    protected static String IS_POOLING = "threadManager.isPooling";
    protected static String PROPERTY_FILE = "org.jboss.aspects.asynchronous.threadManager";
    protected static final ThreadManagerFactory threadManagerFactory = new ThreadManagerFactory();
    protected static ResourceBundle rb;

    static void initResourceBundle() {
        try {
            rb = ResourceBundle.getBundle(PROPERTY_FILE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getString(String key, String defaultValue) {
        try {
            if (rb == null) {
                return defaultValue;
            }
            String value = rb.getString(key);
            if (value == null) {
                return defaultValue;
            }
            return value;
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    protected ThreadManagerFactory() {
        ThreadManagerFactory.initResourceBundle();
        this.threadManager = new ThreadManagerImpl();
        this.threadManager.setMinimumPoolSize(Integer.parseInt(ThreadManagerFactory.getString(MIN_POOL_SIZE, this.DEFAULT_MIN_THREAD)));
        this.threadManager.setMaximumPoolSize(Integer.parseInt(ThreadManagerFactory.getString(MAX_POOL_SIZE, this.DEFAULT_MAX_THREAD)));
        this.threadManager.setKeepAliveTime(Integer.parseInt(ThreadManagerFactory.getString(KEEP_ALIVE, this.DEFAULT_KEEP_ALIVE)));
        this.threadManager.setWaitWhenPoolSizeIsFull(Boolean.valueOf(ThreadManagerFactory.getString(IS_WAITING_WHEN_POOLSIZE_FULL, this.DEFAULT_IS_WAITING_WHEN_POOLSIZE_FULL)));
        this.threadManager.setPooling(Boolean.valueOf(ThreadManagerFactory.getString(IS_POOLING, this.DEFAULT_IS_POOLING)));
    }

    public static ThreadManager getThreadManager() {
        return ThreadManagerFactory.threadManagerFactory.threadManager;
    }

    public static ThreadManagerRequest createNewThreadManagerRequest(String id, AsynchronousParameters inputParameters, AsynchronousUserTask taskClassNameImpl, long timeout) {
        return new ThreadManagerRequestImpl(id, inputParameters, taskClassNameImpl, timeout);
    }
}

