/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.debug.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.apache.bsf.debug.util.IntHashMapEntry;

public class IntHashtable
implements Cloneable {
    int elementCount;
    IntHashMapEntry[] elementData;
    private int loadFactor;
    private int threshold;

    public IntHashtable() {
        this(101);
    }

    public IntHashtable(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.elementCount = 0;
        this.elementData = new IntHashMapEntry[n == 0 ? 1 : n];
        this.loadFactor = 7500;
        this.computeMaxSize();
    }

    public IntHashtable(int n, float f) {
        if (n < 0 || f <= 0.0f) {
            throw new IllegalArgumentException();
        }
        this.elementCount = 0;
        this.elementData = new IntHashMapEntry[n];
        this.loadFactor = (int)(f * 10000.0f);
        this.computeMaxSize();
    }

    public synchronized void clear() {
        this.elementCount = 0;
        int n = this.elementData.length;
        while (--n >= 0) {
            this.elementData[n] = null;
        }
    }

    public synchronized Object clone() {
        try {
            IntHashtable intHashtable = (IntHashtable)super.clone();
            intHashtable.elementData = (IntHashMapEntry[])this.elementData.clone();
            int n = this.elementData.length;
            while (--n >= 0) {
                IntHashMapEntry intHashMapEntry = this.elementData[n];
                if (intHashMapEntry == null) continue;
                intHashtable.elementData[n] = (IntHashMapEntry)intHashMapEntry.clone();
            }
            return intHashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private void computeMaxSize() {
        this.threshold = (int)((long)this.elementData.length * (long)this.loadFactor / 10000L);
    }

    public synchronized boolean contains(Object object) {
        int n = this.elementData.length;
        while (--n >= 0) {
            IntHashMapEntry intHashMapEntry = this.elementData[n];
            while (intHashMapEntry != null) {
                if (intHashMapEntry.value == object || intHashMapEntry.value.equals(object)) {
                    return true;
                }
                intHashMapEntry = intHashMapEntry.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(int n) {
        return this.getEntry(n) != null;
    }

    public synchronized Enumeration elements() {
        return new HashEnumerator(this.elementData);
    }

    public synchronized Object get(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.elementData.length;
        IntHashMapEntry intHashMapEntry = this.elementData[n2];
        while (intHashMapEntry != null) {
            if (intHashMapEntry.key == n) {
                return intHashMapEntry.value;
            }
            intHashMapEntry = intHashMapEntry.next;
        }
        return null;
    }

    private IntHashMapEntry getEntry(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.elementData.length;
        IntHashMapEntry intHashMapEntry = this.elementData[n2];
        while (intHashMapEntry != null) {
            if (intHashMapEntry.key == n) {
                return intHashMapEntry;
            }
            intHashMapEntry = intHashMapEntry.next;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public synchronized Object put(int n, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        int n2 = (n & Integer.MAX_VALUE) % this.elementData.length;
        IntHashMapEntry intHashMapEntry = this.elementData[n2];
        while (intHashMapEntry != null && intHashMapEntry.key != n) {
            intHashMapEntry = intHashMapEntry.next;
        }
        if (intHashMapEntry == null) {
            if (++this.elementCount > this.threshold) {
                this.rehash();
                n2 = (n & Integer.MAX_VALUE) % this.elementData.length;
            }
            intHashMapEntry = new IntHashMapEntry(n, object);
            intHashMapEntry.next = this.elementData[n2];
            this.elementData[n2] = intHashMapEntry;
            return null;
        }
        Object object2 = intHashMapEntry.value;
        intHashMapEntry.value = object;
        return object2;
    }

    protected void rehash() {
        int n = this.elementData.length << 1;
        if (n == 0) {
            n = 1;
        }
        IntHashMapEntry[] intHashMapEntryArray = new IntHashMapEntry[n];
        int n2 = this.elementData.length;
        while (--n2 >= 0) {
            IntHashMapEntry intHashMapEntry = this.elementData[n2];
            while (intHashMapEntry != null) {
                int n3 = (intHashMapEntry.key & Integer.MAX_VALUE) % n;
                IntHashMapEntry intHashMapEntry2 = intHashMapEntry.next;
                intHashMapEntry.next = intHashMapEntryArray[n3];
                intHashMapEntryArray[n3] = intHashMapEntry;
                intHashMapEntry = intHashMapEntry2;
            }
        }
        this.elementData = intHashMapEntryArray;
        this.computeMaxSize();
    }

    public synchronized Object remove(int n) {
        IntHashMapEntry intHashMapEntry = null;
        int n2 = (n & Integer.MAX_VALUE) % this.elementData.length;
        IntHashMapEntry intHashMapEntry2 = this.elementData[n2];
        while (intHashMapEntry2 != null && intHashMapEntry2.key != n) {
            intHashMapEntry = intHashMapEntry2;
            intHashMapEntry2 = intHashMapEntry2.next;
        }
        if (intHashMapEntry2 != null) {
            if (intHashMapEntry == null) {
                this.elementData[n2] = intHashMapEntry2.next;
            } else {
                intHashMapEntry.next = intHashMapEntry2.next;
            }
            --this.elementCount;
            return intHashMapEntry2.value;
        }
        return null;
    }

    public int size() {
        return this.elementCount;
    }

    public synchronized String toString() {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        int n = this.elementData.length;
        while (--n >= 0) {
            IntHashMapEntry intHashMapEntry = this.elementData[n];
            while (intHashMapEntry != null) {
                stringBuffer.append(intHashMapEntry.key);
                stringBuffer.append('=');
                stringBuffer.append(intHashMapEntry.value);
                stringBuffer.append(',');
                intHashMapEntry = intHashMapEntry.next;
            }
        }
        if (this.elementCount > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    private static final class HashEnumerator
    implements Enumeration {
        IntHashMapEntry[] array;
        int start;
        int end;
        IntHashMapEntry entry;

        HashEnumerator(IntHashMapEntry[] intHashMapEntryArray) {
            this.array = intHashMapEntryArray;
            this.start = 0;
            this.end = this.array.length;
        }

        public boolean hasMoreElements() {
            if (this.entry != null) {
                return true;
            }
            while (this.start < this.end) {
                if (this.array[this.start] == null) {
                    ++this.start;
                    continue;
                }
                return true;
            }
            return false;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                if (this.entry == null) {
                    this.entry = this.array[this.start++];
                }
                Object object = this.entry.value;
                this.entry = this.entry.next;
                return object;
            }
            throw new NoSuchElementException();
        }
    }
}

