/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc2;

import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.cmp.jdbc.EJBQLToSQL92Compiler;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQlQueryMetaData;
import org.jboss.ejb.plugins.cmp.jdbc2.AbstractQueryCommand;
import org.jboss.ejb.plugins.cmp.jdbc2.JDBCStoreManager2;
import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCCMPFieldBridge2;
import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCEntityBridge2;
import org.jboss.logging.Logger;

public class EJBQLQueryCommand
extends AbstractQueryCommand {
    public EJBQLQueryCommand(JDBCEntityBridge2 entity, JDBCQlQueryMetaData metadata) throws DeploymentException {
        this.entity = entity;
        JDBCStoreManager2 manager = (JDBCStoreManager2)entity.getManager();
        EJBQLToSQL92Compiler compiler = new EJBQLToSQL92Compiler(manager.getCatalog());
        try {
            compiler.compileEJBQL(metadata.getEjbQl(), metadata.getMethod().getReturnType(), metadata.getMethod().getParameterTypes(), metadata);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new DeploymentException("Error compiling EJBQL statement '" + metadata.getEjbQl() + "'", t);
        }
        this.sql = compiler.getSQL();
        this.log = Logger.getLogger((String)(this.getClass().getName() + "." + entity.getEntityName() + "#" + metadata.getMethod().getName()));
        this.log.debug((Object)("sql: " + this.sql));
        this.setParameters(compiler.getInputParameters());
        this.setResultType(metadata.getMethod().getReturnType());
        if (!compiler.isSelectEntity()) {
            if (compiler.isSelectField()) {
                this.setFieldReader((JDBCCMPFieldBridge2)compiler.getSelectField());
            } else {
                this.setFunctionReader(compiler.getSelectFunction());
            }
        } else {
            this.setEntityReader((JDBCEntityBridge2)compiler.getSelectEntity(), compiler.isSelectDistinct());
        }
    }
}

